/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.azure;

import com.hazelcast.azure.PortRange;
import com.hazelcast.azure.Tag;

final class AzureConfig {
    private String tenantId;
    private String clientId;
    private String clientSecret;
    private String subscriptionId;
    private String resourceGroup;
    private String scaleSet;
    private Tag tag;
    private PortRange hzPort;
    private Boolean instanceMetadataAvailable;

    private AzureConfig() {
    }

    static Builder builder() {
        return new Builder();
    }

    String getTenantId() {
        return this.tenantId;
    }

    String getSubscriptionId() {
        return this.subscriptionId;
    }

    String getClientId() {
        return this.clientId;
    }

    String getClientSecret() {
        return this.clientSecret;
    }

    String getResourceGroup() {
        return this.resourceGroup;
    }

    String getScaleSet() {
        return this.scaleSet;
    }

    Tag getTag() {
        return this.tag;
    }

    PortRange getHzPort() {
        return this.hzPort;
    }

    public Boolean isInstanceMetadataAvailable() {
        return this.instanceMetadataAvailable;
    }

    static final class Builder {
        private final AzureConfig config = new AzureConfig();

        private Builder() {
        }

        Builder setTenantId(String tenantId) {
            this.config.tenantId = tenantId;
            return this;
        }

        Builder setSubscriptionId(String subscriptionId) {
            this.config.subscriptionId = subscriptionId;
            return this;
        }

        Builder setClientId(String clientId) {
            this.config.clientId = clientId;
            return this;
        }

        Builder setClientSecret(String clientSecret) {
            this.config.clientSecret = clientSecret;
            return this;
        }

        Builder setResourceGroup(String resourceGroup) {
            this.config.resourceGroup = resourceGroup;
            return this;
        }

        Builder setScaleSet(String scaleSet) {
            this.config.scaleSet = scaleSet;
            return this;
        }

        Builder setTag(Tag tag) {
            this.config.tag = tag;
            return this;
        }

        Builder setHzPort(PortRange hzPort) {
            this.config.hzPort = hzPort;
            return this;
        }

        Builder setInstanceMetadataAvailable(Boolean instanceMetadataAvailable) {
            this.config.instanceMetadataAvailable = instanceMetadataAvailable;
            return this;
        }

        AzureConfig build() {
            return this.config;
        }
    }
}

