/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.worker;

import com.hazelcast.sql.impl.exec.Exec;
import com.hazelcast.sql.impl.exec.IterationResult;
import com.hazelcast.sql.impl.exec.io.InboundBatch;
import com.hazelcast.sql.impl.exec.io.InboundHandler;
import com.hazelcast.sql.impl.exec.io.OutboundHandler;
import com.hazelcast.sql.impl.operation.QueryAbstractExchangeOperation;
import com.hazelcast.sql.impl.operation.QueryBatchExchangeOperation;
import com.hazelcast.sql.impl.operation.QueryFlowControlExchangeOperation;
import com.hazelcast.sql.impl.state.QueryStateCallback;
import com.hazelcast.sql.impl.worker.QueryFragmentContext;
import com.hazelcast.sql.impl.worker.QueryFragmentScheduleCallback;
import com.hazelcast.sql.impl.worker.QueryFragmentWorkerPool;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class QueryFragmentExecutable
implements QueryFragmentScheduleCallback {
    private static final Object RESCHEDULE_OPERATION = new Object();
    private final QueryStateCallback stateCallback;
    private final List<Object> arguments;
    private final Exec exec;
    private final Map<Integer, InboundHandler> inboxes;
    private final Map<Integer, Map<UUID, OutboundHandler>> outboxes;
    private final QueryFragmentWorkerPool fragmentPool;
    private final ConcurrentLinkedDeque<Object> operations = new ConcurrentLinkedDeque();
    private final AtomicInteger operationCount = new AtomicInteger();
    private final AtomicBoolean scheduled = new AtomicBoolean();
    private volatile boolean initialized;
    private volatile boolean completed;

    public QueryFragmentExecutable(QueryStateCallback stateCallback, List<Object> arguments, Exec exec, Map<Integer, InboundHandler> inboxes, Map<Integer, Map<UUID, OutboundHandler>> outboxes, QueryFragmentWorkerPool fragmentPool) {
        this.stateCallback = stateCallback;
        this.arguments = arguments;
        this.exec = exec;
        this.inboxes = inboxes;
        this.outboxes = outboxes;
        this.fragmentPool = fragmentPool;
    }

    public Collection<Integer> getInboxEdgeIds() {
        return this.inboxes.keySet();
    }

    public Collection<Integer> getOutboxEdgeIds() {
        return this.outboxes.keySet();
    }

    public void addOperation(Object operation) {
        this.operationCount.incrementAndGet();
        this.operations.addLast(operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Object operation;
            if (this.completed) {
                return;
            }
            this.setupExecutor();
            int maxOperationCount = this.operationCount.get();
            int processedBatchCount = 0;
            while ((operation = this.operations.pollFirst()) != null) {
                QueryAbstractExchangeOperation operation0;
                if (operation instanceof QueryBatchExchangeOperation) {
                    operation0 = (QueryBatchExchangeOperation)operation;
                    InboundHandler inbox = this.inboxes.get(operation0.getEdgeId());
                    assert (inbox != null);
                    InboundBatch batch = new InboundBatch(((QueryBatchExchangeOperation)operation0).getBatch(), ((QueryBatchExchangeOperation)operation0).isLast(), operation0.getCallerId());
                    inbox.onBatch(batch, ((QueryBatchExchangeOperation)operation0).getRemainingMemory());
                } else if (operation instanceof QueryFlowControlExchangeOperation) {
                    operation0 = (QueryFlowControlExchangeOperation)operation;
                    Map<UUID, OutboundHandler> edgeOutboxes = this.outboxes.get(operation0.getEdgeId());
                    assert (edgeOutboxes != null);
                    OutboundHandler outbox = edgeOutboxes.get(operation0.getCallerId());
                    assert (outbox != null);
                    outbox.onFlowControl(((QueryFlowControlExchangeOperation)operation0).getRemainingMemory());
                } else assert (operation == RESCHEDULE_OPERATION);
                if (++processedBatchCount < maxOperationCount) continue;
            }
            this.operationCount.addAndGet(-1 * processedBatchCount);
            IterationResult res = this.exec.advance();
            if (res != IterationResult.FETCHED_DONE) {
                for (InboundHandler inbox : this.inboxes.values()) {
                    inbox.onFragmentExecutionCompleted();
                }
            }
            if (res == IterationResult.FETCHED_DONE) {
                this.completed = true;
                this.stateCallback.onFragmentFinished();
            }
        }
        catch (Exception e) {
            this.completed = true;
            this.stateCallback.cancel(e, false);
        }
        finally {
            this.unscheduleOrReschedule();
        }
    }

    @Override
    public boolean schedule(boolean force) {
        boolean res;
        if (force) {
            this.operations.add(RESCHEDULE_OPERATION);
        }
        boolean bl = res = !this.scheduled.get() && this.scheduled.compareAndSet(false, true);
        if (res) {
            this.submit();
        }
        return res;
    }

    private void unscheduleOrReschedule() {
        boolean completed0 = this.completed;
        if (!completed0 && !this.operations.isEmpty()) {
            this.submit();
            return;
        }
        this.scheduled.set(false);
        if (!completed0 && !this.operations.isEmpty()) {
            this.schedule();
        }
    }

    private void submit() {
        this.fragmentPool.submit(this);
    }

    private void setupExecutor() {
        if (this.initialized) {
            return;
        }
        try {
            this.exec.setup(new QueryFragmentContext(this.arguments, this, this.stateCallback));
        }
        finally {
            this.initialized = true;
        }
    }
}

