/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema.map;

import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableResolver;
import com.hazelcast.sql.impl.schema.map.JetMapMetadataResolver;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractMapTableResolver
implements TableResolver {
    protected final NodeEngine nodeEngine;
    protected final JetMapMetadataResolver jetMapMetadataResolver;
    private final List<List<String>> defaultSearchPaths;

    protected AbstractMapTableResolver(NodeEngine nodeEngine, JetMapMetadataResolver jetMapMetadataResolver, List<List<String>> defaultSearchPaths) {
        this.nodeEngine = nodeEngine;
        this.jetMapMetadataResolver = jetMapMetadataResolver;
        this.defaultSearchPaths = defaultSearchPaths;
    }

    @Override
    public List<List<String>> getDefaultSearchPaths() {
        return this.defaultSearchPaths;
    }

    protected static List<TableField> mergeMapFields(Map<String, TableField> keyFields, Map<String, TableField> valueFields) {
        LinkedHashMap<String, TableField> res = new LinkedHashMap<String, TableField>(keyFields);
        for (Map.Entry<String, TableField> valueFieldEntry : valueFields.entrySet()) {
            res.putIfAbsent(valueFieldEntry.getKey(), valueFieldEntry.getValue());
        }
        return new ArrayList<TableField>(res.values());
    }
}

