/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.io;

import com.hazelcast.sql.impl.exec.Exec;
import com.hazelcast.sql.impl.exec.io.AbstractSendExec;
import com.hazelcast.sql.impl.exec.io.AlwaysTrueOutboxSendQualifier;
import com.hazelcast.sql.impl.exec.io.Outbox;
import com.hazelcast.sql.impl.exec.io.OutboxSendQualifier;
import com.hazelcast.sql.impl.row.RowBatch;
import com.hazelcast.sql.impl.worker.QueryFragmentContext;

public class SendExec
extends AbstractSendExec {
    private final Outbox outbox;
    private int pendingPosition;

    public SendExec(int id, Exec upstream, Outbox outbox) {
        super(id, upstream);
        this.outbox = outbox;
    }

    @Override
    protected void setup1(QueryFragmentContext ctx) {
        this.outbox.setup();
    }

    @Override
    protected int getOutboxCount() {
        return 1;
    }

    @Override
    protected Outbox getOutbox(int outboxIndex) {
        return this.outbox;
    }

    @Override
    protected void setCurrentBatch(RowBatch batch) {
    }

    @Override
    protected OutboxSendQualifier getOutboxQualifier(int outboxIndex) {
        return this.getOutboxQualifier();
    }

    @Override
    protected void addPendingPosition(int outboxIndex, int position) {
        this.pendingPosition = position;
    }

    @Override
    protected boolean pushPendingBatch(RowBatch pendingBatch, boolean pendingLast) {
        int newPosition = this.outbox.onRowBatch(pendingBatch, pendingLast, this.pendingPosition, this.getOutboxQualifier());
        if (newPosition == pendingBatch.getRowCount()) {
            this.pendingPosition = 0;
            return true;
        }
        this.pendingPosition = newPosition;
        return false;
    }

    public Outbox getOutbox() {
        return this.outbox;
    }

    private AlwaysTrueOutboxSendQualifier getOutboxQualifier() {
        return AlwaysTrueOutboxSendQualifier.INSTANCE;
    }
}

