/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorTable;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import com.hazelcast.org.apache.calcite.sql.validate.SelectScope;
import com.hazelcast.org.apache.calcite.sql.validate.SqlConformance;
import com.hazelcast.org.apache.calcite.sql.validate.SqlQualified;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorImpl;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorTable;
import com.hazelcast.org.apache.calcite.util.Static;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.calcite.validate.HazelcastOperatorTableVisitor;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlOperatorTable;
import com.hazelcast.sql.impl.calcite.validate.SqlNodeUtil;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeCoercion;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeSystem;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HazelcastSqlValidator
extends SqlValidatorImpl {
    private static final SqlValidator.Config CONFIG = SqlValidator.Config.DEFAULT.withIdentifierExpansion(true);
    private final Map<SqlNode, RelDataType> knownNodeTypes = new IdentityHashMap<SqlNode, RelDataType>();

    public HazelcastSqlValidator(SqlValidatorCatalogReader catalogReader, HazelcastTypeFactory typeFactory, SqlConformance conformance) {
        this(null, catalogReader, typeFactory, conformance);
    }

    public HazelcastSqlValidator(SqlOperatorTable extensionOperatorTable, SqlValidatorCatalogReader catalogReader, HazelcastTypeFactory typeFactory, SqlConformance conformance) {
        super(HazelcastSqlValidator.operatorTable(extensionOperatorTable), catalogReader, (RelDataTypeFactory)typeFactory, CONFIG.withSqlConformance(conformance));
        this.setTypeCoercion(new HazelcastTypeCoercion(this));
    }

    private static SqlOperatorTable operatorTable(SqlOperatorTable extensionOperatorTable) {
        ArrayList<SqlOperatorTable> operatorTables = new ArrayList<SqlOperatorTable>();
        if (extensionOperatorTable != null) {
            operatorTables.add(extensionOperatorTable);
        }
        operatorTables.add(HazelcastSqlOperatorTable.instance());
        operatorTables.add(SqlStdOperatorTable.instance());
        return new ChainedSqlOperatorTable(operatorTables);
    }

    public void setKnownNodeType(SqlNode node, RelDataType type) {
        assert (!this.getUnknownType().equals(type));
        this.knownNodeTypes.put(node, type);
    }

    public RelDataType getKnownNodeType(SqlNode node) {
        return this.knownNodeTypes.get(node);
    }

    @Override
    protected void addToSelectList(List<SqlNode> list, Set<String> aliases, List<Map.Entry<String, RelDataType>> fieldList, SqlNode exp, SelectScope scope, boolean includeSystemVars) {
        if (this.isHiddenColumn(exp, scope)) {
            return;
        }
        super.addToSelectList(list, aliases, fieldList, exp, scope, includeSystemVars);
    }

    @Override
    public RelDataType deriveType(SqlValidatorScope scope, SqlNode expression) {
        RelDataType derived = super.deriveType(scope, expression);
        assert (derived != null);
        if (derived.getSqlTypeName() == SqlTypeName.CHAR) {
            derived = HazelcastTypeFactory.INSTANCE.createSqlType(SqlTypeName.VARCHAR, derived.isNullable());
            this.setValidatedNodeType(expression, derived);
        }
        switch (expression.getKind()) {
            case LITERAL: {
                return this.deriveLiteralType(derived, expression);
            }
            case CAST: {
                return this.deriveCastType(derived, scope, expression);
            }
        }
        return derived;
    }

    @Override
    public void validateLiteral(SqlLiteral literal) {
        this.validateLiteral(literal, this.getValidatedNodeType(literal));
    }

    @Override
    public void validateCall(SqlCall call, SqlValidatorScope scope) {
        this.deriveType(scope, call);
        super.validateCall(call, scope);
    }

    @Override
    protected SqlNode performUnconditionalRewrites(SqlNode node, boolean underFrom) {
        SqlNode rewritten = super.performUnconditionalRewrites(node, underFrom);
        if (rewritten != null && rewritten.isA(SqlKind.TOP_LEVEL)) {
            rewritten.accept(HazelcastOperatorTableVisitor.INSTANCE);
        }
        return rewritten;
    }

    private RelDataType deriveLiteralType(RelDataType derived, SqlNode expression) {
        RelDataType known = this.knownNodeTypes.get(expression);
        if (derived == known) {
            return derived;
        }
        SqlLiteral literal = (SqlLiteral)expression;
        if (HazelcastIntegerType.supports(HazelcastTypeSystem.typeName(derived)) && literal.getValue() != null) {
            derived = HazelcastIntegerType.deriveLiteralType(literal);
            this.setKnownAndValidatedNodeType(expression, derived);
        }
        return derived;
    }

    private RelDataType deriveCastType(RelDataType derived, SqlValidatorScope scope, SqlNode expression) {
        Number numeric;
        RelDataType known = this.knownNodeTypes.get(expression);
        if (derived == known) {
            return derived;
        }
        SqlCall call = (SqlCall)expression;
        Object operand = call.operand(0);
        RelDataType from = this.deriveType(scope, (SqlNode)operand);
        RelDataType to = this.deriveType(scope, (SqlNode)call.operand(1));
        assert (!to.isNullable());
        if (SqlUtil.isNullLiteral(operand, false)) {
            this.setKnownAndValidatedNodeType((SqlNode)operand, HazelcastTypeFactory.INSTANCE.createSqlType(SqlTypeName.NULL));
            derived = HazelcastTypeFactory.INSTANCE.createTypeWithNullability(to, true);
            this.setKnownAndValidatedNodeType(expression, derived);
            return derived;
        }
        derived = to;
        if (SqlNodeUtil.isParameter(operand)) {
            from = HazelcastTypeFactory.INSTANCE.createTypeWithNullability(to, true);
        }
        Number number = numeric = HazelcastTypeSystem.isNumeric(from) || HazelcastTypeSystem.isNumeric(to) ? SqlNodeUtil.numericValue(operand) : null;
        if (numeric != null) {
            from = HazelcastTypeSystem.narrowestTypeFor(numeric, HazelcastTypeSystem.typeName(to));
        }
        if (SqlNodeUtil.isLiteral(operand)) {
            this.validateLiteral((SqlLiteral)operand, to);
        }
        if (HazelcastTypeSystem.isInteger(to) && HazelcastTypeSystem.isInteger(from)) {
            derived = HazelcastIntegerType.deriveCastType(from, to);
        } else if (HazelcastTypeSystem.isInteger(to) && numeric != null) {
            long longValue = numeric.longValue();
            derived = HazelcastIntegerType.deriveCastType(longValue, to);
        }
        derived = HazelcastTypeFactory.INSTANCE.createTypeWithNullability(derived, from.isNullable());
        this.setKnownAndValidatedNodeType((SqlNode)operand, from);
        this.setKnownAndValidatedNodeType(expression, derived);
        return derived;
    }

    private void validateLiteral(SqlLiteral literal, RelDataType type) {
        SqlTypeName literalTypeName = literal.getTypeName();
        if (!HazelcastTypeSystem.canRepresent(literal, type)) {
            if (SqlTypeName.NUMERIC_TYPES.contains((Object)literalTypeName) && HazelcastTypeSystem.isNumeric(type)) {
                throw this.newValidationError(literal, Static.RESOURCE.numberLiteralOutOfRange(literal.toString()));
            }
            throw SqlUtil.newContextException(literal.getParserPosition(), Static.RESOURCE.invalidLiteral(literal.toString(), type.toString()));
        }
        if (literalTypeName != SqlTypeName.DECIMAL) {
            super.validateLiteral(literal);
        }
    }

    private void setKnownAndValidatedNodeType(SqlNode node, RelDataType type) {
        this.setKnownNodeType(node, type);
        this.setValidatedNodeType(node, type);
    }

    private boolean isHiddenColumn(SqlNode node, SelectScope scope) {
        if (!(node instanceof SqlIdentifier)) {
            return false;
        }
        SqlIdentifier identifier = (SqlIdentifier)node;
        String fieldName = this.extractFieldName(identifier, scope);
        if (fieldName == null) {
            return false;
        }
        SqlValidatorTable table = scope.fullyQualify((SqlIdentifier)identifier).namespace.getTable();
        if (table == null) {
            return false;
        }
        HazelcastTable unwrappedTable = table.unwrap(HazelcastTable.class);
        if (unwrappedTable == null) {
            return false;
        }
        return unwrappedTable.isHidden(fieldName);
    }

    private String extractFieldName(SqlIdentifier identifier, SelectScope scope) {
        SqlCall call = this.makeNullaryCall(identifier);
        if (call != null) {
            return null;
        }
        SqlQualified qualified = scope.fullyQualify(identifier);
        ImmutableList<String> names = qualified.identifier.names;
        if (names.size() < 2) {
            return null;
        }
        return Util.last(names);
    }
}

