/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.physical;

import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.sql.impl.calcite.opt.HazelcastConventions;
import com.hazelcast.sql.impl.calcite.opt.OptUtils;
import com.hazelcast.sql.impl.calcite.opt.logical.FilterLogicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.FilterPhysicalRel;
import java.util.Collection;

public final class FilterPhysicalRule
extends RelOptRule {
    public static final RelOptRule INSTANCE = new FilterPhysicalRule();

    private FilterPhysicalRule() {
        super(OptUtils.parentChild(FilterLogicalRel.class, RelNode.class, HazelcastConventions.LOGICAL), FilterPhysicalRule.class.getSimpleName());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FilterLogicalRel filter = (FilterLogicalRel)call.rel(0);
        RelNode input = filter.getInput();
        RelNode convertedInput = OptUtils.toPhysicalInput(input);
        Collection<RelNode> transformedInputs = this.getInputTransforms(convertedInput);
        for (RelNode transformedInput : transformedInputs) {
            FilterPhysicalRel newFilter = new FilterPhysicalRel(filter.getCluster(), transformedInput.getTraitSet(), transformedInput, filter.getCondition());
            call.transformTo(newFilter);
        }
    }

    private Collection<RelNode> getInputTransforms(RelNode convertedInput) {
        return OptUtils.getPhysicalRelsFromSubset(convertedInput);
    }
}

