/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt;

import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.sql.impl.calcite.opt.AbstractScanRel;
import com.hazelcast.sql.impl.calcite.opt.cost.CostUtils;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.schema.map.AbstractMapTable;

public abstract class AbstractMapScanRel
extends AbstractScanRel {
    public AbstractMapScanRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table) {
        super(cluster, traitSet, table);
    }

    public AbstractMapTable getMap() {
        return (AbstractMapTable)this.getTableUnwrapped().getTarget();
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        HazelcastTable table0 = this.getTableUnwrapped();
        return this.computeSelfCost(planner, table0.getTotalRowCount(), 1.0, table0.getFilter() != null, this.table.getRowCount(), table0.getProjects().size());
    }

    protected RelOptCost computeSelfCost(RelOptPlanner planner, double scanRowCount, double scanCostMultiplier, boolean hasFilter, double filterRowCount, int projectCount) {
        double scanCpu = scanRowCount * scanCostMultiplier;
        double filterCpu = hasFilter ? CostUtils.adjustCpuForConstrainedScan(scanCpu) : 0.0;
        double projectCpu = CostUtils.adjustCpuForConstrainedScan(CostUtils.getProjectCpu(filterRowCount, projectCount));
        return planner.getCostFactory().makeCost(filterRowCount, scanCpu + filterCpu + projectCpu, 0.0);
    }
}

