/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.internal.eviction.ClearExpiredRecordsTask;
import com.hazelcast.internal.eviction.ExpiredKey;
import com.hazelcast.internal.nearcache.impl.invalidation.InvalidationQueue;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.ToHeapDataConverter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.ExpirationTimeSetter;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.AbstractRecordStore;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.eventservice.EventService;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class AbstractEvictableRecordStore
extends AbstractRecordStore {
    private static final long DEFAULT_EXPIRED_KEY_SCAN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final String PROP_EXPIRED_KEY_SCAN_TIMEOUT_NANOS = "hazelcast.internal.map.expired.key.scan.timeout.nanos";
    private static final HazelcastProperty EXPIRED_KEY_SCAN_TIMEOUT_NANOS = new HazelcastProperty("hazelcast.internal.map.expired.key.scan.timeout.nanos", DEFAULT_EXPIRED_KEY_SCAN_TIMEOUT_NANOS, TimeUnit.NANOSECONDS);
    private static final int ONE_HUNDRED_PERCENT = 100;
    private static final int MAX_SAMPLE_AT_A_TIME = 16;
    private static final int MIN_TOTAL_NUMBER_OF_KEYS_TO_SCAN = 100;
    private static final ThreadLocal<List> SAMPLING_LIST = ThreadLocal.withInitial(() -> new ArrayList(32));
    protected final long expiredKeyScanTimeoutNanos;
    protected final long expiryDelayMillis;
    protected final Address thisAddress;
    protected final EventService eventService;
    protected final MapEventPublisher mapEventPublisher;
    protected final ClearExpiredRecordsTask clearExpiredRecordsTask;
    protected final InvalidationQueue<ExpiredKey> expiredKeys = new InvalidationQueue();
    protected final ILogger logger;
    protected Iterator<Map.Entry<Data, Record>> expirationIterator;
    protected volatile boolean hasEntryWithCustomExpiration;

    protected AbstractEvictableRecordStore(MapContainer mapContainer, int partitionId) {
        super(mapContainer, partitionId);
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        HazelcastProperties hazelcastProperties = nodeEngine.getProperties();
        this.expiryDelayMillis = hazelcastProperties.getMillis(ClusterProperty.MAP_EXPIRY_DELAY_SECONDS);
        this.eventService = nodeEngine.getEventService();
        this.mapEventPublisher = this.mapServiceContext.getMapEventPublisher();
        this.thisAddress = nodeEngine.getThisAddress();
        this.clearExpiredRecordsTask = this.mapServiceContext.getExpirationManager().getTask();
        this.expiredKeyScanTimeoutNanos = nodeEngine.getProperties().getNanos(EXPIRED_KEY_SCAN_TIMEOUT_NANOS);
        this.logger = nodeEngine.getLogger(this.getClass());
    }

    private boolean isRecordStoreExpirable() {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        return this.hasEntryWithCustomExpiration || mapConfig.getMaxIdleSeconds() > 0 || mapConfig.getTimeToLiveSeconds() > 0;
    }

    @Override
    public boolean isExpirable() {
        return this.isRecordStoreExpirable();
    }

    @Override
    public void evictExpiredEntries(int percentage, boolean backup) {
        long now = AbstractEvictableRecordStore.getNow();
        int maxScannableCount = this.getMaxSampleCount(this.size(), percentage);
        int scannedCount = 0;
        int expiredCount = 0;
        long scanLoopStartNanos = System.nanoTime();
        try {
            do {
                expiredCount += this.evictExpiredSamples(now, backup);
            } while ((scannedCount += this.sampleForExpiry()) < maxScannableCount && this.getOrInitExpirationIterator().hasNext() && System.nanoTime() - scanLoopStartNanos < this.expiredKeyScanTimeoutNanos);
        }
        catch (Exception e) {
            SAMPLING_LIST.get().clear();
            throw ExceptionUtil.rethrow(e);
        }
        if (this.logger.isFinestEnabled()) {
            this.logProgress(maxScannableCount, scannedCount, expiredCount, scanLoopStartNanos);
        }
        this.accumulateOrSendExpiredKey(null, null);
    }

    private void logProgress(int maxScannableCount, int scannedCount, int expiredCount, long scanLoopStartNanos) {
        this.logger.finest(String.format("mapName: %s, partitionId: %d, partitionSize: %d, maxScannableCount: %d, scannedCount: %d, expiredCount: %d, scanTookNanos: %d", this.getName(), this.getPartitionId(), this.size(), maxScannableCount, scannedCount, expiredCount, System.nanoTime() - scanLoopStartNanos));
    }

    private int getMaxSampleCount(int size, int percentage) {
        if (size <= 100) {
            return size;
        }
        int numberOfKeysInPercentage = (int)(1.0 * (double)size * (double)percentage / 100.0);
        return Math.max(100, numberOfKeysInPercentage);
    }

    private int sampleForExpiry() {
        List sampledPairs = SAMPLING_LIST.get();
        int sampledCount = 0;
        Iterator<Map.Entry<Data, Record>> iterator = this.getOrInitExpirationIterator();
        while (iterator.hasNext() && sampledCount++ < 16) {
            Map.Entry<Data, Record> entry = iterator.next();
            sampledPairs.add(entry.getKey());
            sampledPairs.add(entry.getValue());
        }
        return sampledCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int evictExpiredSamples(long now, boolean backup) {
        int evictedCount = 0;
        List sampledPairs = SAMPLING_LIST.get();
        try {
            for (int i = 0; i < sampledPairs.size(); i += 2) {
                Record record;
                Data key = (Data)sampledPairs.get(i);
                if (this.getOrNullIfExpired(key, record = (Record)sampledPairs.get(i + 1), now, backup) != null) continue;
                ++evictedCount;
            }
        }
        finally {
            sampledPairs.clear();
        }
        return evictedCount;
    }

    private Iterator<Map.Entry<Data, Record>> getOrInitExpirationIterator() {
        if (this.expirationIterator == null || !this.expirationIterator.hasNext()) {
            this.expirationIterator = this.storage.mutationTolerantIterator();
        }
        return this.expirationIterator;
    }

    @Override
    public void evictEntries(Data excludedKey) {
        if (this.shouldEvict()) {
            this.mapContainer.getEvictor().evict(this, excludedKey);
        }
    }

    @Override
    public void sampleAndForceRemoveEntries(int entryCountToRemove) {
        Data dataKey;
        LinkedList<Data> keysToRemove = new LinkedList<Data>();
        Iterable<EntryView> sample = this.storage.getRandomSamples(entryCountToRemove);
        for (EntryView entryView : sample) {
            Data dataKey2 = this.storage.extractDataKeyFromLazy(entryView);
            keysToRemove.add(dataKey2);
        }
        while ((dataKey = (Data)keysToRemove.poll()) != null) {
            this.evict(dataKey, true);
        }
    }

    @Override
    public boolean shouldEvict() {
        Evictor evictor = this.mapContainer.getEvictor();
        return evictor != Evictor.NULL_EVICTOR && evictor.checkEvictable(this);
    }

    protected void markRecordStoreExpirable(long ttl, long maxIdle) {
        if (this.isTtlDefined(ttl) || this.isMaxIdleDefined(maxIdle)) {
            this.hasEntryWithCustomExpiration = true;
        }
        if (this.isRecordStoreExpirable()) {
            this.mapServiceContext.getExpirationManager().scheduleExpirationTask();
        }
    }

    protected boolean isTtlDefined(long ttl) {
        return ttl > 0L && ttl < Long.MAX_VALUE;
    }

    protected boolean isMaxIdleDefined(long maxIdle) {
        return maxIdle > 0L && maxIdle < Long.MAX_VALUE;
    }

    @Override
    public boolean isTtlOrMaxIdleDefined(Record record) {
        long ttl = record.getTtl();
        long maxIdle = record.getMaxIdle();
        return this.isTtlDefined(ttl) || this.isMaxIdleDefined(maxIdle);
    }

    @Override
    public Record getOrNullIfExpired(Data key, Record record, long now, boolean backup) {
        if (!this.isRecordStoreExpirable()) {
            return record;
        }
        if (record == null) {
            return null;
        }
        if (this.isLocked(key)) {
            return record;
        }
        if (!this.isExpired(record, now, backup)) {
            return record;
        }
        this.evict(key, backup);
        if (!backup) {
            this.doPostEvictionOperations(key, record);
        }
        return null;
    }

    @Override
    public boolean isExpired(Record record, long now, boolean backup) {
        return record == null || this.isIdleExpired(record, now, backup) || this.isTTLExpired(record, now, backup);
    }

    private boolean isIdleExpired(Record record, long now, boolean backup) {
        long idleMillis;
        if (backup && this.mapServiceContext.getClearExpiredRecordsTask().canPrimaryDriveExpiration()) {
            return false;
        }
        long maxIdleMillis = this.getRecordMaxIdleOrConfig(record);
        if (maxIdleMillis < 1L || maxIdleMillis == Long.MAX_VALUE) {
            return false;
        }
        long idlenessStartTime = ExpirationTimeSetter.getIdlenessStartTime(record);
        long elapsedMillis = now - idlenessStartTime;
        return elapsedMillis >= (idleMillis = ExpirationTimeSetter.calculateExpirationWithDelay(maxIdleMillis, this.expiryDelayMillis, backup));
    }

    private boolean isTTLExpired(Record record, long now, boolean backup) {
        long ttlMillis;
        if (record == null) {
            return false;
        }
        long ttl = this.getRecordTTLOrConfig(record);
        if (ttl < 1L || ttl == Long.MAX_VALUE) {
            return false;
        }
        long ttlStartTime = ExpirationTimeSetter.getLifeStartTime(record);
        long elapsedMillis = now - ttlStartTime;
        return elapsedMillis >= (ttlMillis = ExpirationTimeSetter.calculateExpirationWithDelay(ttl, this.expiryDelayMillis, backup));
    }

    private long getRecordMaxIdleOrConfig(Record record) {
        if (record.getMaxIdle() != -1L) {
            return record.getMaxIdle();
        }
        return TimeUnit.SECONDS.toMillis(this.mapContainer.getMapConfig().getMaxIdleSeconds());
    }

    private long getRecordTTLOrConfig(Record record) {
        if (record.getTtl() != -1L) {
            return record.getTtl();
        }
        return TimeUnit.SECONDS.toMillis(this.mapContainer.getMapConfig().getTimeToLiveSeconds());
    }

    @Override
    public void doPostEvictionOperations(Data dataKey, Record record) {
        boolean expired;
        Object value = record.getValue();
        long now = AbstractEvictableRecordStore.getNow();
        boolean idleExpired = this.isIdleExpired(record, now, false);
        boolean ttlExpired = this.isTTLExpired(record, now, false);
        boolean bl = expired = idleExpired || ttlExpired;
        if (this.eventService.hasEventRegistration("hz:impl:mapService", this.name)) {
            this.mapEventPublisher.publishEvent(this.thisAddress, this.name, expired ? EntryEventType.EXPIRED : EntryEventType.EVICTED, dataKey, value, null);
        }
        if (!ttlExpired && idleExpired) {
            this.accumulateOrSendExpiredKey(dataKey, record);
        }
    }

    @Override
    public InvalidationQueue<ExpiredKey> getExpiredKeysQueue() {
        return this.expiredKeys;
    }

    private void accumulateOrSendExpiredKey(Data dataKey, Record record) {
        if (this.mapContainer.getTotalBackupCount() == 0) {
            return;
        }
        if (record != null) {
            this.expiredKeys.offer(new ExpiredKey(ToHeapDataConverter.toHeapData(dataKey), record.getCreationTime()));
        }
        this.clearExpiredRecordsTask.tryToSendBackupExpiryOp(this, true);
    }

    @Override
    public void accessRecord(Record record, long now) {
        record.onAccess(now);
        this.updateStatsOnGet(now);
        ExpirationTimeSetter.setExpirationTime(record);
    }

    protected void mergeRecordExpiration(Record record, SplitBrainMergeTypes.MapMergeTypes mergingEntry) {
        this.mergeRecordExpiration(record, mergingEntry.getTtl(), mergingEntry.getMaxIdle(), mergingEntry.getCreationTime(), mergingEntry.getLastAccessTime(), mergingEntry.getLastUpdateTime());
    }

    private void mergeRecordExpiration(Record record, long ttlMillis, Long maxIdleMillis, long creationTime, long lastAccessTime, long lastUpdateTime) {
        record.setTtl(ttlMillis);
        if (maxIdleMillis != null) {
            record.setMaxIdle(maxIdleMillis);
        }
        record.setCreationTime(creationTime);
        record.setLastAccessTime(lastAccessTime);
        record.setLastUpdateTime(lastUpdateTime);
        ExpirationTimeSetter.setExpirationTime(record);
        this.markRecordStoreExpirable(record.getTtl(), record.getMaxIdle());
    }
}

