/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.event.impl;

import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.event.CPMembershipEvent;
import com.hazelcast.cp.event.impl.CpEventDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class CPMembershipEventImpl
implements CPMembershipEvent,
IdentifiedDataSerializable {
    private CPMembershipEvent.EventType type;
    private CPMember member;

    public CPMembershipEventImpl() {
    }

    public CPMembershipEventImpl(CPMember member, CPMembershipEvent.EventType type) {
        this.type = type;
        this.member = member;
    }

    public CPMembershipEventImpl(CPMember member, byte eventType) {
        this.type = CPMembershipEventImpl.toEventType(eventType);
        this.member = member;
    }

    @Override
    public CPMember getMember() {
        return this.member;
    }

    @Override
    public CPMembershipEvent.EventType getType() {
        return this.type;
    }

    @Override
    public int getFactoryId() {
        return CpEventDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.member);
        out.writeUTF(this.type.name());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.member = (CPMember)in.readObject();
        this.type = CPMembershipEvent.EventType.valueOf(in.readUTF());
    }

    public String toString() {
        return "CPMembershipEvent{type=" + (Object)((Object)this.type) + ", member=" + this.member + '}';
    }

    private static CPMembershipEvent.EventType toEventType(byte eventType) {
        switch (eventType) {
            case 1: {
                return CPMembershipEvent.EventType.ADDED;
            }
            case 2: {
                return CPMembershipEvent.EventType.REMOVED;
            }
        }
        throw new IllegalArgumentException("Unknown event type: " + eventType);
    }
}

