/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.AuthenticationStatus;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractMessageTask;
import com.hazelcast.client.impl.protocol.task.BlockingMessageTask;
import com.hazelcast.client.impl.protocol.task.UrgentMessageTask;
import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.PasswordCredentials;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.security.UsernamePasswordCredentials;
import java.security.Permission;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public abstract class AuthenticationBaseMessageTask<P>
extends AbstractMessageTask<P>
implements BlockingMessageTask,
UrgentMessageTask {
    protected transient UUID clientUuid;
    protected transient String clusterName;
    protected transient String clientName;
    protected transient Set<String> labels;
    protected transient Credentials credentials;
    transient byte clientSerializationVersion;
    transient String clientVersion;

    AuthenticationBaseMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    public int getPartitionId() {
        return -1;
    }

    @Override
    protected boolean requiresAuthentication() {
        return false;
    }

    @Override
    protected boolean acceptOnIncompleteStart() {
        return true;
    }

    @Override
    protected boolean validateNodeStartBeforeDecode() {
        return false;
    }

    @Override
    public void processMessage() {
        switch (this.authenticate()) {
            case SERIALIZATION_VERSION_MISMATCH: {
                this.sendClientMessage(this.prepareSerializationVersionMismatchClientMessage());
                break;
            }
            case NOT_ALLOWED_IN_CLUSTER: {
                this.sendClientMessage(this.prepareNotAllowedInCluster());
                break;
            }
            case CREDENTIALS_FAILED: {
                this.sendClientMessage(this.prepareUnauthenticatedClientMessage());
                break;
            }
            case AUTHENTICATED: {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Processing authentication with clientUuid " + this.clientUuid);
                }
                this.sendClientMessage(this.prepareAuthenticatedClientMessage());
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled authentication result");
            }
        }
    }

    private AuthenticationStatus authenticate() {
        if (this.endpoint.isAuthenticated()) {
            return AuthenticationStatus.AUTHENTICATED;
        }
        if (this.clientSerializationVersion != this.serializationService.getVersion()) {
            return AuthenticationStatus.SERIALIZATION_VERSION_MISMATCH;
        }
        if (this.credentials == null) {
            this.logger.severe("Could not retrieve Credentials object!");
            return AuthenticationStatus.CREDENTIALS_FAILED;
        }
        if (this.clientEngine.getSecurityContext() != null) {
            return this.authenticate(this.clientEngine.getSecurityContext());
        }
        if (this.credentials instanceof UsernamePasswordCredentials) {
            return this.verifyEmptyCredentialsAndClusterName((PasswordCredentials)this.credentials);
        }
        this.logger.severe("Hazelcast security is disabled.\nNull username and password values are expected.\nOnly the cluster name is verified in this case!\nCurrent credentials type is: " + this.credentials.getClass().getName());
        return AuthenticationStatus.CREDENTIALS_FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationStatus authenticate(SecurityContext securityContext) {
        ServerConnection connection = this.endpoint.getConnection();
        Boolean passed = Boolean.FALSE;
        try {
            LoginContext lc = securityContext.createClientLoginContext(this.clusterName, this.credentials, connection);
            lc.login();
            this.endpoint.setLoginContext(lc);
            passed = Boolean.TRUE;
            AuthenticationStatus authenticationStatus = AuthenticationStatus.AUTHENTICATED;
            return authenticationStatus;
        }
        catch (LoginException e) {
            this.logger.warning(e);
            AuthenticationStatus authenticationStatus = AuthenticationStatus.CREDENTIALS_FAILED;
            return authenticationStatus;
        }
        finally {
            this.nodeEngine.getNode().getNodeExtension().getAuditlogService().eventBuilder("HZ-0501").message("Client connection authentication.").addParameter("connection", connection).addParameter("credentials", this.credentials).addParameter("passed", passed).log();
        }
    }

    private AuthenticationStatus verifyEmptyCredentialsAndClusterName(PasswordCredentials passwordCredentials) {
        if (passwordCredentials.getName() != null || passwordCredentials.getPassword() != null) {
            this.logger.warning("Received auth from " + this.connection + " with clientUuid " + this.clientUuid + ",  authentication rejected because security is disabled on the member, and client sends not-null username or password.");
            return AuthenticationStatus.CREDENTIALS_FAILED;
        }
        String nodeClusterName = this.nodeEngine.getConfig().getClusterName();
        boolean clusternameMatch = nodeClusterName.equals(this.clusterName);
        return clusternameMatch ? AuthenticationStatus.AUTHENTICATED : AuthenticationStatus.CREDENTIALS_FAILED;
    }

    private ClientMessage prepareUnauthenticatedClientMessage() {
        boolean clientFailoverSupported = this.nodeEngine.getNode().getNodeExtension().isClientFailoverSupported();
        ServerConnection connection = this.endpoint.getConnection();
        this.logger.warning("Received auth from " + connection + " with clientUuid " + this.clientUuid + ", authentication failed");
        byte status = AuthenticationStatus.CREDENTIALS_FAILED.getId();
        return this.encodeAuth(status, null, null, this.serializationService.getVersion(), this.clientEngine.getPartitionService().getPartitionCount(), this.clientEngine.getClusterService().getClusterId(), clientFailoverSupported);
    }

    private ClientMessage prepareNotAllowedInCluster() {
        boolean clientFailoverSupported = this.nodeEngine.getNode().getNodeExtension().isClientFailoverSupported();
        byte status = AuthenticationStatus.NOT_ALLOWED_IN_CLUSTER.getId();
        return this.encodeAuth(status, null, null, this.serializationService.getVersion(), this.clientEngine.getPartitionService().getPartitionCount(), this.clientEngine.getClusterService().getClusterId(), clientFailoverSupported);
    }

    private ClientMessage prepareSerializationVersionMismatchClientMessage() {
        boolean clientFailoverSupported = this.nodeEngine.getNode().getNodeExtension().isClientFailoverSupported();
        return this.encodeAuth(AuthenticationStatus.SERIALIZATION_VERSION_MISMATCH.getId(), null, null, this.serializationService.getVersion(), this.clientEngine.getPartitionService().getPartitionCount(), this.clientEngine.getClusterService().getClusterId(), clientFailoverSupported);
    }

    private ClientMessage prepareAuthenticatedClientMessage() {
        ServerConnection connection = this.endpoint.getConnection();
        this.endpoint.authenticated(this.clientUuid, this.credentials, this.clientVersion, this.clientMessage.getCorrelationId(), this.clientName, this.labels);
        this.setConnectionType();
        this.validateNodeStart();
        UUID clusterId = this.clientEngine.getClusterService().getClusterId();
        if (clusterId == null) {
            throw new HazelcastInstanceNotActiveException("Hazelcast instance is not ready yet!");
        }
        if (!this.clientEngine.bind(this.endpoint)) {
            return this.prepareNotAllowedInCluster();
        }
        this.logger.info("Received auth from " + connection + ", successfully authenticated, clientUuid: " + this.clientUuid + ", client version: " + this.clientVersion);
        Address thisAddress = this.clientEngine.getThisAddress();
        UUID uuid = this.clientEngine.getClusterService().getLocalMember().getUuid();
        byte status = AuthenticationStatus.AUTHENTICATED.getId();
        boolean clientFailoverSupported = this.nodeEngine.getNode().getNodeExtension().isClientFailoverSupported();
        return this.encodeAuth(status, thisAddress, uuid, this.serializationService.getVersion(), this.clientEngine.getPartitionService().getPartitionCount(), clusterId, clientFailoverSupported);
    }

    private void setConnectionType() {
        this.connection.setConnectionType(this.getClientType());
    }

    protected abstract ClientMessage encodeAuth(byte var1, Address var2, UUID var3, byte var4, int var5, UUID var6, boolean var7);

    protected abstract String getClientType();

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

