/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.CacheStatistics;
import com.hazelcast.cache.EventJournalCacheEvent;
import com.hazelcast.cache.impl.CacheEntryProcessorResult;
import com.hazelcast.cache.impl.CacheEventListenerAdaptor;
import com.hazelcast.cache.impl.CachePartitionIterator;
import com.hazelcast.cache.impl.CachePartitionsIterator;
import com.hazelcast.cache.impl.CacheProxySupport;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.CacheStatisticsImpl;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.event.CachePartitionLostEventFilter;
import com.hazelcast.cache.impl.event.CachePartitionLostListener;
import com.hazelcast.cache.impl.event.InternalCachePartitionLostListenerAdapter;
import com.hazelcast.cache.impl.journal.CacheEventJournalReadOperation;
import com.hazelcast.cache.impl.journal.CacheEventJournalSubscribeOperation;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.internal.config.CacheConfigReadOnly;
import com.hazelcast.internal.journal.EventJournalInitialSubscriberState;
import com.hazelcast.internal.journal.EventJournalReader;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.ringbuffer.ReadResultSet;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.eventservice.EventRegistration;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;

public class CacheProxy<K, V>
extends CacheProxySupport<K, V>
implements EventJournalReader<EventJournalCacheEvent<K, V>> {
    private static final CacheStatistics EMPTY_CACHE_STATS = new CacheStatisticsImpl(Clock.currentTimeMillis());

    CacheProxy(CacheConfig<K, V> cacheConfig, NodeEngine nodeEngine, ICacheService cacheService) {
        super(cacheConfig, nodeEngine, cacheService);
    }

    public V get(K key) {
        return this.get(key, null);
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        return this.getAll(keys, null);
    }

    public boolean containsKey(K key) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        Object dataKey = this.serializationService.toData(key);
        Operation operation = this.operationProvider.createContainsKeyOperation((Data)dataKey);
        OperationService operationService = this.getNodeEngine().getOperationService();
        int partitionId = this.getPartitionId((Data)dataKey);
        InvocationFuture future = operationService.invokeOnPartition(this.getServiceName(), operation, partitionId);
        return (Boolean)future.joinInternal();
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        for (K key : keys) {
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key);
        }
        Set<Data> keysData = SetUtil.createHashSet(keys.size());
        for (K key : keys) {
            CacheProxyUtil.validateNotNull(key);
            keysData.add((Data)this.serializationService.toData(key));
        }
        this.createAndSubmitLoadAllTask(keysData, replaceExistingValues, completionListener);
    }

    public void put(K key, V value) {
        this.put(key, value, null);
    }

    public V getAndPut(K key, V value) {
        return this.getAndPut(key, value, null);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAll(map, null);
    }

    public boolean putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, null);
    }

    public boolean remove(K key) {
        try {
            InvocationFuture future = this.removeAsyncInternal(key, null, false, false, true);
            return (Boolean)((CompletableFuture)future).get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    public boolean remove(K key, V oldValue) {
        try {
            InvocationFuture future = this.removeAsyncInternal(key, oldValue, true, false, true);
            return (Boolean)((CompletableFuture)future).get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    public V getAndRemove(K key) {
        try {
            InvocationFuture future = this.removeAsyncInternal(key, null, false, true, true);
            return (V)((CompletableFuture)future).get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.replace(key, oldValue, newValue, null);
    }

    public boolean replace(K key, V value) {
        return this.replace(key, value, (ExpiryPolicy)null);
    }

    public V getAndReplace(K key, V value) {
        return this.getAndReplace(key, value, null);
    }

    public void removeAll(Set<? extends K> keys) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        if (keys.isEmpty()) {
            return;
        }
        this.removeAllInternal(keys);
    }

    public void removeAll() {
        this.ensureOpen();
        this.removeAllInternal(null);
    }

    public void clear() {
        this.ensureOpen();
        this.clearInternal();
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        if (clazz.isInstance(this.cacheConfig)) {
            return (C)((Configuration)clazz.cast(new CacheConfigReadOnly(this.cacheConfig)));
        }
        throw new IllegalArgumentException("The configuration class " + clazz + " is not supported by this implementation");
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        Preconditions.checkNotNull(entryProcessor, "Entry Processor is null");
        Object keyData = this.serializationService.toData(key);
        return this.invokeInternal((Data)keyData, entryProcessor, arguments);
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        Preconditions.checkNotNull(entryProcessor, "Entry Processor is null");
        Map<K, CacheEntryProcessorResult<T>> allResult = MapUtil.createHashMap(keys.size());
        for (K key : keys) {
            CacheEntryProcessorResult<T> ceResult;
            CacheProxyUtil.validateNotNull(key);
            try {
                T result = this.invoke(key, entryProcessor, arguments);
                ceResult = result != null ? new CacheEntryProcessorResult<T>(result) : null;
            }
            catch (Exception e) {
                ceResult = new CacheEntryProcessorResult<T>(e);
            }
            if (ceResult == null) continue;
            allResult.put(key, ceResult);
        }
        return allResult;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new IllegalArgumentException("Unwrapping to " + clazz + " is not supported by this implementation");
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.registerCacheEntryListener(cacheEntryListenerConfiguration, true);
    }

    @Override
    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, boolean addToConfig) {
        this.ensureOpen();
        Preconditions.checkNotNull(cacheEntryListenerConfiguration, "CacheEntryListenerConfiguration can't be null");
        CacheEventListenerAdaptor<K, V> entryListener = new CacheEventListenerAdaptor<K, V>(this, cacheEntryListenerConfiguration, this.getNodeEngine().getSerializationService());
        UUID regId = ((ICacheService)this.getService()).registerListener(this.getDistributedObjectName(), entryListener, entryListener);
        if (regId != null) {
            if (addToConfig) {
                this.cacheConfig.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
            }
            this.addListenerLocally(regId, cacheEntryListenerConfiguration);
            if (addToConfig) {
                this.updateCacheListenerConfigOnOtherNodes(cacheEntryListenerConfiguration, true);
            }
        }
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        Preconditions.checkNotNull(cacheEntryListenerConfiguration, "CacheEntryListenerConfiguration can't be null");
        UUID regId = this.getListenerIdLocal(cacheEntryListenerConfiguration);
        if (regId != null && ((ICacheService)this.getService()).deregisterListener(this.getDistributedObjectName(), regId)) {
            this.removeListenerLocally(cacheEntryListenerConfiguration);
            this.cacheConfig.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
            this.updateCacheListenerConfigOnOtherNodes(cacheEntryListenerConfiguration, false);
        }
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.ensureOpen();
        return new CachePartitionsIterator(this, false);
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator(int fetchSize) {
        this.ensureOpen();
        return new CachePartitionsIterator(this, fetchSize, false);
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator(int fetchSize, int partitionId, boolean prefetchValues) {
        this.ensureOpen();
        return new CachePartitionIterator(this, fetchSize, partitionId, prefetchValues);
    }

    @Override
    public UUID addPartitionLostListener(CachePartitionLostListener listener) {
        Preconditions.checkNotNull(listener, "CachePartitionLostListener can't be null");
        CachePartitionLostEventFilter filter = new CachePartitionLostEventFilter();
        listener = (CachePartitionLostListener)this.injectDependencies(listener);
        InternalCachePartitionLostListenerAdapter listenerAdapter = new InternalCachePartitionLostListenerAdapter(listener);
        EventRegistration registration = ((ICacheService)this.getService()).getNodeEngine().getEventService().registerListener("hz:impl:cacheService", this.name, filter, listenerAdapter);
        return registration.getId();
    }

    @Override
    public boolean removePartitionLostListener(UUID id) {
        Preconditions.checkNotNull(id, "Listener ID should not be null!");
        return ((ICacheService)this.getService()).getNodeEngine().getEventService().deregisterListener("hz:impl:cacheService", this.name, id);
    }

    @Override
    public CompletionStage<EventJournalInitialSubscriberState> subscribeToEventJournal(int partitionId) {
        CacheEventJournalSubscribeOperation op = new CacheEventJournalSubscribeOperation(this.nameWithPrefix);
        op.setPartitionId(partitionId);
        return this.getNodeEngine().getOperationService().invokeOnPartition(op);
    }

    @Override
    public <T> CompletionStage<ReadResultSet<T>> readFromEventJournal(long startSequence, int minSize, int maxSize, int partitionId, Predicate<? super EventJournalCacheEvent<K, V>> predicate, Function<? super EventJournalCacheEvent<K, V>, ? extends T> projection) {
        if (maxSize < minSize) {
            throw new IllegalArgumentException("maxSize " + maxSize + " must be greater or equal to minSize " + minSize);
        }
        CacheEventJournalReadOperation op = new CacheEventJournalReadOperation(this.nameWithPrefix, startSequence, minSize, maxSize, predicate, projection);
        op.setPartitionId(partitionId);
        return this.getNodeEngine().getOperationService().invokeOnPartition(op);
    }

    @Override
    public CacheStatistics getLocalCacheStatistics() {
        if (!this.cacheConfig.isStatisticsEnabled()) {
            return EMPTY_CACHE_STATS;
        }
        return ((ICacheService)this.getService()).createCacheStatIfAbsent(this.cacheConfig.getNameWithPrefix());
    }

    @Override
    public InternalCompletableFuture<V> getAsync(K key) {
        return this.getAsync((Object)key, (ExpiryPolicy)null);
    }

    @Override
    public InternalCompletableFuture<V> getAsync(K key, ExpiryPolicy expiryPolicy) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        Object keyData = this.serializationService.toData(key);
        Operation op = this.operationProvider.createGetOperation((Data)keyData, expiryPolicy);
        return this.invoke(op, (Data)keyData, false);
    }

    public InternalCompletableFuture<Void> putAsync(K key, V value) {
        return this.putAsync((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public InternalCompletableFuture<Void> putAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.putAsyncInternal(key, value, expiryPolicy, false, false);
    }

    public InternalCompletableFuture<Boolean> putIfAbsentAsync(K key, V value) {
        return this.putIfAbsentAsyncInternal(key, value, null, false);
    }

    public InternalCompletableFuture<Boolean> putIfAbsentAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.putIfAbsentAsyncInternal(key, value, expiryPolicy, false);
    }

    @Override
    public InternalCompletableFuture<V> getAndPutAsync(K key, V value) {
        return this.getAndPutAsync((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    @Override
    public InternalCompletableFuture<V> getAndPutAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.putAsyncInternal(key, value, expiryPolicy, true, false);
    }

    public InternalCompletableFuture<Boolean> removeAsync(K key) {
        return this.removeAsyncInternal(key, null, false, false, false);
    }

    public InternalCompletableFuture<Boolean> removeAsync(K key, V oldValue) {
        return this.removeAsyncInternal(key, oldValue, true, false, false);
    }

    @Override
    public InternalCompletableFuture<V> getAndRemoveAsync(K key) {
        return this.removeAsyncInternal(key, null, false, true, false);
    }

    public InternalCompletableFuture<Boolean> replaceAsync(K key, V value) {
        return this.replaceAsyncInternal(key, null, value, null, false, false, false);
    }

    public InternalCompletableFuture<Boolean> replaceAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.replaceAsyncInternal(key, null, value, expiryPolicy, false, false, false);
    }

    public InternalCompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.replaceAsyncInternal(key, oldValue, newValue, null, true, false, false);
    }

    public InternalCompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy) {
        return this.replaceAsyncInternal(key, oldValue, newValue, expiryPolicy, true, false, false);
    }

    @Override
    public InternalCompletableFuture<V> getAndReplaceAsync(K key, V value) {
        return this.replaceAsyncInternal(key, null, value, null, false, true, false);
    }

    @Override
    public InternalCompletableFuture<V> getAndReplaceAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.replaceAsyncInternal(key, null, value, expiryPolicy, false, true, false);
    }

    @Override
    public V get(K key, ExpiryPolicy expiryPolicy) {
        try {
            CompletionStage future = this.getAsync((Object)key, expiryPolicy);
            return future.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys, ExpiryPolicy expiryPolicy) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        int keyCount = keys.size();
        Set<Data> ks = SetUtil.createHashSet(keyCount);
        for (K key : keys) {
            CacheProxyUtil.validateNotNull(key);
            Object dataKey = this.serializationService.toData(key);
            ks.add((Data)dataKey);
        }
        Map result = MapUtil.createHashMap(keyCount);
        PartitionIdSet partitions = this.getPartitionsForKeys(ks);
        try {
            OperationFactory factory = this.operationProvider.createGetAllOperationFactory(ks, expiryPolicy);
            OperationService operationService = this.getNodeEngine().getOperationService();
            Map responses = operationService.invokeOnPartitions(this.getServiceName(), factory, partitions);
            for (Object response : responses.values()) {
                MapEntries mapEntries = (MapEntries)this.serializationService.toObject(response);
                mapEntries.putAllToMap(this.serializationService, result);
            }
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
        return result;
    }

    @Override
    public void put(K key, V value, ExpiryPolicy expiryPolicy) {
        try {
            InvocationFuture future = this.putAsyncInternal(key, value, expiryPolicy, false, true);
            ((CompletableFuture)future).get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public V getAndPut(K key, V value, ExpiryPolicy expiryPolicy) {
        try {
            InvocationFuture future = this.putAsyncInternal(key, value, expiryPolicy, true, true);
            return (V)((CompletableFuture)future).get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, ExpiryPolicy expiryPolicy) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(map);
        try {
            int partitionCount = this.partitionService.getPartitionCount();
            List<Map.Entry<Data, Data>>[] entriesPerPartition = this.groupDataToPartitions(map, partitionCount);
            this.putToAllPartitionsAndWaitForCompletion(entriesPerPartition, expiryPolicy);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public boolean setExpiryPolicy(K key, ExpiryPolicy expiryPolicy) {
        try {
            this.ensureOpen();
            CacheProxyUtil.validateNotNull(key);
            CacheProxyUtil.validateNotNull(expiryPolicy);
            Object keyData = this.serializationService.toData(key);
            Object expiryPolicyData = this.serializationService.toData(expiryPolicy);
            List<Data> list = Collections.singletonList(keyData);
            Operation operation = this.operationProvider.createSetExpiryPolicyOperation(list, (Data)expiryPolicyData);
            InvocationFuture future = this.invoke(operation, (Data)keyData, true);
            return (Boolean)future.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public void setExpiryPolicy(Set<? extends K> keys, ExpiryPolicy expiryPolicy) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        CacheProxyUtil.validateNotNull(expiryPolicy);
        try {
            int partitionCount = this.partitionService.getPartitionCount();
            List<Data>[] keysPerPartition = this.groupDataToPartitions(keys, partitionCount);
            this.setTTLAllPartitionsAndWaitForCompletion(keysPerPartition, (Data)this.serializationService.toData(expiryPolicy));
        }
        catch (Exception e) {
            ExceptionUtil.rethrow(e);
        }
    }

    private List<Map.Entry<Data, Data>>[] groupDataToPartitions(Map<? extends K, ? extends V> map, int partitionCount) {
        List[] entriesPerPartition = new List[partitionCount];
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            CacheProxyUtil.validateNotNull(key, value);
            Object keyData = this.serializationService.toData(key);
            Object valueData = this.serializationService.toData(value);
            int partitionId = this.partitionService.getPartitionId((Data)keyData);
            ArrayList entries = entriesPerPartition[partitionId];
            if (entries == null) {
                entriesPerPartition[partitionId] = entries = new ArrayList();
            }
            entries.add(new AbstractMap.SimpleImmutableEntry(keyData, valueData));
        }
        return entriesPerPartition;
    }

    @Override
    public boolean putIfAbsent(K key, V value, ExpiryPolicy expiryPolicy) {
        try {
            InvocationFuture<Boolean> future = this.putIfAbsentAsyncInternal(key, value, expiryPolicy, true);
            return (Boolean)future.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy) {
        try {
            InvocationFuture future = this.replaceAsyncInternal(key, oldValue, newValue, expiryPolicy, true, false, true);
            return (Boolean)future.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public boolean replace(K key, V value, ExpiryPolicy expiryPolicy) {
        try {
            InvocationFuture future = this.replaceAsyncInternal(key, null, value, expiryPolicy, false, false, true);
            return (Boolean)future.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public V getAndReplace(K key, V value, ExpiryPolicy expiryPolicy) {
        try {
            InvocationFuture future = this.replaceAsyncInternal(key, null, value, expiryPolicy, false, true, true);
            return future.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public int size() {
        this.ensureOpen();
        try {
            OperationFactory operationFactory = this.operationProvider.createSizeOperationFactory();
            Map<Integer, Object> results = this.getNodeEngine().getOperationService().invokeOnAllPartitions(this.getServiceName(), operationFactory);
            long total = 0L;
            for (Object result : results.values()) {
                total += (long)((Integer)this.getNodeEngine().toObject(result)).intValue();
            }
            return MapUtil.toIntSize(total);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(t, CacheException.class);
        }
    }
}

