/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.math;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.UniExpression;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;

public class DoubleFunction
extends UniExpression<Double>
implements IdentifiedDataSerializable {
    public static final int COS = 0;
    public static final int SIN = 1;
    public static final int TAN = 2;
    public static final int COT = 3;
    public static final int ACOS = 4;
    public static final int ASIN = 5;
    public static final int ATAN = 6;
    public static final int EXP = 7;
    public static final int LN = 8;
    public static final int LOG10 = 9;
    public static final int DEGREES = 10;
    public static final int RADIANS = 11;
    private int type;

    public DoubleFunction() {
    }

    public DoubleFunction(Expression<?> operand, int type) {
        super(operand);
        this.type = type;
    }

    public static DoubleFunction create(Expression<?> operand, int type) {
        return new DoubleFunction(operand, type);
    }

    @Override
    public Double eval(Row row, ExpressionEvalContext context) {
        Object value = this.operand.eval(row, context);
        if (value == null) {
            return null;
        }
        assert (value instanceof Number);
        double valueDouble = ((Number)value).doubleValue();
        switch (this.type) {
            case 0: {
                return Math.cos(valueDouble);
            }
            case 1: {
                return Math.sin(valueDouble);
            }
            case 2: {
                return Math.tan(valueDouble);
            }
            case 3: {
                return 1.0 / Math.tan(valueDouble);
            }
            case 4: {
                return Math.acos(valueDouble);
            }
            case 5: {
                return Math.asin(valueDouble);
            }
            case 6: {
                return Math.atan(valueDouble);
            }
            case 7: {
                return Math.exp(valueDouble);
            }
            case 8: {
                return Math.log(valueDouble);
            }
            case 9: {
                return Math.log10(valueDouble);
            }
            case 10: {
                return Math.toDegrees(valueDouble);
            }
            case 11: {
                return Math.toRadians(valueDouble);
            }
        }
        throw QueryException.error("Unsupported function type: " + this.type);
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.DOUBLE;
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 44;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeInt(this.type);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.type = in.readInt();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DoubleFunction that = (DoubleFunction)o;
        return this.type == that.type;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.type;
        return result;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{type=" + this.type + ", operand=" + this.operand + '}';
    }
}

