/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.instance.impl.HazelcastInstanceFactory;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.spring.AbstractHazelcastBeanDefinitionParser;
import com.hazelcast.spring.HazelcastConfigBeanDefinitionParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HazelcastInstanceDefinitionParser
extends AbstractHazelcastBeanDefinitionParser {
    static final String CP_SUBSYSTEM_SUFFIX = "@cp-subsystem";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlBuilder springXmlBuilder = new SpringXmlBuilder(parserContext);
        springXmlBuilder.handle(element);
        return springXmlBuilder.getBeanDefinition();
    }

    private class SpringXmlBuilder
    extends AbstractHazelcastBeanDefinitionParser.SpringXmlBuilderHelper {
        private final ParserContext parserContext;
        private final BeanDefinitionBuilder builder;

        SpringXmlBuilder(ParserContext parserContext) {
            this.parserContext = parserContext;
            this.builder = BeanDefinitionBuilder.rootBeanDefinition(HazelcastInstanceFactory.class);
            this.builder.setFactoryMethod("newHazelcastInstance");
            this.builder.setDestroyMethodName("shutdown");
        }

        AbstractBeanDefinition getBeanDefinition() {
            return this.builder.getBeanDefinition();
        }

        public void handle(Element element) {
            this.handleCommonBeanAttributes(element, this.builder, this.parserContext);
            Element config = null;
            for (Node node : DomConfigHelper.childElements(element)) {
                String nodeName = DomConfigHelper.cleanNodeName(node);
                if (!"config".equals(nodeName)) continue;
                config = (Element)node;
            }
            HazelcastConfigBeanDefinitionParser configParser = new HazelcastConfigBeanDefinitionParser();
            AbstractBeanDefinition configBeanDef = configParser.parseInternal(config, this.parserContext);
            this.builder.addConstructorArgValue((Object)configBeanDef);
            this.registerCPSubsystemBean(element);
        }

        private void registerCPSubsystemBean(Element element) {
            String instanceBeanRef = element.getAttribute("id");
            BeanDefinitionBuilder cpBeanDefBuilder = BeanDefinitionBuilder.rootBeanDefinition(CPSubsystem.class);
            cpBeanDefBuilder.setFactoryMethodOnBean("getCPSubsystem", instanceBeanRef);
            BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)cpBeanDefBuilder.getBeanDefinition(), instanceBeanRef + HazelcastInstanceDefinitionParser.CP_SUBSYSTEM_SUFFIX);
            HazelcastInstanceDefinitionParser.this.registerBeanDefinition(holder, this.parserContext.getRegistry());
        }
    }
}

