/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.codehaus.janino;

import com.hazelcast.org.codehaus.commons.nullanalysis.Nullable;
import com.hazelcast.org.codehaus.janino.ClassFileIClass;
import com.hazelcast.org.codehaus.janino.Descriptor;
import com.hazelcast.org.codehaus.janino.IClass;
import com.hazelcast.org.codehaus.janino.IClassLoader;
import com.hazelcast.org.codehaus.janino.util.ClassFile;
import com.hazelcast.org.codehaus.janino.util.resource.Resource;
import com.hazelcast.org.codehaus.janino.util.resource.ResourceFinder;
import java.io.IOException;
import java.io.InputStream;

public class ResourceFinderIClassLoader
extends IClassLoader {
    private final ResourceFinder resourceFinder;

    public ResourceFinderIClassLoader(ResourceFinder resourceFinder, @Nullable IClassLoader optionalParentIClassLoader) {
        super(optionalParentIClassLoader);
        this.resourceFinder = resourceFinder;
        this.postConstruct();
    }

    @Override
    @Nullable
    protected IClass findIClass(String descriptor) throws ClassNotFoundException {
        ClassFile cf;
        InputStream is;
        String className = Descriptor.toClassName(descriptor);
        Resource classFileResource = this.resourceFinder.findResource(ClassFile.getClassFileResourceName(className));
        if (classFileResource == null) {
            return null;
        }
        try {
            is = classFileResource.open();
        }
        catch (IOException ex) {
            throw new ClassNotFoundException("Opening resource \"" + classFileResource.getFileName() + "\"", ex);
        }
        try {
            cf = new ClassFile(is);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Reading resource \"" + classFileResource.getFileName() + "\"", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
        ClassFileIClass iClass = new ClassFileIClass(cf, this);
        this.defineIClass(iClass);
        return iClass;
    }
}

