/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.validate;

import com.hazelcast.com.google.common.collect.Lists;
import com.hazelcast.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import com.hazelcast.org.apache.calcite.schema.AggregateFunction;
import com.hazelcast.org.apache.calcite.schema.FunctionParameter;
import com.hazelcast.org.apache.calcite.sql.SqlAggFunction;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlReturnTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.util.Optionality;
import com.hazelcast.org.apache.calcite.util.Util;
import java.util.ArrayList;
import java.util.List;

public class SqlUserDefinedAggFunction
extends SqlAggFunction {
    public final AggregateFunction function;
    public final RelDataTypeFactory typeFactory;

    public SqlUserDefinedAggFunction(SqlIdentifier opName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, AggregateFunction function, boolean requiresOrder, boolean requiresOver, Optionality requiresGroupOrder, RelDataTypeFactory typeFactory) {
        super(Util.last(opName.names), opName, SqlKind.OTHER_FUNCTION, returnTypeInference, operandTypeInference, operandTypeChecker, SqlFunctionCategory.USER_DEFINED_FUNCTION, requiresOrder, requiresOver, requiresGroupOrder);
        this.function = function;
        this.typeFactory = typeFactory;
    }

    @Override
    public List<RelDataType> getParamTypes() {
        ArrayList<RelDataType> argTypes = new ArrayList<RelDataType>();
        for (FunctionParameter o : this.function.getParameters()) {
            RelDataType type = o.getType(this.typeFactory);
            argTypes.add(type);
        }
        return this.toSql(argTypes);
    }

    private List<RelDataType> toSql(List<RelDataType> types) {
        return Lists.transform(types, this::toSql);
    }

    private RelDataType toSql(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType && ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass() == Object.class) {
            return this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.ANY), true);
        }
        return JavaTypeFactoryImpl.toSql(this.typeFactory, type);
    }

    @Override
    public List<RelDataType> getParameterTypes(RelDataTypeFactory typeFactory) {
        return Lists.transform(this.function.getParameters(), parameter -> parameter.getType(typeFactory));
    }

    @Override
    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        return this.function.getReturnType(typeFactory);
    }
}

