/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.operation;

import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.operation.QueryAbstractExchangeOperation;
import com.hazelcast.sql.impl.row.RowBatch;
import java.io.IOException;
import java.util.UUID;

public class QueryBatchExchangeOperation
extends QueryAbstractExchangeOperation {
    private UUID targetMemberId;
    private RowBatch batch;
    private boolean last;
    private long remainingMemory;

    public QueryBatchExchangeOperation() {
    }

    public QueryBatchExchangeOperation(QueryId queryId, int edgeId, UUID targetMemberId, RowBatch batch, boolean last, long remainingMemory) {
        super(queryId, edgeId);
        assert (batch != null);
        assert (remainingMemory >= 0L);
        this.targetMemberId = targetMemberId;
        this.batch = batch;
        this.last = last;
        this.remainingMemory = remainingMemory;
    }

    public UUID getTargetMemberId() {
        return this.targetMemberId;
    }

    public RowBatch getBatch() {
        return this.batch;
    }

    public boolean isLast() {
        return this.last;
    }

    public long getRemainingMemory() {
        return this.remainingMemory;
    }

    @Override
    public boolean isInbound() {
        return true;
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    protected void writeInternal2(ObjectDataOutput out) throws IOException {
        UUIDSerializationUtil.writeUUID(out, this.targetMemberId);
        out.writeObject(this.batch);
        out.writeBoolean(this.last);
        out.writeLong(this.remainingMemory);
    }

    @Override
    protected void readInternal2(ObjectDataInput in) throws IOException {
        this.targetMemberId = UUIDSerializationUtil.readUUID(in);
        this.batch = (RowBatch)in.readObject();
        this.last = in.readBoolean();
        this.remainingMemory = in.readLong();
    }
}

