/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.string;

import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.Row;
import java.util.Locale;

public final class StringFunctionUtils {
    private StringFunctionUtils() {
    }

    public static String concat(String first, String second) {
        return first != null && second != null ? first + second : null;
    }

    public static Integer charLength(String value) {
        return value != null ? Integer.valueOf(value.length()) : null;
    }

    public static Integer ascii(String value) {
        return value != null ? Integer.valueOf(value.isEmpty() ? 0 : value.codePointAt(0)) : null;
    }

    public static String upper(String value) {
        return value != null ? value.toUpperCase(Locale.ROOT) : null;
    }

    public static String lower(String value) {
        return value != null ? value.toLowerCase(Locale.ROOT) : null;
    }

    public static String initcap(String value) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            return value;
        }
        int strLen = value.length();
        StringBuilder res = new StringBuilder(strLen);
        boolean capitalizeNext = true;
        for (int i = 0; i < strLen; ++i) {
            char c = value.charAt(i);
            if (!Character.isLetterOrDigit(c)) {
                res.append(c);
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                res.append(Character.toTitleCase(c));
                capitalizeNext = false;
                continue;
            }
            res.append(Character.toLowerCase(c));
        }
        return res.toString();
    }

    public static String asVarchar(Expression<?> expression, Row row, ExpressionEvalContext context) {
        Object res = expression.eval(row, context);
        if (res == null) {
            return null;
        }
        return expression.getType().getConverter().asVarchar(res);
    }
}

