/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.root;

import com.hazelcast.sql.impl.exec.AbstractUpstreamAwareExec;
import com.hazelcast.sql.impl.exec.Exec;
import com.hazelcast.sql.impl.exec.IterationResult;
import com.hazelcast.sql.impl.exec.root.RootResultConsumer;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.row.RowBatch;
import com.hazelcast.sql.impl.worker.QueryFragmentContext;
import java.util.ArrayList;
import java.util.Iterator;

public class RootExec
extends AbstractUpstreamAwareExec {
    private final RootResultConsumer consumer;
    private final int batchSize;
    private ArrayList<Row> batch;

    public RootExec(int id, Exec upstream, RootResultConsumer consumer, int batchSize) {
        super(id, upstream);
        this.consumer = consumer;
        this.batchSize = batchSize;
        this.batch = new ArrayList(batchSize);
    }

    @Override
    protected void setup1(QueryFragmentContext ctx) {
        this.consumer.setup(ctx::schedule);
    }

    @Override
    public IterationResult advance0() {
        block0: while (true) {
            int remaining = this.batchSize - this.batch.size();
            boolean upstreamDone = this.state.isDone();
            if (remaining == 0 || upstreamDone) {
                if (this.consumer.consume(this.batch, upstreamDone)) {
                    if (upstreamDone) {
                        return IterationResult.FETCHED_DONE;
                    }
                    this.batch = new ArrayList(this.batchSize);
                    remaining = this.batchSize;
                } else {
                    return IterationResult.WAIT;
                }
            }
            assert (remaining != 0);
            if (!this.state.advance()) {
                return IterationResult.WAIT;
            }
            Iterator<Row> iterator = this.state.iterator();
            do {
                if (!iterator.hasNext()) continue block0;
                Row row = iterator.next();
                this.batch.add(row);
            } while (--remaining != 0);
        }
    }

    @Override
    public RowBatch currentBatch0() {
        throw new UnsupportedOperationException("Should not be called.");
    }

    public RootResultConsumer getConsumer() {
        return this.consumer;
    }

    public int getBatchSize() {
        return this.batchSize;
    }
}

