/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import java.util.UUID;

public class SqlError {
    private final int code;
    private final String message;
    private final UUID originatingMemberId;

    public SqlError(int code, String message, UUID originatingMemberId) {
        this.code = code;
        this.message = message;
        this.originatingMemberId = originatingMemberId;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public UUID getOriginatingMemberId() {
        return this.originatingMemberId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlError sqlError = (SqlError)o;
        if (this.code != sqlError.code) {
            return false;
        }
        if (!this.message.equals(sqlError.message)) {
            return false;
        }
        return this.originatingMemberId.equals(sqlError.originatingMemberId);
    }

    public int hashCode() {
        int result = this.code;
        result = 31 * result + this.message.hashCode();
        result = 31 * result + this.originatingMemberId.hashCode();
        return result;
    }
}

