/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.interpreter;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import com.hazelcast.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import com.hazelcast.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import com.hazelcast.org.apache.calcite.config.CalciteSystemProperty;
import com.hazelcast.org.apache.calcite.interpreter.Context;
import com.hazelcast.org.apache.calcite.interpreter.Interpreter;
import com.hazelcast.org.apache.calcite.interpreter.Scalar;
import com.hazelcast.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import com.hazelcast.org.apache.calcite.linq4j.function.Function1;
import com.hazelcast.org.apache.calcite.linq4j.tree.BlockBuilder;
import com.hazelcast.org.apache.calcite.linq4j.tree.BlockStatement;
import com.hazelcast.org.apache.calcite.linq4j.tree.ClassDeclaration;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.org.apache.calcite.linq4j.tree.MemberDeclaration;
import com.hazelcast.org.apache.calcite.linq4j.tree.MemberExpression;
import com.hazelcast.org.apache.calcite.linq4j.tree.ParameterExpression;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexProgram;
import com.hazelcast.org.apache.calcite.rex.RexProgramBuilder;
import com.hazelcast.org.apache.calcite.sql.validate.SqlConformanceEnum;
import com.hazelcast.org.apache.calcite.util.BuiltInMethod;
import com.hazelcast.org.apache.calcite.util.Pair;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.codehaus.commons.compiler.CompileException;
import com.hazelcast.org.codehaus.commons.compiler.CompilerFactoryFactory;
import com.hazelcast.org.codehaus.commons.compiler.IClassBodyEvaluator;
import com.hazelcast.org.codehaus.commons.compiler.ICompilerFactory;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class JaninoRexCompiler
implements Interpreter.ScalarCompiler {
    private final RexBuilder rexBuilder;

    public JaninoRexCompiler(RexBuilder rexBuilder) {
        this.rexBuilder = rexBuilder;
    }

    @Override
    public Scalar compile(List<RexNode> nodes, RelDataType inputRowType) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(inputRowType, this.rexBuilder);
        for (RexNode node : nodes) {
            programBuilder.addProject(node, null);
        }
        RexProgram program = programBuilder.getProgram();
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression context_ = Expressions.parameter(Context.class, "context");
        ParameterExpression outputValues_ = Expressions.parameter(Object[].class, "outputValues");
        JavaTypeFactoryImpl javaTypeFactory = new JavaTypeFactoryImpl(this.rexBuilder.getTypeFactory().getTypeSystem());
        RexToLixTranslator.InputGetterImpl inputGetter = new RexToLixTranslator.InputGetterImpl(ImmutableList.of(Pair.of(Expressions.field((Expression)context_, BuiltInMethod.CONTEXT_VALUES.field), PhysTypeImpl.of(javaTypeFactory, inputRowType, JavaRowFormat.ARRAY, false))));
        Function1<String, RexToLixTranslator.InputGetter> correlates = a0 -> {
            throw new UnsupportedOperationException();
        };
        MemberExpression root = Expressions.field((Expression)context_, BuiltInMethod.CONTEXT_ROOT.field);
        SqlConformanceEnum conformance = SqlConformanceEnum.DEFAULT;
        List<Expression> list = RexToLixTranslator.translateProjects(program, javaTypeFactory, conformance, builder, null, root, inputGetter, correlates);
        for (int i = 0; i < list.size(); ++i) {
            builder.add(Expressions.statement(Expressions.assign(Expressions.arrayIndex(outputValues_, Expressions.constant(i)), list.get(i))));
        }
        return JaninoRexCompiler.baz(context_, outputValues_, builder.toBlock());
    }

    static Scalar baz(ParameterExpression context_, ParameterExpression outputValues_, BlockStatement block) {
        ArrayList<MemberDeclaration> declarations = new ArrayList<MemberDeclaration>();
        declarations.add(Expressions.methodDecl(1, Void.TYPE, BuiltInMethod.SCALAR_EXECUTE2.method.getName(), ImmutableList.of(context_, outputValues_), block));
        BlockBuilder builder = new BlockBuilder();
        Expression values_ = builder.append("values", Expressions.newArrayBounds(Object.class, 1, Expressions.constant(1)));
        builder.add(Expressions.statement(Expressions.call((Expression)Expressions.parameter(Scalar.class, "this"), BuiltInMethod.SCALAR_EXECUTE2.method, context_, values_)));
        builder.add(Expressions.return_(null, Expressions.arrayIndex(values_, Expressions.constant(0))));
        declarations.add(Expressions.methodDecl(1, Object.class, BuiltInMethod.SCALAR_EXECUTE1.method.getName(), ImmutableList.of(context_), builder.toBlock()));
        ClassDeclaration classDeclaration = Expressions.classDecl(1, "Buzz", null, ImmutableList.of(Scalar.class), declarations);
        String s = Expressions.toString(declarations, "\n", false);
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            Util.debugCode(System.out, s);
        }
        try {
            return JaninoRexCompiler.getScalar(classDeclaration, s);
        }
        catch (CompileException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Scalar getScalar(ClassDeclaration expr, String s) throws CompileException, IOException {
        ICompilerFactory compilerFactory;
        try {
            compilerFactory = CompilerFactoryFactory.getDefaultCompilerFactory();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate java compiler", e);
        }
        IClassBodyEvaluator cbe = compilerFactory.newClassBodyEvaluator();
        cbe.setClassName(expr.name);
        cbe.setImplementedInterfaces(new Class[]{Scalar.class});
        cbe.setParentClassLoader(JaninoRexCompiler.class.getClassLoader());
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            cbe.setDebuggingInformation(true, true, true);
        }
        return (Scalar)cbe.createInstance(new StringReader(s));
    }
}

