/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.wan;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.SerializationServiceAware;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.wan.WanEventCounters;
import com.hazelcast.wan.WanEventType;
import com.hazelcast.wan.impl.InternalWanEvent;
import com.hazelcast.wan.impl.WanDataSerializerHook;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WanMapRemoveEvent
implements InternalWanEvent<Object>,
SerializationServiceAware {
    private SerializationService serializationService;
    private String mapName;
    private Data dataKey;
    private transient Object key;

    public WanMapRemoveEvent(@Nonnull String mapName, @Nonnull Data dataKey, @Nonnull SerializationService serializationService) {
        this.mapName = mapName;
        this.dataKey = dataKey;
        this.serializationService = serializationService;
    }

    public WanMapRemoveEvent() {
    }

    @Override
    @Nonnull
    public Data getKey() {
        return this.dataKey;
    }

    @Override
    @Nullable
    public Object getEventObject() {
        if (this.key == null) {
            this.key = this.serializationService.toObject(this.dataKey);
        }
        return this.key;
    }

    @Override
    @Nonnull
    public Set<String> getClusterNames() {
        return Collections.emptySet();
    }

    @Override
    public int getBackupCount() {
        return 0;
    }

    @Override
    public long getCreationTime() {
        return 0L;
    }

    @Override
    @Nonnull
    public String getObjectName() {
        return this.mapName;
    }

    @Override
    @Nonnull
    public WanEventType getEventType() {
        return WanEventType.REMOVE;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.mapName);
        IOUtil.writeData(out, this.dataKey);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.mapName = in.readUTF();
        this.dataKey = IOUtil.readData(in);
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void incrementEventCount(@Nonnull WanEventCounters counters) {
        counters.incrementRemove(this.mapName);
    }

    @Override
    @Nonnull
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public void setSerializationService(SerializationService serializationService) {
        this.serializationService = serializationService;
    }
}

