/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl;

import com.hazelcast.cache.CacheStatistics;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.monitor.LocalCacheStats;

public class LocalCacheStatsImpl
implements LocalCacheStats {
    @Probe(name="creationTime", unit=ProbeUnit.MS)
    private long creationTime;
    @Probe(name="lastAccessTime", unit=ProbeUnit.MS)
    private long lastAccessTime;
    @Probe(name="lastUpdateTime", unit=ProbeUnit.MS)
    private long lastUpdateTime;
    @Probe(name="ownedEntryCount")
    private long ownedEntryCount;
    @Probe(name="cacheHits")
    private long cacheHits;
    @Probe(name="cacheHitPercentage", unit=ProbeUnit.PERCENT)
    private float cacheHitPercentage;
    @Probe(name="cacheMisses")
    private long cacheMisses;
    @Probe(name="cacheMissPercentage", unit=ProbeUnit.PERCENT)
    private float cacheMissPercentage;
    @Probe(name="cacheGets")
    private long cacheGets;
    @Probe(name="cachePuts")
    private long cachePuts;
    @Probe(name="cacheRemovals")
    private long cacheRemovals;
    @Probe(name="cacheEvictions")
    private long cacheEvictions;
    @Probe(name="averageGetTime", unit=ProbeUnit.MS)
    private float averageGetTime;
    @Probe(name="averagePutTime", unit=ProbeUnit.MS)
    private float averagePutTime;
    @Probe(name="averageRemovalTime", unit=ProbeUnit.MS)
    private float averageRemoveTime;

    public LocalCacheStatsImpl() {
    }

    public LocalCacheStatsImpl(CacheStatistics cacheStatistics) {
        this.creationTime = cacheStatistics.getCreationTime();
        this.lastAccessTime = cacheStatistics.getLastAccessTime();
        this.lastUpdateTime = cacheStatistics.getLastUpdateTime();
        this.ownedEntryCount = cacheStatistics.getOwnedEntryCount();
        this.cacheHits = cacheStatistics.getCacheHits();
        this.cacheHitPercentage = cacheStatistics.getCacheHitPercentage();
        this.cacheMisses = cacheStatistics.getCacheMisses();
        this.cacheMissPercentage = cacheStatistics.getCacheMissPercentage();
        this.cacheGets = cacheStatistics.getCacheGets();
        this.cachePuts = cacheStatistics.getCachePuts();
        this.cacheRemovals = cacheStatistics.getCacheRemovals();
        this.cacheEvictions = cacheStatistics.getCacheEvictions();
        this.averageGetTime = cacheStatistics.getAverageGetTime();
        this.averagePutTime = cacheStatistics.getAveragePutTime();
        this.averageRemoveTime = cacheStatistics.getAverageRemoveTime();
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public long getOwnedEntryCount() {
        return this.ownedEntryCount;
    }

    @Override
    public long getCacheHits() {
        return this.cacheHits;
    }

    @Override
    public float getCacheHitPercentage() {
        return this.cacheHitPercentage;
    }

    @Override
    public long getCacheMisses() {
        return this.cacheMisses;
    }

    @Override
    public float getCacheMissPercentage() {
        return this.cacheMissPercentage;
    }

    @Override
    public long getCacheGets() {
        return this.cacheGets;
    }

    @Override
    public long getCachePuts() {
        return this.cachePuts;
    }

    @Override
    public long getCacheRemovals() {
        return this.cacheRemovals;
    }

    @Override
    public long getCacheEvictions() {
        return this.cacheEvictions;
    }

    @Override
    public float getAverageGetTime() {
        return this.averageGetTime;
    }

    @Override
    public float getAveragePutTime() {
        return this.averagePutTime;
    }

    @Override
    public float getAverageRemoveTime() {
        return this.averageRemoveTime;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    public String toString() {
        return "LocalCacheStatsImpl{creationTime=" + this.creationTime + ", lastAccessTime=" + this.lastAccessTime + ", lastUpdateTime=" + this.lastUpdateTime + ", ownedEntryCount=" + this.ownedEntryCount + ", cacheHits=" + this.cacheHits + ", cacheHitPercentage=" + this.cacheHitPercentage + ", cacheMisses=" + this.cacheMisses + ", cacheMissPercentage=" + this.cacheMissPercentage + ", cacheGets=" + this.cacheGets + ", cachePuts=" + this.cachePuts + ", cacheRemovals=" + this.cacheRemovals + ", cacheEvictions=" + this.cacheEvictions + ", averageGetTime=" + this.averageGetTime + ", averagePutTime=" + this.averagePutTime + ", averageRemoveTime=" + this.averageRemoveTime + '}';
    }
}

