/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

public enum ClusterState {
    ACTIVE(true, true, true, 0),
    NO_MIGRATION(true, false, true, 1),
    FROZEN(false, false, false, 2),
    PASSIVE(false, false, false, 3),
    IN_TRANSITION(false, false, false, 4);

    private final boolean joinAllowed;
    private final boolean migrationAllowed;
    private final boolean partitionPromotionAllowed;
    private final byte id;

    private ClusterState(boolean joinAllowed, boolean migrationAllowed, boolean partitionPromotionAllowed, int id) {
        this.joinAllowed = joinAllowed;
        this.migrationAllowed = migrationAllowed;
        this.partitionPromotionAllowed = partitionPromotionAllowed;
        this.id = (byte)id;
    }

    public boolean isJoinAllowed() {
        return this.joinAllowed;
    }

    public boolean isMigrationAllowed() {
        return this.migrationAllowed;
    }

    public boolean isPartitionPromotionAllowed() {
        return this.partitionPromotionAllowed;
    }

    public byte getId() {
        return this.id;
    }

    public static ClusterState getById(int id) {
        for (ClusterState cs : ClusterState.values()) {
            if (cs.getId() != id) continue;
            return cs;
        }
        throw new IllegalArgumentException("Unsupported ID value");
    }
}

