/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.management;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MCTriggerHotRestartBackupCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import java.security.Permission;
import java.util.concurrent.Future;

public class HotRestartTriggerBackupMessageTask
extends AbstractCallableMessageTask<MCTriggerHotRestartBackupCodec.RequestParameters> {
    private final Node node;

    public HotRestartTriggerBackupMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
        this.node = node;
    }

    @Override
    protected Object call() throws Exception {
        ILogger logger = this.nodeEngine.getLogger(this.getClass());
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        Future<Void> future = executionService.submit("hz:async", () -> {
            this.node.getNodeExtension().getHotRestartService().backup();
            return null;
        });
        executionService.asCompletableFuture(future).whenCompleteAsync(ExceptionUtil.withTryCatch(logger, (empty, error) -> this.sendResponse(error != null ? ExceptionUtil.peel(error) : null)), ConcurrencyUtil.CALLER_RUNS);
        return null;
    }

    @Override
    protected MCTriggerHotRestartBackupCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MCTriggerHotRestartBackupCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MCTriggerHotRestartBackupCodec.encodeResponse();
    }

    @Override
    public String getServiceName() {
        return "hz:core:managementCenterService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "triggerHotRestartBackup";
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public boolean isManagementTask() {
        return true;
    }
}

