/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.ByteArrayCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class ClientStatisticsCodec {
    public static final int REQUEST_MESSAGE_TYPE = 3072;
    public static final int RESPONSE_MESSAGE_TYPE = 3073;
    private static final int REQUEST_TIMESTAMP_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 24;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private ClientStatisticsCodec() {
    }

    public static ClientMessage encodeRequest(long timestamp, String clientAttributes, byte[] metricsBlob) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Client.Statistics");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[24], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 3072);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, timestamp);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, clientAttributes);
        ByteArrayCodec.encode(clientMessage, metricsBlob);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.timestamp = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        request.clientAttributes = StringCodec.decode(iterator);
        request.metricsBlob = ByteArrayCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 3073);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public long timestamp;
        public String clientAttributes;
        public byte[] metricsBlob;
    }
}

