/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientCloudConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ClientFlakeIdGeneratorConfig;
import com.hazelcast.client.config.ClientIcmpPingConfig;
import com.hazelcast.client.config.ClientMetricsConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientReliableTopicConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.config.ConnectionRetryConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.util.RandomLB;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.config.AliasedDiscoveryConfig;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MetricsJmxConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.security.TokenEncoding;
import com.hazelcast.config.security.TokenIdentityConfig;
import com.hazelcast.config.security.UsernamePasswordIdentityConfig;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.internal.config.AliasedDiscoveryConfigUtils;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.spring.AbstractHazelcastBeanDefinitionParser;
import java.util.ArrayList;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HazelcastClientBeanDefinitionParser
extends AbstractHazelcastBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlBuilder springXmlBuilder = new SpringXmlBuilder(parserContext);
        AbstractBeanDefinition bean = springXmlBuilder.handleClient(element);
        this.registerCPSubsystemBean(element, parserContext);
        return bean;
    }

    private void registerCPSubsystemBean(Element element, ParserContext parserContext) {
        String instanceBeanRef = element.getAttribute("id");
        BeanDefinitionBuilder cpBeanDefBuilder = BeanDefinitionBuilder.rootBeanDefinition(CPSubsystem.class);
        cpBeanDefBuilder.setFactoryMethodOnBean("getCPSubsystem", instanceBeanRef);
        cpBeanDefBuilder.setLazyInit(true);
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)cpBeanDefBuilder.getBeanDefinition(), instanceBeanRef + "@cp-subsystem");
        this.registerBeanDefinition(holder, parserContext.getRegistry());
    }

    public static class SpringXmlBuilder
    extends AbstractHazelcastBeanDefinitionParser.SpringXmlBuilderHelper {
        private static final int INITIAL_CAPACITY = 10;
        private final ParserContext parserContext;
        private final BeanDefinitionBuilder builder;
        private final ManagedMap<String, BeanDefinition> nearCacheConfigMap = new ManagedMap();
        private final ManagedMap<String, BeanDefinition> flakeIdGeneratorConfigMap = new ManagedMap();
        private final ManagedMap<String, BeanDefinition> reliableTopicConfigMap = new ManagedMap();

        SpringXmlBuilder(ParserContext parserContext) {
            this(parserContext, BeanDefinitionBuilder.rootBeanDefinition(HazelcastClient.class).setFactoryMethod("newHazelcastClient").setDestroyMethodName("shutdown"));
        }

        public SpringXmlBuilder(ParserContext parserContext, BeanDefinitionBuilder builder) {
            this.parserContext = parserContext;
            this.builder = builder;
            this.configBuilder = BeanDefinitionBuilder.rootBeanDefinition(ClientConfig.class);
            this.configBuilder.addPropertyValue("nearCacheConfigMap", this.nearCacheConfigMap);
            this.configBuilder.addPropertyValue("flakeIdGeneratorConfigMap", this.flakeIdGeneratorConfigMap);
            this.configBuilder.addPropertyValue("reliableTopicConfigMap", this.reliableTopicConfigMap);
        }

        public AbstractBeanDefinition handleClient(Node rootNode) {
            AbstractBeanDefinition configBean = this.createConfigBean(rootNode);
            this.builder.addConstructorArgValue((Object)configBean);
            return this.builder.getBeanDefinition();
        }

        AbstractBeanDefinition createConfigBean(Node rootNode) {
            this.handleCommonBeanAttributes(rootNode, this.builder, this.parserContext);
            for (Node node : DomConfigHelper.childElements(rootNode)) {
                String nodeName = DomConfigHelper.cleanNodeName(node);
                if ("cluster-name".equals(nodeName)) {
                    this.configBuilder.addPropertyValue("clusterName", (Object)this.getTextContent(node));
                    continue;
                }
                if ("properties".equals(nodeName)) {
                    this.handleProperties(node, this.configBuilder);
                    continue;
                }
                if ("network".equals(nodeName)) {
                    this.handleNetwork(node);
                    continue;
                }
                if ("listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(node, ListenerConfig.class);
                    this.configBuilder.addPropertyValue("listenerConfigs", (Object)listeners);
                    continue;
                }
                if ("serialization".equals(nodeName)) {
                    this.handleSerialization(node);
                    continue;
                }
                if ("proxy-factories".equals(nodeName)) {
                    ManagedList list = this.parseProxyFactories(node, ProxyFactoryConfig.class);
                    this.configBuilder.addPropertyValue("proxyFactoryConfigs", (Object)list);
                    continue;
                }
                if ("load-balancer".equals(nodeName)) {
                    this.handleLoadBalancer(node);
                    continue;
                }
                if ("near-cache".equals(nodeName)) {
                    this.handleNearCache(node);
                    continue;
                }
                if ("spring-aware".equals(nodeName)) {
                    this.handleSpringAware();
                    continue;
                }
                if ("query-caches".equals(nodeName)) {
                    ManagedMap queryCaches = this.getQueryCaches(node);
                    this.configBuilder.addPropertyValue("queryCacheConfigs", (Object)queryCaches);
                    continue;
                }
                if ("connection-strategy".equals(nodeName)) {
                    this.handleConnectionStrategy(node);
                    continue;
                }
                if ("user-code-deployment".equals(nodeName)) {
                    this.handleUserCodeDeployment(node);
                    continue;
                }
                if ("flake-id-generator".equals(nodeName)) {
                    this.handleFlakeIdGenerator(node);
                    continue;
                }
                if ("reliable-topic".equals(nodeName)) {
                    this.handleReliableTopic(node);
                    continue;
                }
                if ("security".equals(nodeName)) {
                    this.handleSecurity(node);
                    continue;
                }
                if ("instance-name".equals(nodeName)) {
                    this.configBuilder.addPropertyValue("instanceName", (Object)this.getTextContent(node));
                    continue;
                }
                if ("labels".equals(nodeName)) {
                    this.handleLabels(node);
                    continue;
                }
                if ("backup-ack-to-client-enabled".equals(nodeName)) {
                    this.configBuilder.addPropertyValue("backupAckToClientEnabled", (Object)this.getTextContent(node));
                    continue;
                }
                if (!"metrics".equals(nodeName)) continue;
                this.handleMetrics(node);
            }
            return this.configBuilder.getBeanDefinition();
        }

        private void handleSecurity(Node node) {
            BeanDefinitionBuilder securityConfigBuilder = this.createBeanBuilder(ClientSecurityConfig.class);
            AbstractBeanDefinition beanDefinition = securityConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, securityConfigBuilder, new String[0]);
            for (Node child : DomConfigHelper.childElements(node)) {
                BeanDefinitionBuilder configBuilder;
                String nodeName = DomConfigHelper.cleanNodeName(child);
                if ("credentials-factory".equals(nodeName)) {
                    this.handleCredentialsFactory(child, securityConfigBuilder);
                    continue;
                }
                if ("username-password".equals(nodeName)) {
                    configBuilder = this.createBeanBuilder(UsernamePasswordIdentityConfig.class).addConstructorArgValue((Object)this.getAttribute(child, "username")).addConstructorArgValue((Object)this.getAttribute(child, "password"));
                    securityConfigBuilder.addPropertyValue("UsernamePasswordIdentityConfig", (Object)configBuilder.getBeanDefinition());
                    continue;
                }
                if ("token".equals(nodeName)) {
                    configBuilder = this.createBeanBuilder(TokenIdentityConfig.class).addConstructorArgValue((Object)TokenEncoding.getTokenEncoding(this.getAttribute(child, "encoding"))).addConstructorArgValue((Object)this.getTextContent(child));
                    securityConfigBuilder.addPropertyValue("TokenIdentityConfig", (Object)configBuilder.getBeanDefinition());
                    continue;
                }
                if (!"credentials-ref".equals(nodeName)) continue;
                securityConfigBuilder.addPropertyReference("credentials", this.getTextContent(child));
            }
            this.configBuilder.addPropertyValue("securityConfig", (Object)beanDefinition);
        }

        void handleCredentialsFactory(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            BeanDefinitionBuilder credentialsConfigBuilder = this.createBeanBuilder(CredentialsFactoryConfig.class);
            AbstractBeanDefinition beanDefinition = credentialsConfigBuilder.getBeanDefinition();
            NamedNodeMap attributes = node.getAttributes();
            Node classNameNode = attributes.getNamedItem("class-name");
            String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
            Node implNode = attributes.getNamedItem("implementation");
            String implementation = implNode != null ? this.getTextContent(implNode) : null;
            credentialsConfigBuilder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                credentialsConfigBuilder.addPropertyReference("implementation", implementation);
            }
            Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create CredentialsFactory!");
            for (Node child : DomConfigHelper.childElements(node)) {
                String nodeName = DomConfigHelper.cleanNodeName(child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, credentialsConfigBuilder);
                break;
            }
            securityConfigBuilder.addPropertyValue("credentialsFactoryConfig", (Object)beanDefinition);
        }

        private void handleConnectionStrategy(Node node) {
            BeanDefinitionBuilder clientConnectionStrategyConfig = this.createBeanBuilder(ClientConnectionStrategyConfig.class);
            this.fillAttributeValues(node, clientConnectionStrategyConfig, new String[0]);
            for (Node child : DomConfigHelper.childElements(node)) {
                String nodeName = DomConfigHelper.cleanNodeName(child);
                if (!"connection-retry".equals(nodeName)) continue;
                this.createAndFillBeanBuilder(child, ConnectionRetryConfig.class, "ConnectionRetryConfig", clientConnectionStrategyConfig, new String[0]);
            }
            this.configBuilder.addPropertyValue("connectionStrategyConfig", (Object)clientConnectionStrategyConfig.getBeanDefinition());
        }

        private void handleUserCodeDeployment(Node node) {
            BeanDefinitionBuilder userCodeDeploymentConfig = this.createBeanBuilder(ClientUserCodeDeploymentConfig.class);
            ArrayList<String> jarPaths = new ArrayList<String>(10);
            ArrayList<String> classNames = new ArrayList<String>(10);
            this.fillAttributeValues(node, userCodeDeploymentConfig, new String[0]);
            for (Node child : DomConfigHelper.childElements(node)) {
                String nodeName1;
                String nodeName = DomConfigHelper.cleanNodeName(child);
                if ("jarpaths".equals(nodeName)) {
                    for (Node child1 : DomConfigHelper.childElements(child)) {
                        nodeName1 = DomConfigHelper.cleanNodeName(child1);
                        if (!"jarpath".equals(nodeName1)) continue;
                        jarPaths.add(this.getTextContent(child1));
                    }
                    continue;
                }
                if (!"classnames".equals(nodeName)) continue;
                for (Node child1 : DomConfigHelper.childElements(child)) {
                    nodeName1 = DomConfigHelper.cleanNodeName(child1);
                    if (!"classname".equals(nodeName1)) continue;
                    classNames.add(this.getTextContent(child1));
                }
            }
            userCodeDeploymentConfig.addPropertyValue("jarPaths", jarPaths);
            userCodeDeploymentConfig.addPropertyValue("classNames", classNames);
            this.configBuilder.addPropertyValue("userCodeDeploymentConfig", (Object)userCodeDeploymentConfig.getBeanDefinition());
        }

        private void handleNetwork(Node node) {
            BeanDefinitionBuilder clientNetworkConfig = this.createBeanBuilder(ClientNetworkConfig.class);
            ArrayList<String> members = new ArrayList<String>(10);
            this.fillAttributeValues(node, clientNetworkConfig, new String[0]);
            for (Node child : DomConfigHelper.childElements(node)) {
                String nodeName = DomConfigHelper.cleanNodeName(child);
                if ("member".equals(nodeName)) {
                    members.add(this.getTextContent(child));
                    continue;
                }
                if ("socket-options".equals(nodeName)) {
                    this.createAndFillBeanBuilder(child, SocketOptions.class, "socketOptions", clientNetworkConfig, new String[0]);
                    continue;
                }
                if ("socket-interceptor".equals(nodeName)) {
                    this.handleSocketInterceptorConfig(child, clientNetworkConfig);
                    continue;
                }
                if ("ssl".equals(nodeName)) {
                    this.handleSSLConfig(child, clientNetworkConfig);
                    continue;
                }
                if (AliasedDiscoveryConfigUtils.supports(nodeName)) {
                    this.handleAliasedDiscoveryStrategy(child, clientNetworkConfig, nodeName);
                    continue;
                }
                if ("discovery-strategies".equals(nodeName)) {
                    this.handleDiscoveryStrategies(child, clientNetworkConfig);
                    continue;
                }
                if ("outbound-ports".equals(nodeName)) {
                    this.handleOutboundPorts(child, clientNetworkConfig);
                    continue;
                }
                if ("icmp-ping".equals(nodeName)) {
                    this.createAndFillBeanBuilder(child, ClientIcmpPingConfig.class, "clientIcmpPingConfig", clientNetworkConfig, new String[0]);
                    continue;
                }
                if (!"hazelcast-cloud".equals(nodeName)) continue;
                this.createAndFillBeanBuilder(child, ClientCloudConfig.class, "cloudConfig", clientNetworkConfig, new String[0]);
            }
            clientNetworkConfig.addPropertyValue("addresses", members);
            this.configBuilder.addPropertyValue("networkConfig", (Object)clientNetworkConfig.getBeanDefinition());
        }

        private void handleAliasedDiscoveryStrategy(Node node, BeanDefinitionBuilder builder, String name) {
            AliasedDiscoveryConfig config = AliasedDiscoveryConfigUtils.newConfigFor(name);
            this.fillAttributesForAliasedDiscoveryStrategy(config, node, builder, name);
        }

        private void handleSSLConfig(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            String implementation;
            BeanDefinitionBuilder sslConfigBuilder = this.createBeanBuilder(SSLConfig.class);
            String implAttribute = "factory-implementation";
            this.fillAttributeValues(node, sslConfigBuilder, implAttribute);
            Node implNode = node.getAttributes().getNamedItem(implAttribute);
            String string = implementation = implNode != null ? this.getTextContent(implNode) : null;
            if (implementation != null) {
                sslConfigBuilder.addPropertyReference(this.xmlToJavaName(implAttribute), implementation);
            }
            for (Node child : DomConfigHelper.childElements(node)) {
                String name = DomConfigHelper.cleanNodeName(child);
                if (!"properties".equals(name)) continue;
                this.handleProperties(child, sslConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("SSLConfig", (Object)sslConfigBuilder.getBeanDefinition());
        }

        private void handleLoadBalancer(Node node) {
            String type = this.getAttribute(node, "type");
            if ("random".equals(type)) {
                this.configBuilder.addPropertyValue("loadBalancer", (Object)new RandomLB());
            } else if ("round-robin".equals(type)) {
                this.configBuilder.addPropertyValue("loadBalancer", (Object)new RoundRobinLB());
            } else if ("custom".equals(type)) {
                NamedNodeMap attributes = node.getAttributes();
                Node classNameNode = attributes.getNamedItem("class-name");
                String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
                Node implNode = attributes.getNamedItem("implementation");
                String implementation = implNode != null ? this.getTextContent(implNode) : null;
                Assert.isTrue((boolean)(className != null ^ implementation != null), (String)"Exactly one of 'class-name' or 'implementation' attributes is required to create LoadBalancer!");
                if (className != null) {
                    BeanDefinitionBuilder loadBalancerBeanDefinition = this.createBeanBuilder(className);
                    this.configBuilder.addPropertyValue("loadBalancer", (Object)loadBalancerBeanDefinition.getBeanDefinition());
                } else {
                    this.configBuilder.addPropertyReference("loadBalancer", implementation);
                }
            }
        }

        private void handleNearCache(Node node) {
            BeanDefinitionBuilder nearCacheConfigBuilder = this.createBeanBuilder(NearCacheConfig.class);
            this.fillAttributeValues(node, nearCacheConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements(node)) {
                String nodeName = DomConfigHelper.cleanNodeName(childNode);
                if ("eviction".equals(nodeName)) {
                    this.handleEvictionConfig(childNode, nearCacheConfigBuilder, true);
                    continue;
                }
                if (!"preloader".equals(nodeName)) continue;
                this.handlePreloaderConfig(childNode, nearCacheConfigBuilder);
            }
            String name = this.getAttribute(node, "name");
            this.nearCacheConfigMap.put((Object)name, (Object)nearCacheConfigBuilder.getBeanDefinition());
        }

        private void handleFlakeIdGenerator(Node node) {
            BeanDefinitionBuilder configBuilder = this.createBeanBuilder(ClientFlakeIdGeneratorConfig.class);
            this.fillAttributeValues(node, configBuilder, new String[0]);
            String name = this.getAttribute(node, "name");
            this.flakeIdGeneratorConfigMap.put((Object)name, (Object)configBuilder.getBeanDefinition());
        }

        private void handleReliableTopic(Node node) {
            BeanDefinitionBuilder configBuilder = this.createBeanBuilder(ClientReliableTopicConfig.class);
            String name = this.getAttribute(node, "name");
            this.fillValues(node, configBuilder, new String[0]);
            this.reliableTopicConfigMap.put((Object)name, (Object)configBuilder.getBeanDefinition());
        }

        private void handleEvictionConfig(Node node, BeanDefinitionBuilder configBuilder, boolean isNearCache) {
            configBuilder.addPropertyValue("evictionConfig", (Object)this.getEvictionConfig(node, isNearCache, false));
        }

        private void handlePreloaderConfig(Node node, BeanDefinitionBuilder configBuilder) {
            configBuilder.addPropertyValue("preloaderConfig", (Object)this.getPreloaderConfig(node));
        }

        private ManagedMap getQueryCaches(Node childNode) {
            ManagedMap queryCaches = new ManagedMap();
            for (Node queryCacheNode : DomConfigHelper.childElements(childNode)) {
                this.parseQueryCache((ManagedMap<String, ManagedMap<String, BeanDefinition>>)queryCaches, queryCacheNode);
            }
            return queryCaches;
        }

        private void parseQueryCache(ManagedMap<String, ManagedMap<String, BeanDefinition>> queryCaches, Node queryCacheNode) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(QueryCacheConfig.class);
            NamedNodeMap attributes = queryCacheNode.getAttributes();
            String mapName = this.getTextContent(attributes.getNamedItem("map-name"));
            String cacheName = this.getTextContent(attributes.getNamedItem("name"));
            for (Node node : DomConfigHelper.childElements(queryCacheNode)) {
                String nodeName = DomConfigHelper.cleanNodeName(node);
                String textContent = this.getTextContent(node);
                this.parseQueryCacheInternal(builder, node, nodeName, textContent);
            }
            builder.addPropertyValue("name", (Object)cacheName);
            ManagedMap configMap = (ManagedMap)queryCaches.get((Object)mapName);
            if (configMap == null) {
                configMap = new ManagedMap();
                queryCaches.put((Object)mapName, (Object)configMap);
            }
            configMap.put((Object)cacheName, (Object)builder.getBeanDefinition());
        }

        private void parseQueryCacheInternal(BeanDefinitionBuilder builder, Node node, String nodeName, String textContent) {
            if ("predicate".equals(nodeName)) {
                BeanDefinitionBuilder predicateBuilder = this.getPredicate(node, textContent);
                builder.addPropertyValue("predicateConfig", (Object)predicateBuilder.getBeanDefinition());
            } else if ("entry-listeners".equals(nodeName)) {
                ManagedList<BeanDefinition> listeners = this.getEntryListeners(node);
                builder.addPropertyValue("entryListenerConfigs", listeners);
            } else if ("include-value".equals(nodeName)) {
                boolean includeValue = DomConfigHelper.getBooleanValue(textContent);
                builder.addPropertyValue("includeValue", (Object)includeValue);
            } else if ("batch-size".equals(nodeName)) {
                int batchSize = DomConfigHelper.getIntegerValue("batch-size", textContent.trim());
                builder.addPropertyValue("batchSize", (Object)batchSize);
            } else if ("buffer-size".equals(nodeName)) {
                int bufferSize = DomConfigHelper.getIntegerValue("buffer-size", textContent.trim());
                builder.addPropertyValue("bufferSize", (Object)bufferSize);
            } else if ("delay-seconds".equals(nodeName)) {
                int delaySeconds = DomConfigHelper.getIntegerValue("delay-seconds", textContent.trim());
                builder.addPropertyValue("delaySeconds", (Object)delaySeconds);
            } else if ("in-memory-format".equals(nodeName)) {
                String value = textContent.trim();
                builder.addPropertyValue("inMemoryFormat", (Object)InMemoryFormat.valueOf(StringUtil.upperCaseInternal(value)));
            } else if ("coalesce".equals(nodeName)) {
                boolean coalesce = DomConfigHelper.getBooleanValue(textContent);
                builder.addPropertyValue("coalesce", (Object)coalesce);
            } else if ("populate".equals(nodeName)) {
                boolean populate = DomConfigHelper.getBooleanValue(textContent);
                builder.addPropertyValue("populate", (Object)populate);
            } else if ("indexes".equals(nodeName)) {
                ManagedList<BeanDefinition> indexes = this.getIndexes(node);
                builder.addPropertyValue("indexConfigs", indexes);
            } else if ("eviction".equals(nodeName)) {
                builder.addPropertyValue("evictionConfig", (Object)this.getEvictionConfig(node, false, false));
            }
        }

        private BeanDefinitionBuilder getPredicate(Node node, String textContent) {
            BeanDefinitionBuilder predicateBuilder = this.createBeanBuilder(PredicateConfig.class);
            String predicateType = this.getTextContent(node.getAttributes().getNamedItem("type"));
            if ("sql".equals(predicateType)) {
                predicateBuilder.addPropertyValue("sql", (Object)textContent);
            } else if ("class-name".equals(predicateType)) {
                predicateBuilder.addPropertyValue("className", (Object)textContent);
            }
            return predicateBuilder;
        }

        private ManagedList<BeanDefinition> getIndexes(Node node) {
            ManagedList indexes = new ManagedList();
            for (Node indexNode : DomConfigHelper.childElements(node)) {
                this.handleIndex((ManagedList<BeanDefinition>)indexes, indexNode);
            }
            return indexes;
        }

        private ManagedList<BeanDefinition> getEntryListeners(Node node) {
            ManagedList listeners = new ManagedList();
            String implementationAttr = "implementation";
            for (Node listenerNode : DomConfigHelper.childElements(node)) {
                BeanDefinitionBuilder listenerConfBuilder = this.createBeanBuilder(EntryListenerConfig.class);
                this.fillAttributeValues(listenerNode, listenerConfBuilder, implementationAttr);
                Node implementationNode = listenerNode.getAttributes().getNamedItem(implementationAttr);
                if (implementationNode != null) {
                    listenerConfBuilder.addPropertyReference(implementationAttr, this.getTextContent(implementationNode));
                }
                listeners.add((Object)listenerConfBuilder.getBeanDefinition());
            }
            return listeners;
        }

        private void handleOutboundPorts(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            ManagedList outboundPorts = new ManagedList();
            for (Node child : DomConfigHelper.childElements(node)) {
                String name = DomConfigHelper.cleanNodeName(child);
                if (!"ports".equals(name)) continue;
                String value = this.getTextContent(child);
                outboundPorts.add((Object)value);
            }
            networkConfigBuilder.addPropertyValue("outboundPortDefinitions", (Object)outboundPorts);
        }

        private void handleLabels(Node node) {
            ManagedList labels = new ManagedList();
            for (Node n : DomConfigHelper.childElements(node)) {
                String name = DomConfigHelper.cleanNodeName(n);
                if (!"label".equals(name)) continue;
                String label = this.getTextContent(n);
                labels.add((Object)label);
            }
            this.configBuilder.addPropertyValue("labels", (Object)labels);
        }

        private void handleMetrics(Node node) {
            BeanDefinitionBuilder metricsConfigBuilder = this.createBeanBuilder(ClientMetricsConfig.class);
            this.fillValues(node, metricsConfigBuilder, "jmx");
            Node attrEnabled = node.getAttributes().getNamedItem("enabled");
            boolean enabled = attrEnabled != null && DomConfigHelper.getBooleanValue(this.getTextContent(attrEnabled));
            metricsConfigBuilder.addPropertyValue("enabled", (Object)enabled);
            for (Node child : DomConfigHelper.childElements(node)) {
                String nodeName = DomConfigHelper.cleanNodeName(child);
                if (!"jmx".equals(nodeName)) continue;
                BeanDefinitionBuilder metricsJmxConfigBuilder = this.createBeanBuilder(MetricsJmxConfig.class);
                this.fillValues(child, metricsJmxConfigBuilder, new String[0]);
                metricsConfigBuilder.addPropertyValue("jmxConfig", (Object)metricsJmxConfigBuilder.getBeanDefinition());
            }
            this.configBuilder.addPropertyValue("metricsConfig", (Object)metricsConfigBuilder.getBeanDefinition());
        }
    }
}

