/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.tx;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.map.impl.operation.LockAwareOperation;
import com.hazelcast.map.impl.tx.VersionedValue;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.transaction.TransactionException;
import java.io.IOException;
import java.util.UUID;

public class TxnLockAndGetOperation
extends LockAwareOperation
implements MutatingOperation {
    private long ttl;
    private boolean shouldLoad;
    private boolean blockReads;
    private UUID ownerUuid;
    private VersionedValue response;

    public TxnLockAndGetOperation() {
    }

    public TxnLockAndGetOperation(String name, Data dataKey, long timeout, long ttl, UUID ownerUuid, boolean shouldLoad, boolean blockReads) {
        super(name, dataKey);
        this.ownerUuid = ownerUuid;
        this.shouldLoad = shouldLoad;
        this.blockReads = blockReads;
        this.ttl = ttl;
        this.setWaitTimeout(timeout);
    }

    @Override
    protected void runInternal() {
        if (!this.recordStore.txnLock(this.getKey(), this.ownerUuid, this.getThreadId(), this.getCallId(), this.ttl, this.blockReads)) {
            throw new TransactionException("Transaction couldn't obtain lock.");
        }
        Object record = this.recordStore.getRecordOrNull(this.dataKey);
        if (record == null && this.shouldLoad) {
            record = this.recordStore.loadRecordOrNull(this.dataKey, false, this.getCallerAddress());
        }
        Data value = record == null ? null : this.mapServiceContext.toData(record.getValue());
        this.response = new VersionedValue(value, record == null ? 0L : record.getVersion());
    }

    @Override
    public boolean shouldWait() {
        return !this.recordStore.canAcquireLock(this.dataKey, this.ownerUuid, this.getThreadId());
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(null);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        UUIDSerializationUtil.writeUUID(out, this.ownerUuid);
        out.writeBoolean(this.shouldLoad);
        out.writeBoolean(this.blockReads);
        out.writeLong(this.ttl);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.ownerUuid = UUIDSerializationUtil.readUUID(in);
        this.shouldLoad = in.readBoolean();
        this.blockReads = in.readBoolean();
        this.ttl = in.readLong();
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", thread=").append(this.getThreadId());
    }

    @Override
    public int getClassId() {
        return 63;
    }
}

