/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.NamedConfig;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class DurableExecutorConfig
implements IdentifiedDataSerializable,
NamedConfig {
    public static final int DEFAULT_POOL_SIZE = 16;
    public static final int DEFAULT_RING_BUFFER_CAPACITY = 100;
    public static final int DEFAULT_DURABILITY = 1;
    private String name = "default";
    private int poolSize = 16;
    private int durability = 1;
    private int capacity = 100;
    private String splitBrainProtectionName;

    public DurableExecutorConfig() {
    }

    public DurableExecutorConfig(String name) {
        this.name = name;
    }

    public DurableExecutorConfig(String name, int poolSize, int durability, int capacity) {
        this(name, poolSize, durability, capacity, null);
    }

    public DurableExecutorConfig(String name, int poolSize, int durability, int capacity, String splitBrainProtectionName) {
        this.name = name;
        this.poolSize = poolSize;
        this.durability = durability;
        this.capacity = capacity;
        this.splitBrainProtectionName = splitBrainProtectionName;
    }

    public DurableExecutorConfig(DurableExecutorConfig config) {
        this(config.getName(), config.getPoolSize(), config.getDurability(), config.getCapacity(), config.getSplitBrainProtectionName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DurableExecutorConfig setName(String name) {
        this.name = name;
        return this;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public DurableExecutorConfig setPoolSize(int poolSize) {
        this.poolSize = Preconditions.checkPositive(poolSize, "Pool size should be greater than 0");
        return this;
    }

    public int getDurability() {
        return this.durability;
    }

    public DurableExecutorConfig setDurability(int durability) {
        this.durability = Preconditions.checkNotNegative(durability, "durability can't be smaller than 0");
        return this;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public DurableExecutorConfig setCapacity(int capacity) {
        this.capacity = Preconditions.checkPositive(capacity, "Capacity should be greater than 0");
        return this;
    }

    public String getSplitBrainProtectionName() {
        return this.splitBrainProtectionName;
    }

    public DurableExecutorConfig setSplitBrainProtectionName(String splitBrainProtectionName) {
        this.splitBrainProtectionName = splitBrainProtectionName;
        return this;
    }

    public String toString() {
        return "ExecutorConfig{name='" + this.name + '\'' + ", poolSize=" + this.poolSize + ", capacity=" + this.capacity + ", splitBrainProtectionName=" + this.splitBrainProtectionName + '}';
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 31;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.poolSize);
        out.writeInt(this.durability);
        out.writeInt(this.capacity);
        out.writeUTF(this.splitBrainProtectionName);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.poolSize = in.readInt();
        this.durability = in.readInt();
        this.capacity = in.readInt();
        this.splitBrainProtectionName = in.readUTF();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DurableExecutorConfig)) {
            return false;
        }
        DurableExecutorConfig that = (DurableExecutorConfig)o;
        if (this.poolSize != that.poolSize) {
            return false;
        }
        if (this.durability != that.durability) {
            return false;
        }
        if (this.capacity != that.capacity) {
            return false;
        }
        if (this.splitBrainProtectionName != null ? !this.splitBrainProtectionName.equals(that.splitBrainProtectionName) : that.splitBrainProtectionName != null) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public final int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.poolSize;
        result = 31 * result + this.durability;
        result = 31 * result + this.capacity;
        result = 31 * result + (this.splitBrainProtectionName != null ? this.splitBrainProtectionName.hashCode() : 0);
        return result;
    }
}

