/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.security.CredentialsIdentityConfig;
import com.hazelcast.config.security.IdentityConfig;
import com.hazelcast.config.security.TokenIdentityConfig;
import com.hazelcast.config.security.UsernamePasswordIdentityConfig;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.ICredentialsFactory;
import java.util.Objects;

public class ClientSecurityConfig {
    private IdentityConfig identityConfig;

    public ClientSecurityConfig() {
    }

    public ClientSecurityConfig(ClientSecurityConfig securityConfig) {
        this.identityConfig = securityConfig.identityConfig == null ? null : securityConfig.identityConfig.copy();
    }

    public UsernamePasswordIdentityConfig getUsernamePasswordIdentityConfig() {
        return this.getIfType(this.identityConfig, UsernamePasswordIdentityConfig.class);
    }

    public ClientSecurityConfig setUsernamePasswordIdentityConfig(UsernamePasswordIdentityConfig identityConfig) {
        this.identityConfig = identityConfig;
        return this;
    }

    public ClientSecurityConfig setUsernamePasswordIdentityConfig(String username, String password) {
        this.identityConfig = new UsernamePasswordIdentityConfig(username, password);
        return this;
    }

    public TokenIdentityConfig getTokenIdentityConfig() {
        return this.getIfType(this.identityConfig, TokenIdentityConfig.class);
    }

    public ClientSecurityConfig setTokenIdentityConfig(TokenIdentityConfig identityConfig) {
        this.identityConfig = identityConfig;
        return this;
    }

    public CredentialsIdentityConfig getCredentialsIdentityConfig() {
        return this.getIfType(this.identityConfig, CredentialsIdentityConfig.class);
    }

    public ClientSecurityConfig setCredentialsIdentityConfig(CredentialsIdentityConfig identity) {
        this.identityConfig = identity;
        return this;
    }

    public ClientSecurityConfig setCredentials(Credentials credentials) {
        this.identityConfig = new CredentialsIdentityConfig(credentials);
        return this;
    }

    public CredentialsFactoryConfig getCredentialsFactoryConfig() {
        return this.getIfType(this.identityConfig, CredentialsFactoryConfig.class);
    }

    public ClientSecurityConfig setCredentialsFactoryConfig(CredentialsFactoryConfig identityConfig) {
        this.identityConfig = identityConfig;
        return this;
    }

    public ICredentialsFactory asCredentialsFactory(ClassLoader cl) {
        return this.identityConfig != null ? this.identityConfig.asCredentialsFactory(cl) : null;
    }

    public boolean hasIdentityConfig() {
        return this.identityConfig != null;
    }

    public String toString() {
        return "ClientSecurityConfig{identityConfig=" + this.identityConfig + '}';
    }

    public int hashCode() {
        return Objects.hash(this.identityConfig);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientSecurityConfig other = (ClientSecurityConfig)obj;
        return Objects.equals(this.identityConfig, other.identityConfig);
    }

    private <T> T getIfType(Object inst, Class<T> clazz) {
        return clazz.isInstance(inst) ? (T)clazz.cast(inst) : null;
    }
}

