/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.sequence;

import com.hazelcast.internal.util.ConcurrencyDetection;
import com.hazelcast.spi.impl.sequence.CallIdSequence;
import com.hazelcast.spi.impl.sequence.CallIdSequenceWithBackpressure;
import com.hazelcast.spi.impl.sequence.CallIdSequenceWithoutBackpressure;
import com.hazelcast.spi.impl.sequence.FailFastCallIdSequence;

public final class CallIdFactory {
    private CallIdFactory() {
    }

    public static CallIdSequence newCallIdSequence(int maxConcurrentInvocations, long backoffTimeoutMs, ConcurrencyDetection concurrencyDetection) {
        if (concurrencyDetection.enabled()) {
            if (backoffTimeoutMs > 0L) {
                return new CallIdSequenceWithBackpressure(maxConcurrentInvocations, backoffTimeoutMs, concurrencyDetection);
            }
            return new FailFastCallIdSequence(maxConcurrentInvocations, concurrencyDetection);
        }
        return new CallIdSequenceWithoutBackpressure();
    }
}

