/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.eventservice.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import com.hazelcast.spi.impl.eventservice.EventFilter;
import com.hazelcast.spi.impl.eventservice.EventRegistration;
import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nonnull;

public class Registration
implements EventRegistration {
    private UUID id;
    private String serviceName;
    private String topic;
    private EventFilter filter;
    private Address subscriber;
    private transient boolean localOnly;
    private transient Object listener;

    public Registration() {
    }

    public Registration(@Nonnull UUID id, String serviceName, String topic, EventFilter filter, Address subscriber, Object listener, boolean localOnly) {
        this.id = Preconditions.checkNotNull(id, "Registration ID cannot be null!");
        this.filter = filter;
        this.listener = listener;
        this.serviceName = serviceName;
        this.topic = topic;
        this.subscriber = subscriber;
        this.localOnly = localOnly;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getTopic() {
        return this.topic;
    }

    @Override
    public EventFilter getFilter() {
        return this.filter;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Address getSubscriber() {
        return this.subscriber;
    }

    @Override
    public boolean isLocalOnly() {
        return this.localOnly;
    }

    public Object getListener() {
        return this.listener;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Registration)) {
            return false;
        }
        Registration that = (Registration)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        UUIDSerializationUtil.writeUUID(out, this.id);
        out.writeUTF(this.serviceName);
        out.writeUTF(this.topic);
        out.writeObject(this.subscriber);
        out.writeObject(this.filter);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.id = UUIDSerializationUtil.readUUID(in);
        this.serviceName = in.readUTF();
        this.topic = in.readUTF();
        this.subscriber = (Address)in.readObject();
        this.filter = (EventFilter)in.readObject();
    }

    public String toString() {
        return "Registration{filter=" + this.filter + ", id='" + this.id + '\'' + ", serviceName='" + this.serviceName + '\'' + ", subscriber=" + this.subscriber + ", listener=" + this.listener + '}';
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 21;
    }
}

