/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.management.ClientBwListConfigHandler;
import com.hazelcast.internal.management.ConsoleCommandHandler;
import com.hazelcast.internal.management.ManagementCenterEventListener;
import com.hazelcast.internal.management.TimedMemberState;
import com.hazelcast.internal.management.TimedMemberStateFactory;
import com.hazelcast.internal.management.dto.ClientBwListDTO;
import com.hazelcast.internal.management.events.Event;
import com.hazelcast.internal.util.executor.ExecutorType;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.properties.ClusterProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;

public class ManagementCenterService {
    public static final String SERVICE_NAME = "hz:core:managementCenterService";
    private static final int MIN_EVENT_QUEUE_CAPACITY = 1000;
    private static final int EXECUTOR_QUEUE_CAPACITY_PER_THREAD = 1000;
    private static final long TMS_CACHE_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private static final long MC_EVENTS_WINDOW_NANOS = TimeUnit.SECONDS.toNanos(30L);
    private final HazelcastInstanceImpl instance;
    private final ILogger logger;
    private final AtomicReference<String> tmsJson = new AtomicReference();
    private final TimedMemberStateFactory tmsFactory;
    private final AtomicBoolean tmsFactoryInitialized = new AtomicBoolean(false);
    private final BlockingQueue<Event> mcEvents;
    private final ConsoleCommandHandler commandHandler;
    private final ClientBwListConfigHandler bwListConfigHandler;
    private volatile ManagementCenterEventListener eventListener;
    private volatile String lastMCConfigETag;
    private volatile long lastTMSUpdateNanos;
    private volatile long lastMCEventsPollNanos = System.nanoTime();

    public ManagementCenterService(HazelcastInstanceImpl instance) {
        this.instance = instance;
        this.logger = instance.node.getLogger(ManagementCenterService.class);
        this.tmsFactory = instance.node.getNodeExtension().createTimedMemberStateFactory(instance);
        int partitionCount = instance.node.getPartitionService().getPartitionCount();
        this.mcEvents = new LinkedBlockingQueue<Event>(Math.max(1000, partitionCount));
        this.commandHandler = new ConsoleCommandHandler(instance);
        this.bwListConfigHandler = new ClientBwListConfigHandler(instance.node.clientEngine);
        this.registerExecutor();
    }

    private void registerExecutor() {
        ExecutionService executionService = this.instance.node.nodeEngine.getExecutionService();
        int threadCount = this.instance.node.getProperties().getInteger(ClusterProperty.MC_EXECUTOR_THREAD_COUNT);
        this.logger.finest("Creating new executor for Management Center service tasks with threadCount=" + threadCount);
        executionService.register("hz:mc", threadCount, threadCount * 1000, ExecutorType.CACHED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Optional<String> getTimedMemberStateJson() {
        if (this.tmsFactoryInitialized.compareAndSet(false, true)) {
            this.tmsFactory.init();
        }
        if (System.nanoTime() - this.lastTMSUpdateNanos <= TMS_CACHE_TIMEOUT_NANOS) {
            return Optional.ofNullable(this.tmsJson.get());
        }
        try {
            TimedMemberState tms;
            TimedMemberStateFactory timedMemberStateFactory = this.tmsFactory;
            synchronized (timedMemberStateFactory) {
                tms = this.tmsFactory.createTimedMemberState();
                this.lastTMSUpdateNanos = System.nanoTime();
            }
            JsonObject json = new JsonObject();
            json.add("timedMemberState", tms.toJson());
            this.tmsJson.set(json.toString());
        }
        catch (Throwable e) {
            if (e instanceof RetryableException) {
                this.logger.warning("Failed to create TimedMemberState. Will try again on next request from Management Center.");
            }
            OutOfMemoryErrorDispatcher.inspectOutOfMemoryError(e);
        }
        return Optional.ofNullable(this.tmsJson.get());
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void log(Event event) {
        if (System.nanoTime() - this.lastMCEventsPollNanos > MC_EVENTS_WINDOW_NANOS) {
            this.onMCEventWindowExceeded();
        } else {
            this.mcEvents.offer(event);
        }
        if (this.eventListener != null) {
            this.eventListener.onEventLogged(event);
        }
    }

    void onMCEventWindowExceeded() {
        this.mcEvents.clear();
    }

    public void setEventListener(ManagementCenterEventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Nonnull
    public List<Event> pollMCEvents() {
        ArrayList<Event> polled = new ArrayList<Event>();
        this.mcEvents.drainTo(polled);
        this.lastMCEventsPollNanos = System.nanoTime();
        return polled;
    }

    public String runConsoleCommand(String command) throws InterruptedException {
        return this.commandHandler.handleCommand(command);
    }

    public String getLastMCConfigETag() {
        return this.lastMCConfigETag;
    }

    public void applyMCConfig(String eTag, ClientBwListDTO bwListConfig) {
        if (eTag.equals(this.lastMCConfigETag)) {
            this.logger.warning("Client B/W list filtering config with the same ETag is already applied.");
            return;
        }
        try {
            this.bwListConfigHandler.applyConfig(bwListConfig);
            this.lastMCConfigETag = eTag;
        }
        catch (Exception e) {
            this.logger.warning("Could not apply client B/W list filtering config.", e);
            throw new HazelcastException("Error while applying MC config", e);
        }
    }
}

