/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.internal.nio.Bits;
import java.util.concurrent.TimeUnit;

public final class StringCodec {
    private StringCodec() {
    }

    public static void encode(ClientMessage clientMessage, String value) {
        clientMessage.add(new ClientMessage.Frame(value.getBytes(Bits.UTF_8)));
    }

    public static void encode(ClientMessage clientMessage, TimeUnit timeUnit) {
        StringCodec.encode(clientMessage, timeUnit.name());
    }

    public static void encode(ClientMessage clientMessage, CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType expiryPolicyType) {
        StringCodec.encode(clientMessage, expiryPolicyType.name());
    }

    public static String decode(ClientMessage.ForwardFrameIterator iterator) {
        return StringCodec.decode(iterator.next());
    }

    public static String decode(ClientMessage.Frame frame) {
        return new String(frame.content, Bits.UTF_8);
    }
}

