/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class EntryListUUIDUUIDCodec {
    private static final int ENTRY_SIZE_IN_BYTES = 34;

    private EntryListUUIDUUIDCodec() {
    }

    public static void encode(ClientMessage clientMessage, Collection<Map.Entry<UUID, UUID>> collection) {
        int itemCount = collection.size();
        ClientMessage.Frame frame = new ClientMessage.Frame(new byte[itemCount * 34]);
        Iterator<Map.Entry<UUID, UUID>> iterator = collection.iterator();
        for (int i = 0; i < itemCount; ++i) {
            Map.Entry<UUID, UUID> entry = iterator.next();
            FixedSizeTypesCodec.encodeUUID(frame.content, i * 34, entry.getKey());
            FixedSizeTypesCodec.encodeUUID(frame.content, i * 34 + 17, entry.getValue());
        }
        clientMessage.add(frame);
    }

    public static List<Map.Entry<UUID, UUID>> decode(ClientMessage.ForwardFrameIterator iterator) {
        ClientMessage.Frame frame = iterator.next();
        int itemCount = frame.content.length / 34;
        LinkedList<Map.Entry<UUID, UUID>> result = new LinkedList<Map.Entry<UUID, UUID>>();
        for (int i = 0; i < itemCount; ++i) {
            UUID key = FixedSizeTypesCodec.decodeUUID(frame.content, i * 34);
            UUID value = FixedSizeTypesCodec.decodeUUID(frame.content, i * 34 + 17);
            result.add(new AbstractMap.SimpleEntry<UUID, UUID>(key, value));
        }
        return result;
    }
}

