/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.config.ConfigLoader;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.StringUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;

public final class WebFilterConfig {
    private static final ILogger LOGGER = Logger.getLogger(WebFilterConfig.class);
    private static final int SESSION_TTL_DEFAULT_SECONDS = 1800;
    private static final String CLIENT_CONFIG_LOCATION = "client-config-location";
    private static final String SESSION_TTL_CONFIG = "session-ttl-seconds";
    private static final String USE_CLIENT = "use-client";
    private static final String INSTANCE_NAME = "instance-name";
    private static final String MAP_NAME = "map-name";
    private static final String STICKY_SESSION_CONFIG = "sticky-session";
    private static final String CONFIG_LOCATION = "config-location";
    private static final String SHUTDOWN_ON_DESTROY = "shutdown-on-destroy";
    private static final String DEFERRED_WRITE = "deferred-write";
    private static final String USE_REQUEST_PARAMETER = "use-request-parameter";
    private static final String TRANSIENT_ATTRIBUTES = "transient-attributes";
    private static final String COOKIE_NAME = "cookie-name";
    private static final String COOKIE_DOMAIN = "cookie-domain";
    private static final String COOKIE_SECURE = "cookie-secure";
    private static final String COOKIE_HTTP_ONLY = "cookie-http-only";
    private static final String COOKIE_PATH = "cookie-path";
    private static final String COOKIE_MAX_AGE = "cookie-max-age";
    private boolean useClient;
    private URL configUrl;
    private int sessionTtlSeconds;
    private String instanceName;
    private String mapName;
    private boolean stickySession;
    private boolean shutdownOnDestroy;
    private boolean deferredWrite;
    private boolean useRequestParameter;
    private Set<String> transientAttributes;
    private String cookieName;
    private String cookieDomain;
    private boolean cookieSecure;
    private boolean cookieHttpOnly;
    private String cookiePath;
    private int cookieMaxAge;

    private WebFilterConfig() {
    }

    public static WebFilterConfig create(FilterConfig filterConfig, Properties properties) {
        boolean useClient = WebFilterConfig.getBoolean(filterConfig, properties, USE_CLIENT, false);
        WebFilterConfig.validateHazelcastConfigParameters(filterConfig, properties, useClient);
        String clientConfigLocation = WebFilterConfig.getString(filterConfig, properties, CLIENT_CONFIG_LOCATION, null);
        int sessionTtlSeconds = WebFilterConfig.getInt(filterConfig, properties, SESSION_TTL_CONFIG, 1800);
        String configLocation = WebFilterConfig.getString(filterConfig, properties, CONFIG_LOCATION, null);
        URL configUrl = WebFilterConfig.validateAndGetConfigUrl(filterConfig.getServletContext(), useClient, configLocation, clientConfigLocation);
        String instanceName = WebFilterConfig.getString(filterConfig, properties, INSTANCE_NAME, null);
        String mapName = WebFilterConfig.getString(filterConfig, properties, MAP_NAME, "_web_" + filterConfig.getServletContext().getServletContextName());
        boolean stickySession = WebFilterConfig.getBoolean(filterConfig, properties, STICKY_SESSION_CONFIG, true);
        boolean shutdownOnDestroy = WebFilterConfig.getBoolean(filterConfig, properties, SHUTDOWN_ON_DESTROY, true);
        boolean deferredWrite = WebFilterConfig.getBoolean(filterConfig, properties, DEFERRED_WRITE, false);
        boolean useRequestParameter = WebFilterConfig.getBoolean(filterConfig, properties, USE_REQUEST_PARAMETER, false);
        Set<String> transientAttributes = WebFilterConfig.getStringSet(filterConfig, properties, TRANSIENT_ATTRIBUTES);
        String cookieName = WebFilterConfig.getString(filterConfig, properties, COOKIE_NAME, "hazelcast.sessionId");
        String cookieDomain = WebFilterConfig.getString(filterConfig, properties, COOKIE_DOMAIN, null);
        boolean cookieSecure = WebFilterConfig.getBoolean(filterConfig, properties, COOKIE_SECURE, false);
        boolean cookieHttpOnly = WebFilterConfig.getBoolean(filterConfig, properties, COOKIE_HTTP_ONLY, false);
        String cookiePath = WebFilterConfig.getString(filterConfig, properties, COOKIE_PATH, null);
        int cookieMaxAge = WebFilterConfig.getInt(filterConfig, properties, COOKIE_MAX_AGE, -1);
        WebFilterConfig wfc = new WebFilterConfig();
        wfc.useClient = useClient;
        wfc.configUrl = configUrl;
        wfc.sessionTtlSeconds = sessionTtlSeconds;
        wfc.instanceName = instanceName;
        wfc.mapName = mapName;
        wfc.stickySession = stickySession;
        wfc.shutdownOnDestroy = shutdownOnDestroy;
        wfc.deferredWrite = deferredWrite;
        wfc.useRequestParameter = useRequestParameter;
        wfc.transientAttributes = transientAttributes;
        wfc.cookieName = cookieName;
        wfc.cookieDomain = cookieDomain;
        wfc.cookieSecure = cookieSecure;
        wfc.cookieHttpOnly = cookieHttpOnly;
        wfc.cookiePath = cookiePath;
        wfc.cookieMaxAge = cookieMaxAge;
        return wfc;
    }

    public boolean isUseClient() {
        return this.useClient;
    }

    public URL getConfigUrl() {
        return this.configUrl;
    }

    public int getSessionTtlSeconds() {
        return this.sessionTtlSeconds;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getMapName() {
        return this.mapName;
    }

    public boolean isStickySession() {
        return this.stickySession;
    }

    public boolean isShutdownOnDestroy() {
        return this.shutdownOnDestroy;
    }

    public boolean isDeferredWrite() {
        return this.deferredWrite;
    }

    public boolean isUseRequestParameter() {
        return this.useRequestParameter;
    }

    public Set<String> getTransientAttributes() {
        return this.transientAttributes;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public boolean isCookieSecure() {
        return this.cookieSecure;
    }

    public boolean isCookieHttpOnly() {
        return this.cookieHttpOnly;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public int getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    private static boolean getBoolean(FilterConfig filterConfig, Properties properties, String paramName, boolean defaultValue) {
        String value = WebFilterConfig.getValue(filterConfig, properties, paramName);
        if (StringUtil.isNullOrEmptyAfterTrim((String)value)) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    private static int getInt(FilterConfig filterConfig, Properties properties, String paramName, int defaultValue) {
        String value = WebFilterConfig.getValue(filterConfig, properties, paramName);
        if (StringUtil.isNullOrEmptyAfterTrim((String)value)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidConfigurationException(paramName + " needs to be an integer: (" + value + ")");
        }
    }

    private static String getString(FilterConfig filterConfig, Properties properties, String paramName, String defaultValue) {
        String value = WebFilterConfig.getValue(filterConfig, properties, paramName);
        if (StringUtil.isNullOrEmptyAfterTrim((String)value)) {
            return defaultValue;
        }
        return value;
    }

    private static Set<String> getStringSet(FilterConfig filterConfig, Properties properties, String paramName) {
        String value = WebFilterConfig.getValue(filterConfig, properties, paramName);
        if (StringUtil.isNullOrEmptyAfterTrim((String)value)) {
            return Collections.emptySet();
        }
        HashSet<String> transientAttributes = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            transientAttributes.add(token.trim());
        }
        return transientAttributes;
    }

    private static URL getConfigUrl(ServletContext ctx, String configLocation) {
        URL configUrl = null;
        try {
            configUrl = ctx.getResource(configLocation);
        }
        catch (MalformedURLException ignore) {
            LOGGER.info("Ignored MalformedURLException");
        }
        if (configUrl == null) {
            configUrl = ConfigLoader.locateConfig((String)configLocation);
        }
        if (configUrl == null) {
            throw new InvalidConfigurationException("Could not load configuration '" + configLocation + "'");
        }
        return configUrl;
    }

    private static String getValue(FilterConfig filterConfig, Properties properties, String paramName) {
        if (properties != null && properties.containsKey(paramName)) {
            return properties.getProperty(paramName);
        }
        return filterConfig.getInitParameter(paramName);
    }

    private static URL validateAndGetConfigUrl(ServletContext ctx, boolean useClient, String configLocation, String clientConfigLocation) {
        if (!useClient && configLocation != null) {
            return WebFilterConfig.getConfigUrl(ctx, configLocation);
        }
        if (useClient && clientConfigLocation != null) {
            return WebFilterConfig.getConfigUrl(ctx, clientConfigLocation);
        }
        return null;
    }

    private static void validateHazelcastConfigParameters(FilterConfig filterConfig, Properties properties, boolean useClient) {
        List<String> wrongParams;
        if (WebFilterConfig.paramExists(filterConfig, properties, INSTANCE_NAME) && !(wrongParams = WebFilterConfig.parametersExist(filterConfig, properties, SESSION_TTL_CONFIG, CONFIG_LOCATION, CLIENT_CONFIG_LOCATION)).isEmpty()) {
            StringBuilder errorMsgBuilder = new StringBuilder("The following parameters cannot be used when instance-name is set to 'true' because an existing Hazelcast");
            if (useClient) {
                errorMsgBuilder.append("Client");
            }
            errorMsgBuilder.append(" instance is being used: [");
            for (int i = 0; i < wrongParams.size(); ++i) {
                errorMsgBuilder.append(wrongParams.get(i));
                if (i == wrongParams.size() - 1) continue;
                errorMsgBuilder.append(", ");
            }
            errorMsgBuilder.append("]");
            throw new InvalidConfigurationException(errorMsgBuilder.toString());
        }
        if (useClient) {
            wrongParams = WebFilterConfig.parametersExist(filterConfig, properties, SESSION_TTL_CONFIG, CONFIG_LOCATION);
            if (!wrongParams.isEmpty()) {
                StringBuilder errorMsgBuilder = new StringBuilder("The following parameters cannot be used when use-client is set to 'true': [");
                for (int i = 0; i < wrongParams.size(); ++i) {
                    errorMsgBuilder.append(wrongParams.get(i));
                    if (i == wrongParams.size() - 1) continue;
                    errorMsgBuilder.append(", ");
                }
                errorMsgBuilder.append("]");
                throw new InvalidConfigurationException(errorMsgBuilder.toString());
            }
        } else if (WebFilterConfig.paramExists(filterConfig, properties, CLIENT_CONFIG_LOCATION)) {
            throw new InvalidConfigurationException("client-config-location cannot be used with P2P mode.");
        }
    }

    private static List<String> parametersExist(FilterConfig filterConfig, Properties properties, String ... parameterNames) {
        ArrayList<String> parameters = new ArrayList<String>(parameterNames.length);
        for (String pName : parameterNames) {
            if (!WebFilterConfig.paramExists(filterConfig, properties, pName)) continue;
            parameters.add(pName);
        }
        return parameters;
    }

    private static boolean paramExists(FilterConfig filterConfig, Properties properties, String paramName) {
        return filterConfig != null && filterConfig.getInitParameter(paramName) != null || properties != null && properties.getProperty(paramName) != null;
    }
}

