/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.wan.impl;

import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.wan.MigrationAwareWanReplicationPublisher;
import com.hazelcast.wan.WanReplicationPublisher;
import com.hazelcast.wan.impl.WanDataSerializerHook;
import com.hazelcast.wan.impl.WanReplicationService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;

public class WanEventContainerReplicationOperation
extends Operation
implements IdentifiedDataSerializable {
    private Collection<WanReplicationConfig> wanConfigs;
    private Map<String, Map<String, Object>> eventContainers;

    public WanEventContainerReplicationOperation() {
    }

    public WanEventContainerReplicationOperation(@Nonnull Collection<WanReplicationConfig> wanConfigs, @Nonnull Map<String, Map<String, Object>> eventContainers, int partitionId, int replicaIndex) {
        Preconditions.checkNotNull(wanConfigs);
        Preconditions.checkNotNull(eventContainers);
        this.wanConfigs = wanConfigs;
        this.eventContainers = eventContainers;
        this.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
    }

    @Override
    public void run() throws Exception {
        WanReplicationService service = this.getWanReplicationService();
        int partitionId = this.getPartitionId();
        for (WanReplicationConfig wanConfig : this.wanConfigs) {
            service.appendWanReplicationConfig(wanConfig);
        }
        this.forAllReplicationContainers((publisher, o) -> {});
        this.forAllReplicationContainers((publisher, eventContainer) -> {
            if (publisher instanceof MigrationAwareWanReplicationPublisher) {
                ((MigrationAwareWanReplicationPublisher)((Object)publisher)).processEventContainerReplicationData(partitionId, eventContainer);
            }
        });
    }

    private void forAllReplicationContainers(BiConsumer<WanReplicationPublisher, Object> publisherContainerConsumer) {
        WanReplicationService service = this.getWanReplicationService();
        for (Map.Entry<String, Map<String, Object>> wanReplicationSchemeEntry : this.eventContainers.entrySet()) {
            String wanReplicationScheme = wanReplicationSchemeEntry.getKey();
            Map<String, Object> eventContainersByPublisherId = wanReplicationSchemeEntry.getValue();
            for (Map.Entry<String, Object> publisherEventContainer : eventContainersByPublisherId.entrySet()) {
                String publisherId = publisherEventContainer.getKey();
                Object eventContainer = publisherEventContainer.getValue();
                WanReplicationPublisher publisher = service.getPublisherOrFail(wanReplicationScheme, publisherId);
                publisherContainerConsumer.accept(publisher, eventContainer);
            }
        }
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.eventContainers.size());
        for (Map.Entry<String, Map<String, Object>> entry : this.eventContainers.entrySet()) {
            String wanReplicationScheme = entry.getKey();
            Map<String, Object> eventContainersByPublisherId = entry.getValue();
            out.writeUTF(wanReplicationScheme);
            out.writeInt(eventContainersByPublisherId.size());
            for (Map.Entry<String, Object> publisherEventContainer : eventContainersByPublisherId.entrySet()) {
                String publisherId = publisherEventContainer.getKey();
                Object eventContainer = publisherEventContainer.getValue();
                out.writeUTF(publisherId);
                out.writeObject(eventContainer);
            }
        }
        out.writeInt(this.wanConfigs.size());
        for (WanReplicationConfig wanConfig : this.wanConfigs) {
            out.writeObject(wanConfig);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int wanReplicationSchemeCount = in.readInt();
        this.eventContainers = MapUtil.createHashMap(wanReplicationSchemeCount);
        for (int i = 0; i < wanReplicationSchemeCount; ++i) {
            String wanReplicationScheme = in.readUTF();
            int publisherCount = in.readInt();
            Map eventContainersByPublisherId = MapUtil.createHashMap(publisherCount);
            for (int j = 0; j < publisherCount; ++j) {
                String publisherId = in.readUTF();
                Object eventContainer = in.readObject();
                eventContainersByPublisherId.put(publisherId, eventContainer);
            }
            this.eventContainers.put(wanReplicationScheme, eventContainersByPublisherId);
        }
        int wanConfigCount = in.readInt();
        this.wanConfigs = new ArrayList<WanReplicationConfig>(wanConfigCount);
        for (int i = 0; i < wanConfigCount; ++i) {
            this.wanConfigs.add((WanReplicationConfig)in.readObject());
        }
    }

    private WanReplicationService getWanReplicationService() {
        return this.getNodeEngine().getWanReplicationService();
    }
}

