/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.exception.CPSubsystemException;
import com.hazelcast.cp.internal.CPMemberInfo;
import com.hazelcast.cp.internal.MetadataRaftGroupManager;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.TargetNotMemberException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;

public class RaftInvocationContext {
    private static final CPMembersContainer INITIAL_VALUE = new CPMembersContainer(new CPMembersVersion(MetadataRaftGroupManager.INITIAL_METADATA_GROUP_ID.getSeed(), -1L), new CPMemberInfo[0]);
    private final ILogger logger;
    private final RaftService raftService;
    private final ConcurrentMap<CPGroupId, CPMember> knownLeaders = new ConcurrentHashMap<CPGroupId, CPMember>();
    private final boolean failOnIndeterminateOperationState;
    private AtomicReference<CPMembersContainer> membersContainer = new AtomicReference<CPMembersContainer>(INITIAL_VALUE);

    public RaftInvocationContext(ILogger logger, RaftService raftService) {
        this.logger = logger;
        this.raftService = raftService;
        this.failOnIndeterminateOperationState = raftService.getConfig().isFailOnIndeterminateOperationState();
    }

    public void reset() {
        this.membersContainer.set(INITIAL_VALUE);
        this.knownLeaders.clear();
    }

    public boolean setMembers(long groupIdSeed, long membersCommitIndex, Collection<? extends CPMember> members) {
        block2: {
            CPMembersContainer currentContainer;
            if (members.size() < 2) {
                return false;
            }
            CPMembersVersion version = new CPMembersVersion(groupIdSeed, membersCommitIndex);
            CPMembersContainer newContainer = new CPMembersContainer(version, members.toArray(new CPMember[0]));
            do {
                currentContainer = this.membersContainer.get();
                if (newContainer.version.compareTo(currentContainer.version) <= 0) break block2;
            } while (!this.membersContainer.compareAndSet(currentContainer, newContainer));
            this.logger.info("Replaced " + currentContainer + " with " + newContainer);
            return true;
        }
        return false;
    }

    public void updateMember(CPMember member) {
        CPMember existingMember;
        HashMap<UUID, CPMember> newMembers;
        CPMembersContainer newContainer;
        CPMembersContainer currentContainer;
        do {
            currentContainer = this.membersContainer.get();
            CPMember otherMember = null;
            for (CPMember m : currentContainer.members) {
                if (!m.getAddress().equals(member.getAddress()) || m.getUuid().equals(member.getUuid())) continue;
                otherMember = m;
                break;
            }
            existingMember = currentContainer.membersMap.get(member.getUuid());
            if (otherMember == null && existingMember != null && existingMember.getAddress().equals(member.getAddress())) {
                return;
            }
            newMembers = new HashMap<UUID, CPMember>(currentContainer.membersMap);
            newMembers.put(member.getUuid(), member);
            if (otherMember == null) continue;
            newMembers.remove(otherMember.getUuid());
        } while (!this.membersContainer.compareAndSet(currentContainer, newContainer = new CPMembersContainer(currentContainer.version, newMembers)));
        this.logger.info("Replaced " + existingMember + " with " + member);
    }

    int getCPGroupPartitionId(CPGroupId groupId) {
        return this.raftService.getCPGroupPartitionId(groupId);
    }

    public CPMember getCPMember(UUID memberUid) {
        return this.membersContainer.get().membersMap.get(memberUid);
    }

    CPMember getKnownLeader(CPGroupId groupId) {
        return (CPMember)this.knownLeaders.get(groupId);
    }

    boolean setKnownLeader(CPGroupId groupId, CPMember leader) {
        if (leader != null) {
            this.logger.fine("Setting known leader for raft: " + groupId + " to " + leader);
            this.knownLeaders.put(groupId, leader);
            return true;
        }
        return false;
    }

    void updateKnownLeaderOnFailure(CPGroupId groupId, Throwable cause) {
        if (cause instanceof CPSubsystemException) {
            CPSubsystemException e = (CPSubsystemException)cause;
            if (!this.setKnownLeader(groupId, this.getCPMember(e.getLeaderUuid()))) {
                this.resetKnownLeader(groupId);
            }
        } else if (cause instanceof TargetNotMemberException || cause instanceof MemberLeftException) {
            this.resetKnownLeader(groupId);
        }
    }

    boolean shouldFailOnIndeterminateOperationState() {
        return this.failOnIndeterminateOperationState;
    }

    private void resetKnownLeader(CPGroupId groupId) {
        this.logger.fine("Resetting known leader for raft: " + groupId);
        this.knownLeaders.remove(groupId);
    }

    MemberCursor newMemberCursor() {
        return new MemberCursor(this.membersContainer.get().members);
    }

    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
    private static class CPMembersVersion
    implements Comparable<CPMembersVersion> {
        private final long groupIdSeed;
        private final long version;

        CPMembersVersion(long groupIdSeed, long version) {
            this.groupIdSeed = groupIdSeed;
            this.version = version;
        }

        @Override
        public int compareTo(@Nonnull CPMembersVersion other) {
            if (this.groupIdSeed < other.groupIdSeed) {
                return -1;
            }
            if (this.groupIdSeed > other.groupIdSeed) {
                return 1;
            }
            return Long.compare(this.version, other.version);
        }

        public String toString() {
            return "CPMembersVersion{groupIdSeed=" + this.groupIdSeed + ", version=" + this.version + '}';
        }
    }

    private static class CPMembersContainer {
        final CPMembersVersion version;
        final CPMember[] members;
        final Map<UUID, CPMember> membersMap;

        CPMembersContainer(CPMembersVersion version, CPMember[] members) {
            this.version = version;
            this.members = members;
            this.membersMap = new HashMap<UUID, CPMember>(members.length);
            for (CPMember member : members) {
                this.membersMap.put(member.getUuid(), member);
            }
        }

        CPMembersContainer(CPMembersVersion version, Map<UUID, CPMember> members) {
            this.version = version;
            this.members = members.values().toArray(new CPMember[0]);
            this.membersMap = members;
        }

        public String toString() {
            return "CPMembersContainer{version=" + this.version + ", members=" + Arrays.toString(this.members) + '}';
        }
    }

    static final class MemberCursor {
        private final CPMember[] members;
        private int index = -1;

        MemberCursor(CPMember[] members) {
            this.members = members;
        }

        boolean advance() {
            return ++this.index < this.members.length;
        }

        CPMember get() {
            return this.members[this.index];
        }
    }
}

