/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.internal.serialization.BinaryInterface;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.PredicateBuilder;
import com.hazelcast.query.Predicates;
import com.hazelcast.query.QueryConstants;
import com.hazelcast.query.QueryException;
import com.hazelcast.query.impl.QueryContext;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.predicates.IndexAwarePredicate;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@BinaryInterface
public class PredicateBuilderImpl
implements PredicateBuilder,
PredicateBuilder.EntryObject,
IndexAwarePredicate,
DataSerializable {
    private List<Predicate> lsPredicates = new ArrayList<Predicate>();
    private String attribute;

    @Override
    public String getAttribute() {
        return this.attribute;
    }

    @Override
    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    @Override
    public boolean apply(Map.Entry mapEntry) {
        return this.lsPredicates.get(0).apply(mapEntry);
    }

    @Override
    public PredicateBuilder.EntryObject getEntryObject() {
        return this;
    }

    @Override
    public PredicateBuilder and(Predicate predicate) {
        if (predicate != this) {
            throw new QueryException("Illegal and statement expected: " + PredicateBuilderImpl.class.getSimpleName() + ", found: " + (predicate == null ? "null" : predicate.getClass().getSimpleName()));
        }
        int index = this.lsPredicates.size() - 2;
        Predicate first = this.lsPredicates.remove(index);
        Predicate second = this.lsPredicates.remove(index);
        return this.addPredicate(Predicates.and(first, second));
    }

    @Override
    public PredicateBuilder or(Predicate predicate) {
        if (predicate != this) {
            throw new RuntimeException("Illegal or statement expected: " + PredicateBuilderImpl.class.getSimpleName() + ", found: " + (predicate == null ? "null" : predicate.getClass().getSimpleName()));
        }
        int index = this.lsPredicates.size() - 2;
        Predicate first = this.lsPredicates.remove(index);
        Predicate second = this.lsPredicates.remove(index);
        return this.addPredicate(Predicates.or(first, second));
    }

    public Set<QueryableEntry> filter(QueryContext queryContext) {
        Predicate p = this.lsPredicates.get(0);
        if (p instanceof IndexAwarePredicate) {
            return ((IndexAwarePredicate)p).filter(queryContext);
        }
        return null;
    }

    @Override
    public boolean isIndexed(QueryContext queryContext) {
        Predicate p = this.lsPredicates.get(0);
        if (p instanceof IndexAwarePredicate) {
            return ((IndexAwarePredicate)p).isIndexed(queryContext);
        }
        return false;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.attribute);
        out.writeInt(this.lsPredicates.size());
        for (Predicate predicate : this.lsPredicates) {
            out.writeObject(predicate);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.attribute = in.readUTF();
        int size = in.readInt();
        this.lsPredicates = new ArrayList<Predicate>(size);
        for (int i = 0; i < size; ++i) {
            this.addPredicate((Predicate)in.readObject());
        }
    }

    public String toString() {
        return "PredicateBuilder{\n" + (this.lsPredicates.size() == 0 ? "" : (Serializable)this.lsPredicates.get(0)) + "\n}";
    }

    @Override
    public PredicateBuilder.EntryObject get(String attribute) {
        if (QueryConstants.KEY_ATTRIBUTE_NAME.value().equals(this.getAttribute())) {
            this.setAttribute(QueryConstants.KEY_ATTRIBUTE_NAME.value() + "." + attribute);
        } else {
            this.setAttribute(attribute);
        }
        return this;
    }

    @Override
    public PredicateBuilder.EntryObject key() {
        this.setAttribute(QueryConstants.KEY_ATTRIBUTE_NAME.value());
        return this;
    }

    @Override
    public PredicateBuilder is(String attribute) {
        return this.addPredicate(Predicates.equal(attribute, Boolean.valueOf(true)));
    }

    @Override
    public PredicateBuilder isNot(String attribute) {
        return this.addPredicate(Predicates.notEqual(attribute, Boolean.valueOf(true)));
    }

    @Override
    public PredicateBuilder equal(Comparable value) {
        return this.addPredicate(Predicates.equal(this.getAttribute(), value));
    }

    @Override
    public PredicateBuilder notEqual(Comparable value) {
        return this.addPredicate(Predicates.notEqual(this.getAttribute(), value));
    }

    @Override
    public PredicateBuilder isNull() {
        return this.addPredicate(Predicates.equal(this.getAttribute(), null));
    }

    @Override
    public PredicateBuilder isNotNull() {
        return this.addPredicate(Predicates.notEqual(this.getAttribute(), null));
    }

    @Override
    public PredicateBuilder greaterThan(Comparable value) {
        return this.addPredicate(Predicates.greaterThan(this.getAttribute(), value));
    }

    @Override
    public PredicateBuilder greaterEqual(Comparable value) {
        return this.addPredicate(Predicates.greaterEqual(this.getAttribute(), value));
    }

    @Override
    public PredicateBuilder lessThan(Comparable value) {
        return this.addPredicate(Predicates.lessThan(this.getAttribute(), value));
    }

    @Override
    public PredicateBuilder lessEqual(Comparable value) {
        return this.addPredicate(Predicates.lessEqual(this.getAttribute(), value));
    }

    @Override
    public PredicateBuilder between(Comparable from, Comparable to) {
        return this.addPredicate(Predicates.between(this.getAttribute(), from, to));
    }

    @Override
    public PredicateBuilder in(Comparable ... values) {
        return this.addPredicate(Predicates.in(this.getAttribute(), values));
    }

    private PredicateBuilder addPredicate(Predicate predicate) {
        this.lsPredicates.add(predicate);
        return this;
    }
}

