/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.map.impl.MetadataInitializer;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.MutationObserver;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.Metadata;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import javax.annotation.Nonnull;

public class JsonMetadataMutationObserver
implements MutationObserver<Record> {
    private SerializationService serializationService;
    private MetadataInitializer metadataInitializer;

    public JsonMetadataMutationObserver(SerializationService serializationService, MetadataInitializer metadataInitializer) {
        this.serializationService = serializationService;
        this.metadataInitializer = metadataInitializer;
    }

    @Override
    public void onPutRecord(@Nonnull Data key, Record record, Object oldValue, boolean backup) {
        this.onPutInternal(key, record);
    }

    @Override
    public void onReplicationPutRecord(@Nonnull Data key, @Nonnull Record record, boolean populateIndex) {
        this.onPutInternal(key, record);
    }

    @Override
    public void onUpdateRecord(@Nonnull Data key, @Nonnull Record record, Object oldValue, Object newValue, boolean backup) {
        this.updateValueMetadataIfNecessary(key, record, oldValue, newValue);
    }

    @Override
    public void onLoadRecord(@Nonnull Data key, @Nonnull Record record, boolean backup) {
        this.onPutInternal(key, record);
    }

    @Override
    public void onRemoveRecord(Data key, Record record) {
    }

    @Override
    public void onEvictRecord(Data key, Record record) {
    }

    @Override
    public void onReset() {
    }

    @Override
    public void onClear() {
    }

    @Override
    public void onDestroy(boolean isDuringShutdown, boolean internal) {
    }

    protected Metadata getMetadata(Data dataKey, Record record) {
        return record.getMetadata();
    }

    protected void setMetadata(Data dataKey, Record record, Metadata metadata) {
        record.setMetadata(metadata);
    }

    protected void removeMetadata(Data dataKey, Record record) {
        record.setMetadata(null);
    }

    private void onPutInternal(Data dataKey, Record record) {
        Metadata metadata = this.initializeMetadata(dataKey, record.getValue());
        if (metadata != null) {
            this.setMetadata(dataKey, record, metadata);
        }
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    private void updateValueMetadataIfNecessary(Data dataKey, Record record, Object oldValue, Object updateValue) {
        Object valueMetadata = null;
        try {
            valueMetadata = oldValue instanceof Data ? this.metadataInitializer.createFromData((Data)this.serializationService.toData(updateValue)) : this.metadataInitializer.createFromObject(this.serializationService.toObject(updateValue));
        }
        catch (IOException e) {
            EmptyStatement.ignore(e);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        if (valueMetadata != null) {
            Metadata existing = this.getMetadata(dataKey, record);
            if (existing == null) {
                existing = new Metadata();
                this.setMetadata(dataKey, record, existing);
            }
            existing.setValueMetadata(valueMetadata);
        } else {
            Metadata existing = this.getMetadata(dataKey, record);
            if (existing != null) {
                if (existing.getKeyMetadata() == null) {
                    this.removeMetadata(dataKey, record);
                } else {
                    existing.setValueMetadata(valueMetadata);
                }
            }
        }
    }

    private Metadata initializeMetadata(Data key, Object value) {
        try {
            Object keyMetadata = this.metadataInitializer.createFromData(key);
            Object valueMetadata = value instanceof Data ? this.metadataInitializer.createFromData((Data)value) : this.metadataInitializer.createFromObject(value);
            if (keyMetadata != null || valueMetadata != null) {
                Metadata metadata = new Metadata();
                metadata.setKeyMetadata(keyMetadata);
                metadata.setValueMetadata(valueMetadata);
                return metadata;
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }
}

