/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.operation.MapReplicationOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.RecordStoreAdapter;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.MapIndexInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MapReplicationStateHolder
implements IdentifiedDataSerializable {
    protected transient Map<String, RecordStore<Record>> storesByMapName;
    protected transient Map<String, List> data;
    protected transient Map<String, Boolean> loaded;
    protected transient List<MapIndexInfo> mapIndexInfos;
    private MapReplicationOperation operation;

    public MapReplicationStateHolder() {
    }

    public MapReplicationStateHolder(MapReplicationOperation operation) {
        this.operation = operation;
    }

    void prepare(PartitionContainer container, Collection<ServiceNamespace> namespaces, int replicaIndex) {
        this.storesByMapName = MapUtil.createHashMap(namespaces.size());
        this.loaded = MapUtil.createHashMap(namespaces.size());
        this.mapIndexInfos = new ArrayList<MapIndexInfo>(namespaces.size());
        for (ServiceNamespace namespace : namespaces) {
            Indexes indexes;
            MapContainer mapContainer;
            MapConfig mapConfig;
            ObjectNamespace mapNamespace = (ObjectNamespace)namespace;
            String mapName = mapNamespace.getObjectName();
            RecordStore recordStore = container.getExistingRecordStore(mapName);
            if (recordStore == null || (mapConfig = (mapContainer = recordStore.getMapContainer()).getMapConfig()).getTotalBackupCount() < replicaIndex) continue;
            this.loaded.put(mapName, recordStore.isLoaded());
            this.storesByMapName.put(mapName, recordStore);
            HashSet<IndexConfig> indexConfigs = new HashSet<IndexConfig>();
            if (mapContainer.isGlobalIndexEnabled()) {
                indexes = mapContainer.getIndexes();
                for (InternalIndex index : indexes.getIndexes()) {
                    indexConfigs.add(index.getConfig());
                }
                indexConfigs.addAll(indexes.getIndexDefinitions());
            } else {
                indexes = mapContainer.getIndexes(container.getPartitionId());
                if (indexes != null && indexes.haveAtLeastOneIndexOrDefinition()) {
                    for (InternalIndex index : indexes.getIndexes()) {
                        indexConfigs.add(index.getConfig());
                    }
                    indexConfigs.addAll(indexes.getIndexDefinitions());
                }
            }
            MapIndexInfo mapIndexInfo = new MapIndexInfo(mapName);
            mapIndexInfo.addIndexCofigs(indexConfigs);
            this.mapIndexInfos.add(mapIndexInfo);
        }
    }

    void applyState() {
        ThreadUtil.assertRunningOnPartitionThread();
        this.applyIndexesState();
        if (!MapUtil.isNullOrEmpty(this.data)) {
            for (Map.Entry<String, List> dataEntry : this.data.entrySet()) {
                String mapName = dataEntry.getKey();
                List keyRecord = dataEntry.getValue();
                RecordStore recordStore = this.operation.getRecordStore(mapName);
                recordStore.reset();
                recordStore.setPreMigrationLoadedStatus(this.loaded.get(mapName));
                RecordStoreAdapter storeAdapter = new RecordStoreAdapter(recordStore);
                MapContainer mapContainer = recordStore.getMapContainer();
                PartitionContainer partitionContainer = recordStore.getMapContainer().getMapServiceContext().getPartitionContainer(this.operation.getPartitionId());
                for (Map.Entry<String, IndexConfig> indexDefinition : mapContainer.getIndexDefinitions().entrySet()) {
                    Indexes indexes;
                    indexes.addOrGetIndex(indexDefinition.getValue(), (indexes = mapContainer.getIndexes(partitionContainer.getPartitionId())).isGlobal() ? null : storeAdapter);
                }
                Indexes indexes = mapContainer.getIndexes(partitionContainer.getPartitionId());
                boolean populateIndexes = MapReplicationStateHolder.indexesMustBePopulated(indexes, this.operation);
                if (populateIndexes) {
                    indexes.clearAll();
                }
                long nowInMillis = Clock.currentTimeMillis();
                InternalIndex[] indexesSnapshot = indexes.getIndexes();
                for (int i = 0; i < keyRecord.size(); i += 2) {
                    Data dataKey = (Data)keyRecord.get(i);
                    Record record = (Record)keyRecord.get(i + 1);
                    recordStore.putReplicatedRecord(dataKey, record, nowInMillis, populateIndexes);
                    if (recordStore.shouldEvict()) {
                        recordStore.evictEntries(dataKey);
                        break;
                    }
                    recordStore.disposeDeferredBlocks();
                }
                if (!populateIndexes) continue;
                Indexes.markPartitionAsIndexed(partitionContainer.getPartitionId(), indexesSnapshot);
            }
        }
    }

    private void applyIndexesState() {
        if (this.mapIndexInfos != null) {
            for (MapIndexInfo mapIndexInfo : this.mapIndexInfos) {
                this.addIndexes(mapIndexInfo.getMapName(), mapIndexInfo.getIndexConfigs());
            }
        }
    }

    private void addIndexes(String mapName, Collection<IndexConfig> indexConfigs) {
        if (indexConfigs == null) {
            return;
        }
        RecordStore recordStore = this.operation.getRecordStore(mapName);
        MapContainer mapContainer = recordStore.getMapContainer();
        if (mapContainer.isGlobalIndexEnabled()) {
            for (IndexConfig indexConfig : indexConfigs) {
                RecordStoreAdapter recordStoreAdapter;
                Indexes indexes = mapContainer.getIndexes();
                RecordStoreAdapter recordStoreAdapter2 = recordStoreAdapter = indexes.isGlobal() ? null : new RecordStoreAdapter(recordStore);
                if (indexes.getIndex(indexConfig.getName()) != null) continue;
                indexes.addOrGetIndex(indexConfig, recordStoreAdapter);
            }
        } else {
            Indexes indexes = mapContainer.getIndexes(this.operation.getPartitionId());
            RecordStoreAdapter recordStoreAdapter = indexes.isGlobal() ? null : new RecordStoreAdapter(recordStore);
            indexes.createIndexesFromRecordedDefinitions(recordStoreAdapter);
            for (IndexConfig indexConfig : indexConfigs) {
                indexes.addOrGetIndex(indexConfig, recordStoreAdapter);
            }
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.storesByMapName.size());
        for (Map.Entry<String, RecordStore<Record>> entry : this.storesByMapName.entrySet()) {
            String mapName = entry.getKey();
            out.writeUTF(mapName);
            SerializationService ss = MapReplicationStateHolder.getSerializationService(this.operation.getRecordStore(mapName).getMapContainer());
            RecordStore<Record> recordStore = entry.getValue();
            out.writeInt(recordStore.size());
            recordStore.forEach((dataKey, record) -> {
                try {
                    IOUtil.writeData(out, dataKey);
                    Records.writeRecord(out, record, ss.toData(record.getValue()));
                }
                catch (IOException e) {
                    throw ExceptionUtil.rethrow(e);
                }
            }, this.operation.getReplicaIndex() != 0, true);
        }
        out.writeInt(this.loaded.size());
        for (Map.Entry<String, Object> entry : this.loaded.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeBoolean((Boolean)entry.getValue());
        }
        out.writeInt(this.mapIndexInfos.size());
        for (MapIndexInfo mapIndexInfo : this.mapIndexInfos) {
            out.writeObject(mapIndexInfo);
        }
    }

    private static SerializationService getSerializationService(MapContainer mapContainer) {
        return mapContainer.getMapServiceContext().getNodeEngine().getSerializationService();
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.data = MapUtil.createHashMap(size);
        for (int i = 0; i < size; ++i) {
            String name = in.readUTF();
            int numOfRecords = in.readInt();
            ArrayList<Object> keyRecord = new ArrayList<Object>(numOfRecords * 2);
            for (int j = 0; j < numOfRecords; ++j) {
                Data dataKey = IOUtil.readData(in);
                Record record = Records.readRecord(in);
                keyRecord.add(dataKey);
                keyRecord.add(record);
            }
            this.data.put(name, keyRecord);
        }
        int loadedSize = in.readInt();
        this.loaded = MapUtil.createHashMap(loadedSize);
        for (int i = 0; i < loadedSize; ++i) {
            this.loaded.put(in.readUTF(), in.readBoolean());
        }
        int mapIndexInfoSize = in.readInt();
        this.mapIndexInfos = new ArrayList<MapIndexInfo>(mapIndexInfoSize);
        for (int i = 0; i < mapIndexInfoSize; ++i) {
            MapIndexInfo mapIndexInfo = (MapIndexInfo)in.readObject();
            this.mapIndexInfos.add(mapIndexInfo);
        }
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 103;
    }

    private static boolean indexesMustBePopulated(Indexes indexes, MapReplicationOperation operation) {
        if (!indexes.haveAtLeastOneIndex()) {
            return false;
        }
        if (indexes.isGlobal()) {
            return false;
        }
        return operation.getReplicaIndex() == 0;
    }
}

