/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.operation.MapNearCacheStateHolder;
import com.hazelcast.map.impl.operation.MapReplicationStateHolder;
import com.hazelcast.map.impl.operation.WriteBehindStateHolder;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.Collection;

public class MapReplicationOperation
extends Operation
implements IdentifiedDataSerializable {
    protected final MapReplicationStateHolder mapReplicationStateHolder = new MapReplicationStateHolder(this);
    protected final WriteBehindStateHolder writeBehindStateHolder = new WriteBehindStateHolder(this);
    protected final MapNearCacheStateHolder mapNearCacheStateHolder = new MapNearCacheStateHolder(this);
    private transient NativeOutOfMemoryError oome;

    public MapReplicationOperation() {
    }

    public MapReplicationOperation(PartitionContainer container, int partitionId, int replicaIndex) {
        this.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        Collection<ServiceNamespace> namespaces = container.getAllNamespaces(replicaIndex);
        this.mapReplicationStateHolder.prepare(container, namespaces, replicaIndex);
        this.writeBehindStateHolder.prepare(container, namespaces, replicaIndex);
        this.mapNearCacheStateHolder.prepare(container, namespaces, replicaIndex);
    }

    public MapReplicationOperation(PartitionContainer container, Collection<ServiceNamespace> namespaces, int partitionId, int replicaIndex) {
        this.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        this.mapReplicationStateHolder.prepare(container, namespaces, replicaIndex);
        this.writeBehindStateHolder.prepare(container, namespaces, replicaIndex);
        this.mapNearCacheStateHolder.prepare(container, namespaces, replicaIndex);
    }

    @Override
    public void run() {
        block3: {
            try {
                this.mapReplicationStateHolder.applyState();
                this.writeBehindStateHolder.applyState();
                if (this.getReplicaIndex() == 0) {
                    this.mapNearCacheStateHolder.applyState();
                }
            }
            catch (Throwable e) {
                this.getLogger().severe("map replication operation failed for partitionId=" + this.getPartitionId(), e);
                this.disposePartition();
                if (!(e instanceof NativeOutOfMemoryError)) break block3;
                this.oome = (NativeOutOfMemoryError)e;
            }
        }
    }

    @Override
    public void afterRun() throws Exception {
        this.disposePartition();
        if (this.oome != null) {
            this.getLogger().warning(this.oome.getMessage());
        }
    }

    private void disposePartition() {
        for (String mapName : this.mapReplicationStateHolder.data.keySet()) {
            this.dispose(mapName);
        }
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        this.disposePartition();
        super.onExecutionFailure(e);
    }

    private void dispose(String mapName) {
        int partitionId = this.getPartitionId();
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        RecordStore recordStore = mapServiceContext.getExistingRecordStore(partitionId, mapName);
        if (recordStore != null) {
            recordStore.disposeDeferredBlocks();
        }
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        this.mapReplicationStateHolder.writeData(out);
        this.writeBehindStateHolder.writeData(out);
        this.mapNearCacheStateHolder.writeData(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.mapReplicationStateHolder.readData(in);
        this.writeBehindStateHolder.readData(in);
        this.mapNearCacheStateHolder.readData(in);
    }

    RecordStore getRecordStore(String mapName) {
        boolean skipLoadingOnRecordStoreCreate = true;
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        return mapServiceContext.getRecordStore(this.getPartitionId(), mapName, true);
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 91;
    }
}

