/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.internal.locksupport.LockWaitNotifyKey;
import com.hazelcast.map.impl.operation.ReadonlyKeyBasedMapOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.operationservice.BlockingOperation;
import com.hazelcast.spi.impl.operationservice.WaitNotifyKey;

public final class GetOperation
extends ReadonlyKeyBasedMapOperation
implements BlockingOperation {
    private Data result;

    public GetOperation() {
    }

    public GetOperation(String name, Data dataKey) {
        super(name, dataKey);
        this.dataKey = dataKey;
    }

    @Override
    protected void runInternal() {
        Object currentValue = this.recordStore.get(this.dataKey, false, this.getCallerAddress());
        this.result = !this.executedLocally() && currentValue instanceof Data ? (Data)currentValue : this.mapService.getMapServiceContext().toData(currentValue);
    }

    @Override
    protected void afterRunInternal() {
        this.mapServiceContext.interceptAfterGet(this.mapContainer.getInterceptorRegistry(), this.result);
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return new LockWaitNotifyKey(this.getServiceNamespace(), this.dataKey);
    }

    @Override
    public boolean shouldWait() {
        if (this.recordStore.isTransactionallyLocked(this.dataKey)) {
            return !this.recordStore.canAcquireLock(this.dataKey, this.getCallerUuid(), this.getThreadId());
        }
        return false;
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(new OperationTimeoutException("Cannot read transactionally locked entry!"));
    }

    @Override
    public Data getResponse() {
        return this.result;
    }

    @Override
    public int getClassId() {
        return 1;
    }
}

