/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.WanAcknowledgeType;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.services.ReplicationSupportingService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.map.impl.wan.MapReplicationRemove;
import com.hazelcast.map.impl.wan.MapReplicationUpdate;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.merge.MergingValueFactory;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.wan.DistributedServiceWanEventCounters;
import com.hazelcast.wan.WanReplicationEvent;

class MapReplicationSupportingService
implements ReplicationSupportingService {
    private final MapServiceContext mapServiceContext;
    private final NodeEngine nodeEngine;
    private final DistributedServiceWanEventCounters wanEventTypeCounters;

    MapReplicationSupportingService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.wanEventTypeCounters = this.nodeEngine.getWanReplicationService().getReceivedEventCounters("hz:impl:mapService");
    }

    @Override
    public void onReplicationEvent(WanReplicationEvent event, WanAcknowledgeType acknowledgeType) {
        if (event instanceof MapReplicationUpdate) {
            this.handleUpdate((MapReplicationUpdate)event);
        } else if (event instanceof MapReplicationRemove) {
            this.handleRemove((MapReplicationRemove)event);
        }
    }

    private void handleRemove(MapReplicationRemove replicationRemove) {
        String mapName = replicationRemove.getObjectName();
        MapOperationProvider operationProvider = this.mapServiceContext.getMapOperationProvider(mapName);
        MapOperation operation = operationProvider.createDeleteOperation(replicationRemove.getObjectName(), replicationRemove.getKey(), true);
        try {
            int partitionId = this.nodeEngine.getPartitionService().getPartitionId(replicationRemove.getKey());
            InvocationFuture future = this.nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            future.get();
            this.wanEventTypeCounters.incrementRemove(mapName);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private void handleUpdate(MapReplicationUpdate replicationUpdate) {
        SplitBrainMergePolicy mergePolicy = replicationUpdate.getMergePolicy();
        String mapName = replicationUpdate.getObjectName();
        MapOperationProvider operationProvider = this.mapServiceContext.getMapOperationProvider(mapName);
        SerializationService serializationService = this.nodeEngine.getSerializationService();
        SplitBrainMergeTypes.MapMergeTypes mergingEntry = MergingValueFactory.createMergingEntry(serializationService, replicationUpdate.getEntryView());
        MapOperation operation = operationProvider.createMergeOperation(mapName, mergingEntry, mergePolicy, true);
        try {
            int partitionId = this.nodeEngine.getPartitionService().getPartitionId(replicationUpdate.getEntryView().getKey());
            InvocationFuture future = this.nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            future.get();
            this.wanEventTypeCounters.incrementUpdate(mapName);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }
}

