/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.internal.partition.PartitionAwareService;
import com.hazelcast.internal.services.ClientAwareService;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.services.PostJoinAwareService;
import com.hazelcast.internal.services.RemoteService;
import com.hazelcast.internal.services.ReplicationSupportingService;
import com.hazelcast.internal.services.SplitBrainHandlerService;
import com.hazelcast.internal.services.StatisticsAwareService;
import com.hazelcast.internal.services.TransactionalService;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.MapServiceFactory;
import com.hazelcast.map.impl.MapSplitBrainProtectionAwareService;
import com.hazelcast.spi.impl.CountingMigrationAwareService;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.eventservice.EventPublishingService;

abstract class AbstractMapServiceFactory
implements MapServiceFactory {
    AbstractMapServiceFactory() {
    }

    abstract ManagedService createManagedService();

    abstract CountingMigrationAwareService createMigrationAwareService();

    abstract TransactionalService createTransactionalService();

    abstract RemoteService createRemoteService();

    abstract EventPublishingService createEventPublishingService();

    abstract PostJoinAwareService createPostJoinAwareService();

    abstract SplitBrainHandlerService createSplitBrainHandlerService();

    abstract ReplicationSupportingService createReplicationSupportingService();

    abstract StatisticsAwareService createStatisticsAwareService();

    abstract PartitionAwareService createPartitionAwareService();

    abstract ClientAwareService createClientAwareService();

    abstract MapSplitBrainProtectionAwareService createSplitBrainProtectionAwareService();

    @Override
    public MapService createMapService() {
        NodeEngine nodeEngine = this.getNodeEngine();
        MapServiceContext mapServiceContext = this.getMapServiceContext();
        ManagedService managedService = this.createManagedService();
        CountingMigrationAwareService migrationAwareService = this.createMigrationAwareService();
        TransactionalService transactionalService = this.createTransactionalService();
        RemoteService remoteService = this.createRemoteService();
        EventPublishingService eventPublishingService = this.createEventPublishingService();
        PostJoinAwareService postJoinAwareService = this.createPostJoinAwareService();
        SplitBrainHandlerService splitBrainHandlerService = this.createSplitBrainHandlerService();
        ReplicationSupportingService replicationSupportingService = this.createReplicationSupportingService();
        StatisticsAwareService statisticsAwareService = this.createStatisticsAwareService();
        PartitionAwareService partitionAwareService = this.createPartitionAwareService();
        MapSplitBrainProtectionAwareService splitBrainProtectionAwareService = this.createSplitBrainProtectionAwareService();
        ClientAwareService clientAwareService = this.createClientAwareService();
        Preconditions.checkNotNull(nodeEngine, "nodeEngine should not be null");
        Preconditions.checkNotNull(mapServiceContext, "mapServiceContext should not be null");
        Preconditions.checkNotNull(managedService, "managedService should not be null");
        Preconditions.checkNotNull(migrationAwareService, "migrationAwareService should not be null");
        Preconditions.checkNotNull(transactionalService, "transactionalService should not be null");
        Preconditions.checkNotNull(remoteService, "remoteService should not be null");
        Preconditions.checkNotNull(eventPublishingService, "eventPublishingService should not be null");
        Preconditions.checkNotNull(postJoinAwareService, "postJoinAwareService should not be null");
        Preconditions.checkNotNull(splitBrainHandlerService, "splitBrainHandlerService should not be null");
        Preconditions.checkNotNull(replicationSupportingService, "replicationSupportingService should not be null");
        Preconditions.checkNotNull(statisticsAwareService, "statisticsAwareService should not be null");
        Preconditions.checkNotNull(partitionAwareService, "partitionAwareService should not be null");
        Preconditions.checkNotNull(splitBrainProtectionAwareService, "splitBrainProtectionAwareService should not be null");
        Preconditions.checkNotNull(clientAwareService, "clientAwareService should not be null");
        MapService mapService = new MapService();
        mapService.managedService = managedService;
        mapService.migrationAwareService = migrationAwareService;
        mapService.transactionalService = transactionalService;
        mapService.remoteService = remoteService;
        mapService.eventPublishingService = eventPublishingService;
        mapService.postJoinAwareService = postJoinAwareService;
        mapService.splitBrainHandlerService = splitBrainHandlerService;
        mapService.replicationSupportingService = replicationSupportingService;
        mapService.statisticsAwareService = statisticsAwareService;
        mapService.mapServiceContext = mapServiceContext;
        mapService.partitionAwareService = partitionAwareService;
        mapService.splitBrainProtectionAwareService = splitBrainProtectionAwareService;
        mapService.clientAwareService = clientAwareService;
        mapServiceContext.setService(mapService);
        return mapService;
    }
}

