/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.partition.IPartition;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.MigrationEndpoint;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.MigrationStateImpl;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.PartitionRuntimeState;
import com.hazelcast.internal.partition.PartitionStateVersionMismatchException;
import com.hazelcast.internal.partition.impl.InternalPartitionImpl;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.MigrationInterceptor;
import com.hazelcast.internal.partition.impl.MigrationPlanner;
import com.hazelcast.internal.partition.impl.MigrationQueue;
import com.hazelcast.internal.partition.impl.MigrationRunnable;
import com.hazelcast.internal.partition.impl.MigrationStats;
import com.hazelcast.internal.partition.impl.MigrationThread;
import com.hazelcast.internal.partition.impl.PartitionEventManager;
import com.hazelcast.internal.partition.impl.PartitionStateManager;
import com.hazelcast.internal.partition.operation.FinalizeMigrationOperation;
import com.hazelcast.internal.partition.operation.MigrationCommitOperation;
import com.hazelcast.internal.partition.operation.MigrationRequestOperation;
import com.hazelcast.internal.partition.operation.PromotionCommitOperation;
import com.hazelcast.internal.partition.operation.PublishCompletedMigrationsOperation;
import com.hazelcast.internal.partition.operation.ShutdownResponseOperation;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.collection.Int2ObjectHashMap;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.internal.util.scheduler.CoalescingDelayedTrigger;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class MigrationManager {
    private static final int MIGRATION_PAUSE_DURATION_SECONDS_ON_MIGRATION_FAILURE = 3;
    private static final int PUBLISH_COMPLETED_MIGRATIONS_BATCH_SIZE = 10;
    final long partitionMigrationInterval;
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final InternalPartitionServiceImpl partitionService;
    private final ILogger logger;
    private final PartitionStateManager partitionStateManager;
    private final MigrationQueue migrationQueue = new MigrationQueue();
    private final MigrationThread migrationThread;
    private final AtomicBoolean migrationTasksAllowed = new AtomicBoolean(true);
    private final long partitionMigrationTimeout;
    private final CoalescingDelayedTrigger delayedResumeMigrationTrigger;
    private final Set<Member> shutdownRequestedMembers = new HashSet<Member>();
    private volatile MigrationInfo activeMigrationInfo;
    private final LinkedHashSet<MigrationInfo> completedMigrations = new LinkedHashSet();
    private final AtomicBoolean promotionPermit = new AtomicBoolean(false);
    private final MigrationStats stats = new MigrationStats();
    private volatile MigrationInterceptor migrationInterceptor = new MigrationInterceptor.NopMigrationInterceptor();
    private final Lock partitionServiceLock;
    private final MigrationPlanner migrationPlanner;
    private final boolean fragmentedMigrationEnabled;
    private final long memberHeartbeatTimeoutMillis;
    private boolean triggerRepartitioningWhenClusterStateAllowsMigration;

    MigrationManager(Node node, InternalPartitionServiceImpl service, Lock partitionServiceLock) {
        this.node = node;
        this.nodeEngine = node.getNodeEngine();
        this.partitionService = service;
        this.logger = node.getLogger(this.getClass());
        this.partitionServiceLock = partitionServiceLock;
        this.migrationPlanner = new MigrationPlanner(node.getLogger(MigrationPlanner.class));
        HazelcastProperties properties = node.getProperties();
        this.partitionMigrationInterval = properties.getPositiveMillisOrDefault(ClusterProperty.PARTITION_MIGRATION_INTERVAL, 0L);
        this.partitionMigrationTimeout = properties.getMillis(ClusterProperty.PARTITION_MIGRATION_TIMEOUT);
        this.fragmentedMigrationEnabled = properties.getBoolean(ClusterProperty.PARTITION_FRAGMENTED_MIGRATION_ENABLED);
        this.partitionStateManager = this.partitionService.getPartitionStateManager();
        ILogger migrationThreadLogger = node.getLogger(MigrationThread.class);
        String hzName = this.nodeEngine.getHazelcastInstance().getName();
        this.migrationThread = new MigrationThread(this, hzName, migrationThreadLogger, this.migrationQueue);
        long migrationPauseDelayMs = TimeUnit.SECONDS.toMillis(3L);
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        this.delayedResumeMigrationTrigger = new CoalescingDelayedTrigger(executionService, migrationPauseDelayMs, 2L * migrationPauseDelayMs, this::resumeMigration);
        this.memberHeartbeatTimeoutMillis = properties.getMillis(ClusterProperty.MAX_NO_HEARTBEAT_SECONDS);
        this.nodeEngine.getMetricsRegistry().registerStaticMetrics(this.stats, "partitions");
    }

    @Probe(name="migrationActive")
    private int migrationActiveProbe() {
        return this.migrationTasksAllowed.get() ? 1 : 0;
    }

    void pauseMigration() {
        this.migrationTasksAllowed.set(false);
    }

    void resumeMigration() {
        this.migrationTasksAllowed.set(true);
    }

    private void resumeMigrationEventually() {
        this.delayedResumeMigrationTrigger.executeWithDelay();
    }

    boolean areMigrationTasksAllowed() {
        return this.migrationTasksAllowed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalizeMigration(MigrationInfo migrationInfo) {
        try {
            PartitionReplica localReplica = PartitionReplica.from(this.node.getLocalMember());
            int partitionId = migrationInfo.getPartitionId();
            boolean source = localReplica.equals(migrationInfo.getSource());
            boolean destination = localReplica.equals(migrationInfo.getDestination());
            assert (migrationInfo.getStatus() == MigrationInfo.MigrationStatus.SUCCESS || migrationInfo.getStatus() == MigrationInfo.MigrationStatus.FAILED) : "Invalid migration: " + migrationInfo;
            if (source || destination) {
                MigrationInterceptor.MigrationParticipant participant;
                boolean success = migrationInfo.getStatus() == MigrationInfo.MigrationStatus.SUCCESS;
                MigrationInterceptor.MigrationParticipant migrationParticipant = participant = source ? MigrationInterceptor.MigrationParticipant.SOURCE : MigrationInterceptor.MigrationParticipant.DESTINATION;
                if (success) {
                    this.migrationInterceptor.onMigrationCommit(participant, migrationInfo);
                } else {
                    this.migrationInterceptor.onMigrationRollback(participant, migrationInfo);
                }
                MigrationEndpoint endpoint = source ? MigrationEndpoint.SOURCE : MigrationEndpoint.DESTINATION;
                FinalizeMigrationOperation op = new FinalizeMigrationOperation(migrationInfo, endpoint, success);
                op.setPartitionId(partitionId).setNodeEngine(this.nodeEngine).setValidateTarget(false).setService(this.partitionService);
                OperationServiceImpl operationService = this.nodeEngine.getOperationService();
                if (operationService.isRunAllowed(op)) {
                    operationService.run(op);
                } else {
                    operationService.execute(op);
                }
                this.removeActiveMigration(partitionId);
            } else {
                PartitionReplica partitionOwner = this.partitionStateManager.getPartitionImpl(partitionId).getOwnerReplicaOrNull();
                if (localReplica.equals(partitionOwner)) {
                    this.removeActiveMigration(partitionId);
                    this.partitionStateManager.clearMigratingFlag(partitionId);
                } else {
                    this.logger.severe("Failed to finalize migration because " + localReplica + " is not a participant of the migration: " + migrationInfo);
                }
            }
        }
        catch (Exception e) {
            this.logger.warning(e);
        }
        finally {
            migrationInfo.doneProcessing();
        }
    }

    public MigrationInfo setActiveMigration(MigrationInfo migrationInfo) {
        this.partitionServiceLock.lock();
        try {
            if (this.activeMigrationInfo == null) {
                this.activeMigrationInfo = migrationInfo;
                MigrationInfo migrationInfo2 = null;
                return migrationInfo2;
            }
            if (!this.activeMigrationInfo.equals(migrationInfo) && this.logger.isFineEnabled()) {
                this.logger.fine("Active migration is not set: " + migrationInfo + ". Existing active migration: " + this.activeMigrationInfo);
            }
            MigrationInfo migrationInfo3 = this.activeMigrationInfo;
            return migrationInfo3;
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    MigrationInfo getActiveMigration() {
        return this.activeMigrationInfo;
    }

    public boolean acquirePromotionPermit() {
        return this.promotionPermit.compareAndSet(false, true);
    }

    public void releasePromotionPermit() {
        this.promotionPermit.set(false);
    }

    private boolean removeActiveMigration(int partitionId) {
        this.partitionServiceLock.lock();
        try {
            if (this.activeMigrationInfo != null) {
                if (this.activeMigrationInfo.getPartitionId() == partitionId) {
                    this.activeMigrationInfo = null;
                    boolean bl = true;
                    return bl;
                }
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Active migration is not removed, because it has different partitionId! partitionId=" + partitionId + ", active migration=" + this.activeMigrationInfo);
                }
            }
        }
        finally {
            this.partitionServiceLock.unlock();
        }
        return false;
    }

    void scheduleActiveMigrationFinalization(MigrationInfo migrationInfo) {
        this.partitionServiceLock.lock();
        try {
            if (migrationInfo.equals(this.activeMigrationInfo)) {
                if (this.activeMigrationInfo.startProcessing()) {
                    this.activeMigrationInfo.setStatus(migrationInfo.getStatus());
                    this.finalizeMigration(this.activeMigrationInfo);
                } else {
                    this.logger.info("Scheduling finalization of " + migrationInfo + ", because migration process is currently running.");
                    this.nodeEngine.getExecutionService().schedule(() -> this.scheduleActiveMigrationFinalization(migrationInfo), 1L, TimeUnit.SECONDS);
                }
                return;
            }
            PartitionReplica source = migrationInfo.getSource();
            if (source != null && migrationInfo.getSourceCurrentReplicaIndex() > 0 && source.isIdentical(this.node.getLocalMember())) {
                this.finalizeMigration(migrationInfo);
            }
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    private boolean commitMigrationToDestination(MigrationInfo migration) {
        PartitionReplica destination = migration.getDestination();
        if (destination.isIdentical(this.node.getLocalMember())) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Shortcutting migration commit, since destination is master. -> " + migration);
            }
            return true;
        }
        MemberImpl member = this.node.getClusterService().getMember(destination.address(), destination.uuid());
        if (member == null) {
            this.logger.warning("Cannot commit " + migration + ". Destination " + destination + " is not a member anymore");
            return false;
        }
        try {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Sending migration commit operation to " + destination + " for " + migration);
            }
            migration.setStatus(MigrationInfo.MigrationStatus.SUCCESS);
            UUID destinationUuid = member.getUuid();
            MigrationCommitOperation operation = new MigrationCommitOperation(migration, destinationUuid);
            InvocationFuture future = this.nodeEngine.getOperationService().createInvocationBuilder("hz:core:partitionService", (Operation)operation, destination.address()).setTryCount(Integer.MAX_VALUE).setCallTimeout(this.memberHeartbeatTimeoutMillis).invoke();
            boolean result = (Boolean)future.get();
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Migration commit result " + result + " from " + destination + " for " + migration);
            }
            return result;
        }
        catch (Throwable t) {
            this.logMigrationCommitFailure(migration, t);
            if (t.getCause() instanceof OperationTimeoutException) {
                return this.commitMigrationToDestination(migration);
            }
            return false;
        }
    }

    private void logMigrationCommitFailure(MigrationInfo migration, Throwable t) {
        boolean memberLeft = t instanceof MemberLeftException || t.getCause() instanceof TargetNotMemberException || t.getCause() instanceof HazelcastInstanceNotActiveException;
        PartitionReplica destination = migration.getDestination();
        if (memberLeft) {
            if (destination.isIdentical(this.node.getLocalMember())) {
                this.logger.fine("Migration commit failed for " + migration + " since this node is shutting down.");
                return;
            }
            this.logger.warning("Migration commit failed for " + migration + " since destination " + destination + " left the cluster");
        } else {
            this.logger.severe("Migration commit to " + destination + " failed for " + migration, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addCompletedMigration(MigrationInfo migrationInfo) {
        if (migrationInfo.getStatus() != MigrationInfo.MigrationStatus.SUCCESS && migrationInfo.getStatus() != MigrationInfo.MigrationStatus.FAILED) {
            throw new IllegalArgumentException("Migration doesn't seem completed: " + migrationInfo);
        }
        if (migrationInfo.getInitialPartitionVersion() <= 0 || migrationInfo.getPartitionVersionIncrement() <= 0) {
            throw new IllegalArgumentException("Partition state versions are not set: " + migrationInfo);
        }
        this.partitionServiceLock.lock();
        try {
            boolean added = this.completedMigrations.add(migrationInfo);
            if (added) {
                this.stats.incrementCompletedMigrations();
            }
            boolean bl = added;
            return bl;
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    void retainCompletedMigrations(Collection<MigrationInfo> migrations) {
        this.partitionServiceLock.lock();
        try {
            this.completedMigrations.retainAll(migrations);
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    private void evictCompletedMigrations(Collection<MigrationInfo> migrations) {
        this.partitionServiceLock.lock();
        try {
            this.completedMigrations.removeAll(migrations);
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    void triggerControlTask() {
        this.migrationQueue.clear();
        if (this.stats.getRemainingMigrations() > 0) {
            this.migrationQueue.add(new PublishCompletedMigrationsTask());
        }
        if (!this.node.getClusterService().isJoined()) {
            this.logger.fine("Node is not joined, will not trigger ControlTask");
            return;
        }
        if (!this.partitionService.isLocalMemberMaster()) {
            this.logger.fine("Node is not master, will not trigger ControlTask");
            return;
        }
        this.migrationQueue.add(new ControlTask());
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Migration queue is cleared and control task is scheduled");
        }
    }

    MigrationInterceptor getMigrationInterceptor() {
        return this.migrationInterceptor;
    }

    void setMigrationInterceptor(MigrationInterceptor interceptor) {
        Preconditions.checkNotNull(interceptor);
        this.migrationInterceptor = interceptor;
    }

    void resetMigrationInterceptor() {
        this.migrationInterceptor = new MigrationInterceptor.NopMigrationInterceptor();
    }

    void onShutdownRequest(Member member) {
        if (!this.partitionStateManager.isInitialized()) {
            this.sendShutdownOperation(member.getAddress());
            return;
        }
        ClusterState clusterState = this.node.getClusterService().getClusterState();
        if (!clusterState.isMigrationAllowed() && clusterState != ClusterState.IN_TRANSITION) {
            this.sendShutdownOperation(member.getAddress());
            return;
        }
        if (this.shutdownRequestedMembers.add(member)) {
            this.logger.info("Shutdown request of " + member + " is handled");
            this.triggerControlTask();
        }
    }

    void onMemberRemove(Member member) {
        PartitionReplica replica;
        this.shutdownRequestedMembers.remove(member);
        MigrationInfo activeMigration = this.activeMigrationInfo;
        if (activeMigration != null && ((replica = PartitionReplica.from(member)).equals(activeMigration.getSource()) || replica.equals(activeMigration.getDestination()))) {
            activeMigration.setStatus(MigrationInfo.MigrationStatus.INVALID);
        }
    }

    void schedule(MigrationRunnable runnable) {
        this.migrationQueue.add(runnable);
    }

    List<MigrationInfo> getCompletedMigrationsCopy() {
        this.partitionServiceLock.lock();
        try {
            ArrayList<MigrationInfo> arrayList = new ArrayList<MigrationInfo>(this.completedMigrations);
            return arrayList;
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    boolean hasOnGoingMigration() {
        return this.activeMigrationInfo != null || this.migrationQueue.hasMigrationTasks();
    }

    int getMigrationQueueSize() {
        return this.migrationQueue.migrationTaskCount();
    }

    void reset() {
        this.migrationQueue.clear();
        this.activeMigrationInfo = null;
        this.completedMigrations.clear();
        this.shutdownRequestedMembers.clear();
        this.migrationTasksAllowed.set(true);
    }

    void start() {
        this.migrationThread.start();
    }

    void stop() {
        this.migrationThread.stopNow();
    }

    void scheduleMigration(MigrationInfo migrationInfo) {
        this.migrationQueue.add(new MigrateTask(migrationInfo));
    }

    void applyMigration(InternalPartitionImpl partition, MigrationInfo migrationInfo) {
        PartitionReplica[] members = Arrays.copyOf(partition.getReplicas(), 7);
        if (migrationInfo.getSourceCurrentReplicaIndex() > -1) {
            members[migrationInfo.getSourceCurrentReplicaIndex()] = null;
        }
        if (migrationInfo.getDestinationCurrentReplicaIndex() > -1) {
            members[migrationInfo.getDestinationCurrentReplicaIndex()] = null;
        }
        members[migrationInfo.getDestinationNewReplicaIndex()] = migrationInfo.getDestination();
        if (migrationInfo.getSourceNewReplicaIndex() > -1) {
            members[migrationInfo.getSourceNewReplicaIndex()] = migrationInfo.getSource();
        }
        partition.setReplicas(members);
    }

    Set<Member> getShutdownRequestedMembers() {
        return this.shutdownRequestedMembers;
    }

    private void sendShutdownOperation(Address address) {
        if (this.node.getThisAddress().equals(address)) {
            assert (!this.node.isRunning()) : "Node state: " + (Object)((Object)this.node.getState());
            this.partitionService.onShutdownResponse();
        } else {
            this.nodeEngine.getOperationService().send(new ShutdownResponseOperation(), address);
        }
    }

    boolean shouldTriggerRepartitioningWhenClusterStateAllowsMigration() {
        return this.triggerRepartitioningWhenClusterStateAllowsMigration;
    }

    private void publishCompletedMigrations() {
        assert (this.partitionService.isLocalMemberMaster());
        assert (this.partitionStateManager.isInitialized());
        List<MigrationInfo> migrations = this.getCompletedMigrationsCopy();
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Publishing completed migrations [" + migrations.size() + "]: " + migrations);
        }
        OperationServiceImpl operationService = this.nodeEngine.getOperationService();
        ClusterServiceImpl clusterService = this.node.clusterService;
        Set<Member> members = clusterService.getMembers();
        AtomicInteger latch = new AtomicInteger(members.size() - 1);
        for (Member member : members) {
            if (member.localMember()) continue;
            PublishCompletedMigrationsOperation operation = new PublishCompletedMigrationsOperation(migrations);
            InvocationFuture f = operationService.invokeOnTarget("hz:core:partitionService", operation, member.getAddress());
            ((CompletableFuture)f).whenCompleteAsync((response, t) -> {
                if (t == null) {
                    if (!Boolean.TRUE.equals(response)) {
                        this.logger.fine(member + " rejected completed migrations with response " + response);
                        this.partitionService.sendPartitionRuntimeState(member.getAddress());
                        return;
                    }
                    if (latch.decrementAndGet() == 0) {
                        this.logger.fine("Evicting " + migrations.size() + " completed migrations.");
                        this.evictCompletedMigrations(migrations);
                    }
                } else {
                    this.logger.fine("Failure while publishing completed migrations to " + member, (Throwable)t);
                    this.partitionService.sendPartitionRuntimeState(member.getAddress());
                }
            });
        }
    }

    public MigrationStats getStats() {
        return this.stats;
    }

    private class PublishCompletedMigrationsTask
    implements MigrationRunnable {
        private PublishCompletedMigrationsTask() {
        }

        @Override
        public void run() {
            MigrationManager.this.partitionService.getPartitionEventManager().sendMigrationProcessCompletedEvent(MigrationManager.this.stats.toMigrationState());
            MigrationManager.this.publishCompletedMigrations();
        }
    }

    private class ProcessShutdownRequestsTask
    implements MigrationRunnable {
        private ProcessShutdownRequestsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!MigrationManager.this.partitionService.isLocalMemberMaster()) {
                return;
            }
            MigrationManager.this.partitionServiceLock.lock();
            try {
                int shutdownRequestCount = MigrationManager.this.shutdownRequestedMembers.size();
                if (shutdownRequestCount > 0) {
                    if (shutdownRequestCount == MigrationManager.this.nodeEngine.getClusterService().getSize(MemberSelectors.DATA_MEMBER_SELECTOR)) {
                        for (Member member : MigrationManager.this.shutdownRequestedMembers) {
                            MigrationManager.this.sendShutdownOperation(member.getAddress());
                        }
                    } else {
                        boolean present = false;
                        for (Member member : MigrationManager.this.shutdownRequestedMembers) {
                            if (MigrationManager.this.partitionStateManager.isAbsentInPartitionTable(member)) {
                                MigrationManager.this.sendShutdownOperation(member.getAddress());
                                continue;
                            }
                            MigrationManager.this.logger.warning(member + " requested to shutdown but still in partition table");
                            present = true;
                        }
                        if (present) {
                            MigrationManager.this.triggerControlTask();
                        }
                    }
                }
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }
    }

    private class ControlTask
    implements MigrationRunnable {
        private ControlTask() {
        }

        @Override
        public void run() {
            MigrationManager.this.partitionServiceLock.lock();
            try {
                MigrationManager.this.migrationQueue.clear();
                if (MigrationManager.this.partitionService.scheduleFetchMostRecentPartitionTableTaskIfRequired()) {
                    if (MigrationManager.this.logger.isFinestEnabled()) {
                        MigrationManager.this.logger.finest("FetchMostRecentPartitionTableTask scheduled");
                    }
                    MigrationManager.this.migrationQueue.add(new ControlTask());
                    return;
                }
                if (MigrationManager.this.logger.isFinestEnabled()) {
                    MigrationManager.this.logger.finest("RepairPartitionTableTask scheduled");
                }
                MigrationManager.this.migrationQueue.add(new RepairPartitionTableTask());
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }
    }

    private class RepairPartitionTableTask
    implements MigrationRunnable {
        private RepairPartitionTableTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!MigrationManager.this.partitionStateManager.isInitialized()) {
                return;
            }
            ClusterState clusterState = MigrationManager.this.node.getClusterService().getClusterState();
            if (!clusterState.isMigrationAllowed() && !clusterState.isPartitionPromotionAllowed()) {
                MigrationManager.this.logger.fine("Will not repair partition table at the moment. Cluster state does not allow to modify partition table.");
                return;
            }
            Map<PartitionReplica, Collection<MigrationInfo>> promotions = this.removeUnknownMembersAndCollectPromotions();
            boolean success = this.promoteBackupsForMissingOwners(promotions);
            MigrationManager.this.partitionServiceLock.lock();
            try {
                if (success) {
                    if (MigrationManager.this.logger.isFinestEnabled()) {
                        MigrationManager.this.logger.finest("RepartitioningTask scheduled");
                    }
                    MigrationManager.this.migrationQueue.add(new RepartitioningTask());
                } else {
                    MigrationManager.this.triggerControlTask();
                }
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<PartitionReplica, Collection<MigrationInfo>> removeUnknownMembersAndCollectPromotions() {
            MigrationManager.this.partitionServiceLock.lock();
            try {
                MigrationManager.this.partitionStateManager.removeUnknownMembers();
                HashMap<PartitionReplica, Collection<MigrationInfo>> promotions = new HashMap<PartitionReplica, Collection<MigrationInfo>>();
                for (int partitionId = 0; partitionId < MigrationManager.this.partitionService.getPartitionCount(); ++partitionId) {
                    MigrationInfo migration = this.createPromotionMigrationIfOwnerIsNull(partitionId);
                    if (migration == null) continue;
                    Collection migrations = promotions.computeIfAbsent(migration.getDestination(), k -> new ArrayList());
                    migrations.add(migration);
                }
                HashMap<PartitionReplica, Collection<MigrationInfo>> hashMap = promotions;
                return hashMap;
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }

        private boolean promoteBackupsForMissingOwners(Map<PartitionReplica, Collection<MigrationInfo>> promotions) {
            boolean allSucceeded = true;
            for (Map.Entry<PartitionReplica, Collection<MigrationInfo>> entry : promotions.entrySet()) {
                PartitionReplica destination = entry.getKey();
                Collection<MigrationInfo> migrations = entry.getValue();
                allSucceeded &= this.commitPromotionMigrations(destination, migrations);
            }
            return allSucceeded;
        }

        private boolean commitPromotionMigrations(PartitionReplica destination, Collection<MigrationInfo> migrations) {
            MigrationManager.this.migrationInterceptor.onPromotionStart(MigrationInterceptor.MigrationParticipant.MASTER, migrations);
            boolean success = this.commitPromotionsToDestination(destination, migrations);
            boolean local = destination.isIdentical(MigrationManager.this.node.getLocalMember());
            if (!local) {
                this.processPromotionCommitResult(destination, migrations, success);
            }
            MigrationManager.this.migrationInterceptor.onPromotionComplete(MigrationInterceptor.MigrationParticipant.MASTER, migrations, success);
            MigrationManager.this.partitionService.publishPartitionRuntimeState();
            return success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processPromotionCommitResult(PartitionReplica destination, Collection<MigrationInfo> migrations, boolean success) {
            MigrationManager.this.partitionServiceLock.lock();
            try {
                if (!MigrationManager.this.partitionStateManager.isInitialized()) {
                    return;
                }
                if (success) {
                    for (MigrationInfo migration : migrations) {
                        InternalPartitionImpl partition = MigrationManager.this.partitionStateManager.getPartitionImpl(migration.getPartitionId());
                        assert (partition.getOwnerReplicaOrNull() == null) : "Owner should be null: " + partition;
                        assert (destination.equals(partition.getReplica(migration.getDestinationCurrentReplicaIndex()))) : "Invalid replica! Destination: " + destination + ", index: " + migration.getDestinationCurrentReplicaIndex() + ", " + partition;
                        partition.swapReplicas(0, migration.getDestinationCurrentReplicaIndex());
                    }
                } else {
                    int delta = 2 * migrations.size() + 1;
                    MigrationManager.this.partitionService.getPartitionStateManager().incrementVersion(delta);
                }
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }

        private MigrationInfo createPromotionMigrationIfOwnerIsNull(int partitionId) {
            InternalPartitionImpl partition = MigrationManager.this.partitionStateManager.getPartitionImpl(partitionId);
            if (partition.getOwnerReplicaOrNull() == null) {
                int index;
                PartitionReplica destination = null;
                for (int i = index = 1; i < 7; ++i) {
                    destination = partition.getReplica(i);
                    if (destination == null) continue;
                    index = i;
                    break;
                }
                if (MigrationManager.this.logger.isFinestEnabled()) {
                    if (destination != null) {
                        MigrationManager.this.logger.finest("partitionId=" + partition.getPartitionId() + " owner is removed. replicaIndex=" + index + " will be shifted up to 0. " + partition);
                    } else {
                        MigrationManager.this.logger.finest("partitionId=" + partition.getPartitionId() + " owner is removed. there is no other replica to shift up. " + partition);
                    }
                }
                if (destination != null) {
                    MigrationInfo migration = new MigrationInfo(partitionId, null, destination, -1, -1, index, 0);
                    migration.setMaster(MigrationManager.this.node.getThisAddress());
                    migration.setStatus(MigrationInfo.MigrationStatus.SUCCESS);
                    return migration;
                }
            }
            if (partition.getOwnerReplicaOrNull() == null) {
                MigrationManager.this.logger.warning("partitionId=" + partitionId + " is completely lost!");
                PartitionEventManager partitionEventManager = MigrationManager.this.partitionService.getPartitionEventManager();
                partitionEventManager.sendPartitionLostEvent(partitionId, 6);
            }
            return null;
        }

        private boolean commitPromotionsToDestination(PartitionReplica destination, Collection<MigrationInfo> migrations) {
            assert (migrations.size() > 0) : "No promotions to commit! destination=" + destination;
            MemberImpl member = MigrationManager.this.node.getClusterService().getMember(destination.address(), destination.uuid());
            if (member == null) {
                MigrationManager.this.logger.warning("Cannot commit promotions. Destination " + destination + " is not a member anymore");
                return false;
            }
            try {
                if (MigrationManager.this.logger.isFinestEnabled()) {
                    MigrationManager.this.logger.finest("Sending promotion commit operation to " + destination + " for " + migrations);
                }
                PartitionRuntimeState partitionState = MigrationManager.this.partitionService.createPromotionCommitPartitionState(migrations);
                UUID destinationUuid = member.getUuid();
                PromotionCommitOperation op = new PromotionCommitOperation(partitionState, migrations, destinationUuid);
                InvocationFuture future = MigrationManager.this.nodeEngine.getOperationService().createInvocationBuilder("hz:core:partitionService", (Operation)op, destination.address()).setTryCount(Integer.MAX_VALUE).setCallTimeout(MigrationManager.this.memberHeartbeatTimeoutMillis).invoke();
                boolean result = (Boolean)future.get();
                if (MigrationManager.this.logger.isFinestEnabled()) {
                    MigrationManager.this.logger.finest("Promotion commit result " + result + " from " + destination + " for migrations " + migrations);
                }
                return result;
            }
            catch (Throwable t) {
                this.logPromotionCommitFailure(destination, migrations, t);
                if (t.getCause() instanceof OperationTimeoutException) {
                    return this.commitPromotionsToDestination(destination, migrations);
                }
                return false;
            }
        }

        private void logPromotionCommitFailure(PartitionReplica destination, Collection<MigrationInfo> migrations, Throwable t) {
            boolean memberLeft = t instanceof MemberLeftException || t.getCause() instanceof TargetNotMemberException || t.getCause() instanceof HazelcastInstanceNotActiveException;
            int migrationsSize = migrations.size();
            if (memberLeft) {
                if (destination.isIdentical(MigrationManager.this.node.getLocalMember())) {
                    MigrationManager.this.logger.fine("Promotion commit failed for " + migrationsSize + " migrations since this node is shutting down.");
                    return;
                }
                if (MigrationManager.this.logger.isFinestEnabled()) {
                    MigrationManager.this.logger.warning("Promotion commit failed for " + migrations + " since destination " + destination + " left the cluster");
                } else {
                    MigrationManager.this.logger.warning("Promotion commit failed for " + (migrationsSize == 1 ? migrations.iterator().next() : migrationsSize + " migrations") + " since destination " + destination + " left the cluster");
                }
                return;
            }
            if (MigrationManager.this.logger.isFinestEnabled()) {
                MigrationManager.this.logger.severe("Promotion commit to " + destination + " failed for " + migrations, t);
            } else {
                MigrationManager.this.logger.severe("Promotion commit to " + destination + " failed for " + (migrationsSize == 1 ? migrations.iterator().next() : migrationsSize + " migrations"), t);
            }
        }
    }

    class MigrateTask
    implements MigrationRunnable {
        private final MigrationInfo migrationInfo;

        MigrateTask(MigrationInfo migrationInfo) {
            this.migrationInfo = migrationInfo;
            migrationInfo.setMaster(MigrationManager.this.node.getThisAddress());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!MigrationManager.this.partitionService.isLocalMemberMaster()) {
                return;
            }
            if (this.migrationInfo.getSource() == null && this.migrationInfo.getDestinationCurrentReplicaIndex() > 0 && this.migrationInfo.getDestinationNewReplicaIndex() == 0) {
                throw new AssertionError((Object)("Promotion migrations should be handled by " + RepairPartitionTableTask.class.getSimpleName() + "! -> " + this.migrationInfo));
            }
            Member partitionOwner = this.checkMigrationParticipantsAndGetPartitionOwner();
            if (partitionOwner == null) {
                return;
            }
            long start = System.nanoTime();
            try {
                this.beforeMigration();
                Boolean result = this.executeMigrateOperation(partitionOwner);
                this.processMigrationResult(partitionOwner, result);
            }
            catch (Throwable t) {
                Level level = this.migrationInfo.isValid() ? Level.WARNING : Level.FINE;
                MigrationManager.this.logger.log(level, "Error during " + this.migrationInfo, t);
                this.migrationOperationFailed(partitionOwner);
            }
            finally {
                long elapsed = System.nanoTime() - start;
                MigrationManager.this.stats.recordMigrationTaskTime(elapsed);
                PartitionEventManager partitionEventManager = MigrationManager.this.partitionService.getPartitionEventManager();
                partitionEventManager.sendMigrationEvent(MigrationManager.this.stats.toMigrationState(), this.migrationInfo, TimeUnit.NANOSECONDS.toMillis(elapsed));
            }
        }

        private void beforeMigration() {
            this.migrationInfo.setInitialPartitionVersion(MigrationManager.this.partitionStateManager.getVersion());
            MigrationManager.this.migrationInterceptor.onMigrationStart(MigrationInterceptor.MigrationParticipant.MASTER, this.migrationInfo);
            if (MigrationManager.this.logger.isFineEnabled()) {
                MigrationManager.this.logger.fine("Starting Migration: " + this.migrationInfo);
            }
        }

        private Member checkMigrationParticipantsAndGetPartitionOwner() {
            Member partitionOwner = this.getPartitionOwner();
            if (partitionOwner == null) {
                MigrationManager.this.logger.fine("Partition owner is null. Ignoring " + this.migrationInfo);
                this.triggerRepartitioningAfterMigrationFailure();
                return null;
            }
            if (this.migrationInfo.getSource() != null) {
                PartitionReplica source = this.migrationInfo.getSource();
                if (MigrationManager.this.node.getClusterService().getMember(source.address(), source.uuid()) == null) {
                    MigrationManager.this.logger.fine("Source is not a member anymore. Ignoring " + this.migrationInfo);
                    this.triggerRepartitioningAfterMigrationFailure();
                    return null;
                }
            }
            PartitionReplica destination = this.migrationInfo.getDestination();
            if (MigrationManager.this.node.getClusterService().getMember(destination.address(), destination.uuid()) == null) {
                MigrationManager.this.logger.fine("Destination is not a member anymore. Ignoring " + this.migrationInfo);
                this.triggerRepartitioningAfterMigrationFailure();
                return null;
            }
            return partitionOwner;
        }

        private Member getPartitionOwner() {
            InternalPartitionImpl partition = MigrationManager.this.partitionStateManager.getPartitionImpl(this.migrationInfo.getPartitionId());
            PartitionReplica owner = partition.getOwnerReplicaOrNull();
            if (owner == null) {
                if (this.migrationInfo.isValid()) {
                    MigrationManager.this.logger.severe("Skipping migration! Partition owner is not set! -> partitionId=" + this.migrationInfo.getPartitionId() + ", " + partition + " -VS- " + this.migrationInfo);
                }
                return null;
            }
            return MigrationManager.this.node.getClusterService().getMember(owner.address(), owner.uuid());
        }

        private void processMigrationResult(Member partitionOwner, Boolean result) {
            if (Boolean.TRUE.equals(result)) {
                if (MigrationManager.this.logger.isFineEnabled()) {
                    MigrationManager.this.logger.fine("Finished Migration: " + this.migrationInfo);
                }
                this.migrationOperationSucceeded();
            } else {
                Level level;
                Level level2 = level = MigrationManager.this.nodeEngine.isRunning() && this.migrationInfo.isValid() ? Level.WARNING : Level.FINE;
                if (MigrationManager.this.logger.isLoggable(level)) {
                    MigrationManager.this.logger.log(level, "Migration failed: " + this.migrationInfo);
                }
                this.migrationOperationFailed(partitionOwner);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Boolean executeMigrateOperation(Member fromMember) {
            long start = System.nanoTime();
            List<MigrationInfo> completedMigrations = MigrationManager.this.getCompletedMigrationsCopy();
            int partitionStateVersion = MigrationManager.this.partitionStateManager.getVersion();
            MigrationRequestOperation op = new MigrationRequestOperation(this.migrationInfo, completedMigrations, partitionStateVersion, MigrationManager.this.fragmentedMigrationEnabled);
            InvocationFuture future = MigrationManager.this.nodeEngine.getOperationService().createInvocationBuilder("hz:core:partitionService", (Operation)op, fromMember.getAddress()).setCallTimeout(MigrationManager.this.partitionMigrationTimeout).setTryCount(12).setTryPauseMillis(10000L).invoke();
            try {
                Object response = future.get();
                Boolean bl = (Boolean)MigrationManager.this.nodeEngine.toObject(response);
                return bl;
            }
            catch (Throwable e) {
                Level level;
                Level level2 = level = MigrationManager.this.nodeEngine.isRunning() && this.migrationInfo.isValid() ? Level.WARNING : Level.FINE;
                if (e instanceof ExecutionException && e.getCause() instanceof PartitionStateVersionMismatchException) {
                    level = Level.FINE;
                }
                if (MigrationManager.this.logger.isLoggable(level)) {
                    MigrationManager.this.logger.log(level, "Failed migration from " + fromMember + " for " + this.migrationInfo, e);
                }
            }
            finally {
                MigrationManager.this.stats.recordMigrationOperationTime(System.nanoTime() - start);
            }
            return Boolean.FALSE;
        }

        private void migrationOperationFailed(Member partitionOwner) {
            this.migrationInfo.setStatus(MigrationInfo.MigrationStatus.FAILED);
            MigrationManager.this.migrationInterceptor.onMigrationComplete(MigrationInterceptor.MigrationParticipant.MASTER, this.migrationInfo, false);
            MigrationManager.this.partitionServiceLock.lock();
            try {
                MigrationManager.this.migrationInterceptor.onMigrationRollback(MigrationInterceptor.MigrationParticipant.MASTER, this.migrationInfo);
                MigrationManager.this.scheduleActiveMigrationFinalization(this.migrationInfo);
                int delta = this.migrationInfo.getPartitionVersionIncrement() + 1;
                MigrationManager.this.partitionStateManager.incrementVersion(delta);
                this.migrationInfo.setPartitionVersionIncrement(delta);
                MigrationManager.this.node.getNodeExtension().onPartitionStateChange();
                MigrationManager.this.addCompletedMigration(this.migrationInfo);
                if (!partitionOwner.localMember()) {
                    MigrationManager.this.partitionService.sendPartitionRuntimeState(partitionOwner.getAddress());
                }
                if (!this.migrationInfo.getDestination().isIdentical(MigrationManager.this.node.getLocalMember())) {
                    MigrationManager.this.partitionService.sendPartitionRuntimeState(this.migrationInfo.getDestination().address());
                }
                this.triggerRepartitioningAfterMigrationFailure();
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }

        private void triggerRepartitioningAfterMigrationFailure() {
            MigrationManager.this.partitionServiceLock.lock();
            try {
                MigrationManager.this.pauseMigration();
                MigrationManager.this.triggerControlTask();
                MigrationManager.this.resumeMigrationEventually();
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void migrationOperationSucceeded() {
            MigrationManager.this.migrationInterceptor.onMigrationComplete(MigrationInterceptor.MigrationParticipant.MASTER, this.migrationInfo, true);
            long start = System.nanoTime();
            boolean commitSuccessful = MigrationManager.this.commitMigrationToDestination(this.migrationInfo);
            MigrationManager.this.stats.recordDestinationCommitTime(System.nanoTime() - start);
            MigrationManager.this.partitionServiceLock.lock();
            try {
                if (commitSuccessful) {
                    this.migrationInfo.setStatus(MigrationInfo.MigrationStatus.SUCCESS);
                    MigrationManager.this.migrationInterceptor.onMigrationCommit(MigrationInterceptor.MigrationParticipant.MASTER, this.migrationInfo);
                    assert (this.migrationInfo.getInitialPartitionVersion() == MigrationManager.this.partitionStateManager.getVersion()) : "Migration initial version: " + this.migrationInfo.getInitialPartitionVersion() + ", Partition state version: " + MigrationManager.access$1000(MigrationManager.this).getVersion();
                    InternalPartitionImpl partition = MigrationManager.this.partitionStateManager.getPartitionImpl(this.migrationInfo.getPartitionId());
                    MigrationManager.this.applyMigration(partition, this.migrationInfo);
                    assert (this.migrationInfo.getFinalPartitionVersion() == MigrationManager.this.partitionStateManager.getVersion()) : "Migration final version: " + this.migrationInfo.getFinalPartitionVersion() + ", Partition state version: " + MigrationManager.access$1000(MigrationManager.this).getVersion();
                } else {
                    this.migrationInfo.setStatus(MigrationInfo.MigrationStatus.FAILED);
                    MigrationManager.this.migrationInterceptor.onMigrationRollback(MigrationInterceptor.MigrationParticipant.MASTER, this.migrationInfo);
                    int delta = this.migrationInfo.getPartitionVersionIncrement() + 1;
                    MigrationManager.this.partitionStateManager.incrementVersion(delta);
                    this.migrationInfo.setPartitionVersionIncrement(delta);
                    if (!this.migrationInfo.getDestination().isIdentical(MigrationManager.this.node.getLocalMember())) {
                        MigrationManager.this.partitionService.sendPartitionRuntimeState(this.migrationInfo.getDestination().address());
                    }
                    this.triggerRepartitioningAfterMigrationFailure();
                }
                MigrationManager.this.addCompletedMigration(this.migrationInfo);
                MigrationManager.this.scheduleActiveMigrationFinalization(this.migrationInfo);
                MigrationManager.this.node.getNodeExtension().onPartitionStateChange();
                if (MigrationManager.this.completedMigrations.size() >= 10) {
                    MigrationManager.this.publishCompletedMigrations();
                }
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{migrationInfo=" + this.migrationInfo + '}';
        }
    }

    private class RepartitioningTask
    implements MigrationRunnable {
        private RepartitioningTask() {
        }

        @Override
        public void run() {
            if (!MigrationManager.this.partitionService.isLocalMemberMaster()) {
                return;
            }
            MigrationManager.this.partitionServiceLock.lock();
            try {
                MigrationManager.this.triggerRepartitioningWhenClusterStateAllowsMigration = !MigrationManager.this.node.getClusterService().getClusterState().isMigrationAllowed();
                if (MigrationManager.this.triggerRepartitioningWhenClusterStateAllowsMigration) {
                    if (MigrationManager.this.logger.isFineEnabled()) {
                        MigrationManager.this.logger.fine("Migrations are not allowed yet, repartitioning will be triggered when cluster state allows migrations.");
                    }
                    this.assignCompletelyLostPartitions();
                    return;
                }
                PartitionReplica[][] newState = this.repartition();
                if (newState == null) {
                    return;
                }
                this.processNewPartitionState(newState);
                MigrationManager.this.migrationQueue.add(new ProcessShutdownRequestsTask());
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }

        private PartitionReplica[][] repartition() {
            if (!this.migrationsTasksAllowed()) {
                return null;
            }
            PartitionReplica[][] newState = MigrationManager.this.partitionStateManager.repartition(MigrationManager.this.shutdownRequestedMembers, null);
            if (newState == null) {
                MigrationManager.this.migrationQueue.add(new ProcessShutdownRequestsTask());
                return null;
            }
            if (!this.migrationsTasksAllowed()) {
                return null;
            }
            return newState;
        }

        private void assignCompletelyLostPartitions() {
            if (!MigrationManager.this.node.getClusterService().getClusterState().isPartitionPromotionAllowed()) {
                return;
            }
            MigrationManager.this.logger.fine("Cluster state doesn't allow repartitioning. RepartitioningTask will only assign lost partitions.");
            InternalPartition[] partitions = MigrationManager.this.partitionStateManager.getPartitions();
            PartitionIdSet partitionIds = Arrays.stream(partitions).filter(p -> InternalPartition.replicaIndices().allMatch(i -> p.getReplica(i) == null)).map(IPartition::getPartitionId).collect(Collectors.toCollection(() -> new PartitionIdSet(partitions.length)));
            if (!partitionIds.isEmpty()) {
                PartitionReplica[][] state = MigrationManager.this.partitionStateManager.repartition(MigrationManager.this.shutdownRequestedMembers, partitionIds);
                if (state != null) {
                    MigrationManager.this.logger.warning("Assigning new owners for " + partitionIds.size() + " LOST partitions, when migration is not allowed!");
                    int replicaUpdateCount = (int)partitionIds.stream().flatMap(partitionId -> Arrays.stream(state[partitionId]).filter(Objects::nonNull)).count();
                    MigrationStateImpl[] states = new MigrationStateImpl[]{new MigrationStateImpl(Clock.currentTimeMillis(), replicaUpdateCount, 0, 0L)};
                    PartitionEventManager partitionEventManager = MigrationManager.this.partitionService.getPartitionEventManager();
                    partitionEventManager.sendMigrationProcessStartedEvent(states[0]);
                    partitionIds.intIterator().forEachRemaining(partitionId -> {
                        InternalPartitionImpl partition = MigrationManager.this.partitionStateManager.getPartitionImpl(partitionId);
                        PartitionReplica[] replicas = state[partitionId];
                        partition.setReplicas(replicas);
                        InternalPartition.replicaIndices().filter(i -> replicas[i] != null).forEach(i -> {
                            MigrationInfo migration = new MigrationInfo(partitionId, null, replicas[i], -1, -1, -1, i).setStatus(MigrationInfo.MigrationStatus.SUCCESS);
                            states[0] = states[0].onComplete(0L);
                            partitionEventManager.sendMigrationEvent(states[0], migration, 0L);
                        });
                    });
                    partitionEventManager.sendMigrationProcessCompletedEvent(states[0]);
                    MigrationManager.this.node.getNodeExtension().onPartitionStateChange();
                } else {
                    MigrationManager.this.logger.warning("Unable to assign LOST partitions");
                }
            }
        }

        private void processNewPartitionState(PartitionReplica[][] newState) {
            int migrationCount = 0;
            ArrayList<Queue<MigrationInfo>> migrations = new ArrayList<Queue<MigrationInfo>>(newState.length);
            Int2ObjectHashMap<PartitionReplica> lostPartitions = new Int2ObjectHashMap<PartitionReplica>();
            for (int partitionId2 = 0; partitionId2 < newState.length; ++partitionId2) {
                InternalPartitionImpl currentPartition = MigrationManager.this.partitionStateManager.getPartitionImpl(partitionId2);
                Object[] currentReplicas = currentPartition.getReplicas();
                Object[] newReplicas = newState[partitionId2];
                MigrationCollector migrationCollector = new MigrationCollector(currentPartition);
                if (MigrationManager.this.logger.isFinestEnabled()) {
                    MigrationManager.this.logger.finest("Planning migrations for partitionId=" + partitionId2 + ". Current replicas: " + Arrays.toString(currentReplicas) + ", New replicas: " + Arrays.toString(newReplicas));
                }
                MigrationManager.this.migrationPlanner.planMigrations(partitionId2, (PartitionReplica[])currentReplicas, (PartitionReplica[])newReplicas, migrationCollector);
                MigrationManager.this.migrationPlanner.prioritizeCopiesAndShiftUps(migrationCollector.migrations);
                if (migrationCollector.lostPartitionDestination != null) {
                    lostPartitions.put(partitionId2, migrationCollector.lostPartitionDestination);
                }
                migrations.add(migrationCollector.migrations);
                migrationCount += migrationCollector.migrations.size();
            }
            MigrationManager.this.stats.markNewRepartition(migrationCount += lostPartitions.size());
            if (migrationCount > 0) {
                MigrationManager.this.partitionService.getPartitionEventManager().sendMigrationProcessStartedEvent(MigrationManager.this.stats.toMigrationState());
            }
            if (!lostPartitions.isEmpty()) {
                MigrationManager.this.logger.warning("Assigning new owners for " + lostPartitions.size() + " LOST partitions!");
                lostPartitions.forEach((partitionId, destination) -> {
                    InternalPartitionImpl partition = MigrationManager.this.partitionStateManager.getPartitionImpl((int)partitionId);
                    this.assignLostPartitionOwner(partition, (PartitionReplica)destination);
                });
                MigrationManager.this.node.getNodeExtension().onPartitionStateChange();
            }
            MigrationManager.this.partitionService.publishPartitionRuntimeState();
            if (migrationCount > 0) {
                this.scheduleMigrations(migrations);
                MigrationManager.this.migrationQueue.add(new PublishCompletedMigrationsTask());
            }
            this.logMigrationStatistics(migrationCount);
        }

        private void scheduleMigrations(List<Queue<MigrationInfo>> migrations) {
            boolean migrationScheduled;
            do {
                migrationScheduled = false;
                for (Queue<MigrationInfo> queue : migrations) {
                    MigrationInfo migration = queue.poll();
                    if (migration == null) continue;
                    migrationScheduled = true;
                    MigrationManager.this.scheduleMigration(migration);
                }
            } while (migrationScheduled);
        }

        private void logMigrationStatistics(int migrationCount) {
            if (migrationCount > 0) {
                MigrationManager.this.logger.info("Repartitioning cluster data. Migration tasks count: " + migrationCount);
            } else {
                MigrationManager.this.logger.info("Partition balance is ok, no need to repartition.");
            }
        }

        private void assignLostPartitionOwner(InternalPartitionImpl partition, PartitionReplica newOwner) {
            partition.setReplica(0, newOwner);
            MigrationManager.this.stats.incrementCompletedMigrations();
            MigrationInfo migrationInfo = new MigrationInfo(partition.getPartitionId(), null, newOwner, -1, -1, -1, 0);
            migrationInfo.setStatus(MigrationInfo.MigrationStatus.SUCCESS);
            MigrationManager.this.partitionService.getPartitionEventManager().sendMigrationEvent(MigrationManager.this.stats.toMigrationState(), migrationInfo, 0L);
        }

        private boolean migrationsTasksAllowed() {
            boolean hasMigrationTasks;
            boolean migrationTasksAllowed = MigrationManager.this.areMigrationTasksAllowed();
            boolean bl = hasMigrationTasks = MigrationManager.this.migrationQueue.migrationTaskCount() > 1;
            if (migrationTasksAllowed && !hasMigrationTasks) {
                return true;
            }
            MigrationManager.this.triggerControlTask();
            return false;
        }

        private class MigrationCollector
        implements MigrationPlanner.MigrationDecisionCallback {
            private final InternalPartitionImpl partition;
            private final LinkedList<MigrationInfo> migrations = new LinkedList();
            private PartitionReplica lostPartitionDestination;

            MigrationCollector(InternalPartitionImpl partition) {
                this.partition = partition;
            }

            @Override
            public void migrate(PartitionReplica source, int sourceCurrentReplicaIndex, int sourceNewReplicaIndex, PartitionReplica destination, int destinationCurrentReplicaIndex, int destinationNewReplicaIndex) {
                int partitionId = this.partition.getPartitionId();
                if (MigrationManager.this.logger.isFineEnabled()) {
                    MigrationManager.this.logger.fine("Planned migration -> partitionId=" + partitionId + ", source=" + source + ", sourceCurrentReplicaIndex=" + sourceCurrentReplicaIndex + ", sourceNewReplicaIndex=" + sourceNewReplicaIndex + ", destination=" + destination + ", destinationCurrentReplicaIndex=" + destinationCurrentReplicaIndex + ", destinationNewReplicaIndex=" + destinationNewReplicaIndex);
                }
                if (source == null && destinationCurrentReplicaIndex == -1 && destinationNewReplicaIndex == 0) {
                    assert (destination != null) : "partitionId=" + partitionId + " destination is null";
                    assert (sourceCurrentReplicaIndex == -1) : "partitionId=" + partitionId + " invalid index: " + sourceCurrentReplicaIndex;
                    assert (sourceNewReplicaIndex == -1) : "partitionId=" + partitionId + " invalid index: " + sourceNewReplicaIndex;
                    assert (this.lostPartitionDestination == null) : "Current: " + this.lostPartitionDestination + ", New: " + destination;
                    this.lostPartitionDestination = destination;
                } else if (destination == null && sourceNewReplicaIndex == -1) {
                    assert (source != null) : "partitionId=" + partitionId + " source is null";
                    assert (sourceCurrentReplicaIndex != -1) : "partitionId=" + partitionId + " invalid index: " + sourceCurrentReplicaIndex;
                    assert (sourceCurrentReplicaIndex != 0) : "partitionId=" + partitionId + " invalid index: " + sourceCurrentReplicaIndex;
                    PartitionReplica currentSource = this.partition.getReplica(sourceCurrentReplicaIndex);
                    assert (source.equals(currentSource)) : "partitionId=" + partitionId + " current source=" + source + " is different than expected source=" + source;
                    this.partition.setReplica(sourceCurrentReplicaIndex, null);
                } else {
                    MigrationInfo migration = new MigrationInfo(partitionId, source, destination, sourceCurrentReplicaIndex, sourceNewReplicaIndex, destinationCurrentReplicaIndex, destinationNewReplicaIndex);
                    this.migrations.add(migration);
                }
            }
        }
    }
}

