/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.operation;

import com.hazelcast.internal.management.operation.ScriptExecutorOperation;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.AbstractLocalOperation;
import java.util.concurrent.Future;

public class RunScriptOperation
extends AbstractLocalOperation {
    private final String engine;
    private final String script;

    public RunScriptOperation(String engine, String script) {
        this.engine = engine;
        this.script = script;
    }

    @Override
    public void run() {
        ILogger logger = this.getNodeEngine().getLogger(this.getClass());
        ExecutionService executionService = this.getNodeEngine().getExecutionService();
        ScriptExecutorOperation legacyOperation = new ScriptExecutorOperation(this.engine, this.script);
        legacyOperation.setNodeEngine(this.getNodeEngine());
        Future<Object> future = executionService.submit("hz:mc", () -> {
            legacyOperation.run();
            return legacyOperation.getResponse();
        });
        executionService.asCompletableFuture(future).whenComplete(ExceptionUtil.withTryCatch(logger, (result, error) -> this.sendResponse(error != null ? ExceptionUtil.peel(error) : result)));
    }

    @Override
    public final Object getResponse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getServiceName() {
        return "hz:core:managementCenterService";
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }
}

