/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.operation;

import com.hazelcast.internal.management.ConsoleCommandHandler;
import com.hazelcast.internal.management.ManagementCenterService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.AbstractLocalOperation;
import java.util.concurrent.Future;

public class RunConsoleCommandOperation
extends AbstractLocalOperation {
    private final String command;
    private final String namespace;

    public RunConsoleCommandOperation(String command, String namespace) {
        this.command = command;
        this.namespace = namespace;
    }

    @Override
    public void run() throws Exception {
        ILogger logger = this.getNodeEngine().getLogger(this.getClass());
        ManagementCenterService mcService = ((NodeEngineImpl)this.getNodeEngine()).getManagementCenterService();
        ExecutionService executionService = this.getNodeEngine().getExecutionService();
        Future<String> future = executionService.submit("hz:mc", () -> {
            ConsoleCommandHandler handler = mcService.getCommandHandler();
            try {
                String ns = this.namespace;
                String cmd = this.command;
                if (!StringUtil.isNullOrEmpty(ns)) {
                    cmd = ns + "__" + cmd;
                }
                return handler.handleCommand(cmd);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
        });
        executionService.asCompletableFuture(future).whenComplete(ExceptionUtil.withTryCatch(logger, (output, error) -> this.sendResponse(error != null ? ExceptionUtil.peel(error) : output)));
    }

    @Override
    public final Object getResponse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getServiceName() {
        return "hz:core:managementCenterService";
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }
}

