/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.dto;

import com.hazelcast.config.CustomWanPublisherConfig;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.util.JsonUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.json.internal.JsonSerializable;
import java.util.Map;
import java.util.function.Consumer;

public class CustomWanPublisherConfigDTO
implements JsonSerializable {
    private CustomWanPublisherConfig config;

    public CustomWanPublisherConfigDTO() {
    }

    public CustomWanPublisherConfigDTO(CustomWanPublisherConfig config) {
        this.config = config;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("publisherId", this.config.getPublisherId());
        root.add("className", this.config.getClassName());
        if (!MapUtil.isNullOrEmpty(this.config.getProperties())) {
            root.add("properties", JsonUtil.toJsonObject(this.config.getProperties()));
        }
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.config = new CustomWanPublisherConfig();
        this.consumeIfExists(json, "publisherId", v -> this.config.setPublisherId(v.asString()));
        this.consumeIfExists(json, "className", v -> this.config.setClassName(v.asString()));
        this.config.setProperties((Map)JsonUtil.fromJsonObject((JsonObject)json.get("properties")));
    }

    private void consumeIfExists(JsonObject json, String attribute, Consumer<JsonValue> valueConsumer) {
        JsonValue value = json.get(attribute);
        if (value != null && !value.isNull()) {
            valueConsumer.accept(value);
        }
    }

    public CustomWanPublisherConfig getConfig() {
        return this.config;
    }
}

