/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.jmx;

import com.hazelcast.internal.jmx.HazelcastMBean;
import com.hazelcast.internal.jmx.ManagedAnnotation;
import com.hazelcast.internal.jmx.ManagedDescription;
import com.hazelcast.internal.jmx.ManagementService;
import com.hazelcast.internal.monitor.LocalWanPublisherStats;
import com.hazelcast.internal.monitor.LocalWanStats;
import com.hazelcast.wan.impl.WanReplicationService;
import java.util.Map;

@ManagedDescription(value="WanReplicationPublisher")
public class WanPublisherMBean
extends HazelcastMBean<WanReplicationService> {
    private final String wanReplicationName;
    private final String wanPublisherId;

    public WanPublisherMBean(WanReplicationService wanReplicationService, String wanReplicationName, String wanPublisherId, ManagementService service) {
        super(wanReplicationService, service);
        this.wanReplicationName = wanReplicationName;
        this.wanPublisherId = wanPublisherId;
        this.objectName = service.createObjectName("WanReplicationPublisher", wanReplicationName + "." + wanPublisherId);
    }

    @ManagedAnnotation(value="state")
    @ManagedDescription(value="State of the WAN replication publisher")
    public String getState() {
        Map wanStats = ((WanReplicationService)this.managedObject).getStats();
        if (wanStats == null) {
            return "";
        }
        LocalWanStats wanReplicationStats = (LocalWanStats)wanStats.get(this.wanReplicationName);
        Map<String, LocalWanPublisherStats> wanDelegatingPublisherStats = wanReplicationStats.getLocalWanPublisherStats();
        LocalWanPublisherStats wanPublisherStats = wanDelegatingPublisherStats.get(this.wanPublisherId);
        return wanPublisherStats.getPublisherState().name();
    }
}

