/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CollectionConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EndpointConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.ServerSocketEndpointConfig;
import com.hazelcast.config.WanBatchReplicationPublisherConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.cp.CPSubsystemConfig;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.config.MergePolicyValidator;
import com.hazelcast.internal.util.MutableInteger;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.eviction.EvictionPolicyComparator;
import com.hazelcast.spi.merge.SplitBrainMergePolicyProvider;
import com.hazelcast.spi.merge.SplitBrainMergeTypeProvider;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;

public final class ConfigValidator {
    public static final EnumSet<EvictionPolicy> COMMONLY_SUPPORTED_EVICTION_POLICIES = EnumSet.of(EvictionPolicy.LRU, EvictionPolicy.LFU);
    private static final EnumSet<MaxSizePolicy> NEAR_CACHE_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES = EnumSet.of(MaxSizePolicy.ENTRY_COUNT);
    private static final EnumSet<EvictionPolicy> MAP_SUPPORTED_EVICTION_POLICIES = EnumSet.of(EvictionPolicy.LRU, EvictionPolicy.LFU, EvictionPolicy.RANDOM, EvictionPolicy.NONE);
    private static final EnumSet<MaxSizePolicy> MAP_SUPPORTED_NATIVE_MAX_SIZE_POLICIES = EnumSet.of(MaxSizePolicy.PER_NODE, new MaxSizePolicy[]{MaxSizePolicy.PER_PARTITION, MaxSizePolicy.USED_NATIVE_MEMORY_PERCENTAGE, MaxSizePolicy.FREE_NATIVE_MEMORY_PERCENTAGE, MaxSizePolicy.USED_NATIVE_MEMORY_SIZE, MaxSizePolicy.FREE_NATIVE_MEMORY_SIZE});
    private static final EnumSet<MaxSizePolicy> MAP_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES = EnumSet.of(MaxSizePolicy.PER_NODE, new MaxSizePolicy[]{MaxSizePolicy.PER_PARTITION, MaxSizePolicy.USED_HEAP_SIZE, MaxSizePolicy.USED_HEAP_PERCENTAGE, MaxSizePolicy.FREE_HEAP_SIZE, MaxSizePolicy.FREE_HEAP_PERCENTAGE});
    private static final EnumSet<MaxSizePolicy> CACHE_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES = EnumSet.of(MaxSizePolicy.ENTRY_COUNT);
    private static final EnumSet<MaxSizePolicy> CACHE_SUPPORTED_NATIVE_MAX_SIZE_POLICIES = EnumSet.of(MaxSizePolicy.USED_NATIVE_MEMORY_PERCENTAGE, MaxSizePolicy.FREE_NATIVE_MEMORY_PERCENTAGE, MaxSizePolicy.USED_NATIVE_MEMORY_SIZE, MaxSizePolicy.FREE_NATIVE_MEMORY_SIZE);
    private static final ILogger LOGGER = Logger.getLogger(ConfigValidator.class);

    private ConfigValidator() {
    }

    public static void checkMapConfig(MapConfig mapConfig, NativeMemoryConfig nativeMemoryConfig, SplitBrainMergePolicyProvider mergePolicyProvider, HazelcastProperties properties) {
        ConfigValidator.checkNotNativeWhenOpenSource(mapConfig.getInMemoryFormat());
        if (BuildInfoProvider.getBuildInfo().isEnterprise()) {
            ConfigValidator.checkMapNativeConfig(mapConfig, nativeMemoryConfig);
            ConfigValidator.checkHotRestartSpecificConfig(mapConfig, properties);
        }
        ConfigValidator.checkMapEvictionConfig(mapConfig.getEvictionConfig());
        ConfigValidator.checkMapMaxSizePolicyPerInMemoryFormat(mapConfig);
        MergePolicyValidator.checkMapMergePolicy(mapConfig, mergePolicyProvider);
    }

    static void checkMapMaxSizePolicyPerInMemoryFormat(MapConfig mapConfig) {
        MaxSizePolicy maxSizePolicy = mapConfig.getEvictionConfig().getMaxSizePolicy();
        InMemoryFormat inMemoryFormat = mapConfig.getInMemoryFormat();
        if (inMemoryFormat == InMemoryFormat.NATIVE) {
            if (!MAP_SUPPORTED_NATIVE_MAX_SIZE_POLICIES.contains((Object)maxSizePolicy)) {
                ConfigValidator.throwNotMatchingMaxSizePolicy(inMemoryFormat, maxSizePolicy, MAP_SUPPORTED_NATIVE_MAX_SIZE_POLICIES);
            }
        } else if (!MAP_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES.contains((Object)maxSizePolicy)) {
            ConfigValidator.throwNotMatchingMaxSizePolicy(inMemoryFormat, maxSizePolicy, MAP_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES);
        }
    }

    private static void throwNotMatchingMaxSizePolicy(InMemoryFormat inMemoryFormat, MaxSizePolicy maxSizePolicy, EnumSet<MaxSizePolicy> policies) {
        String msg = "%s is not a valid max size policy to use with in memory format %s. Please select an appropriate one from list: %s";
        throw new InvalidConfigurationException(String.format(msg, new Object[]{maxSizePolicy, inMemoryFormat, policies}));
    }

    public static void checkMapEvictionConfig(EvictionConfig evictionConfig) {
        EvictionPolicyComparator comparator = evictionConfig.getComparator();
        String comparatorClassName = evictionConfig.getComparatorClassName();
        EvictionPolicy evictionPolicy = evictionConfig.getEvictionPolicy();
        ConfigValidator.checkComparatorDefinedOnlyOnce(comparatorClassName, comparator);
        ConfigValidator.checkEvictionPolicyConfiguredOnlyOnce(evictionPolicy, comparatorClassName, comparator, MapConfig.DEFAULT_EVICTION_POLICY);
        ConfigValidator.checkMapMaxSizePolicyConfig(evictionConfig.getMaxSizePolicy());
    }

    public static void checkMapEvictionConfig(MaxSizePolicy maxSizePolicy, EvictionPolicy evictionPolicy, String comparatorClassName, Object comparator) {
        ConfigValidator.checkEvictionConfig(evictionPolicy, comparatorClassName, comparator, MAP_SUPPORTED_EVICTION_POLICIES);
        ConfigValidator.checkMapMaxSizePolicyConfig(maxSizePolicy);
    }

    static void checkMapMaxSizePolicyConfig(MaxSizePolicy maxSizePolicy) {
        if (!MAP_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES.contains((Object)maxSizePolicy) && !MAP_SUPPORTED_NATIVE_MAX_SIZE_POLICIES.contains((Object)maxSizePolicy)) {
            EnumSet<MaxSizePolicy> allMaxSizePolicies = EnumSet.copyOf(MAP_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES);
            allMaxSizePolicies.addAll(MAP_SUPPORTED_NATIVE_MAX_SIZE_POLICIES);
            String msg = String.format("IMap eviction config doesn't support max size policy `%s`. Please select a valid one: %s.", new Object[]{maxSizePolicy, allMaxSizePolicies});
            throw new InvalidConfigurationException(msg);
        }
    }

    private static void checkMapNativeConfig(MapConfig mapConfig, NativeMemoryConfig nativeMemoryConfig) {
        if (InMemoryFormat.NATIVE != mapConfig.getInMemoryFormat()) {
            return;
        }
        Preconditions.checkTrue(nativeMemoryConfig.isEnabled(), String.format("Enable native memory config to use NATIVE in-memory-format for the map [%s]", mapConfig.getName()));
        ConfigValidator.checkMapNativeMaxSizePolicy(mapConfig);
    }

    private static void checkMapNativeMaxSizePolicy(MapConfig mapConfig) {
        MaxSizePolicy maxSizePolicy = mapConfig.getEvictionConfig().getMaxSizePolicy();
        if (!MAP_SUPPORTED_NATIVE_MAX_SIZE_POLICIES.contains((Object)maxSizePolicy)) {
            throw new InvalidConfigurationException("Maximum size policy " + (Object)((Object)maxSizePolicy) + " cannot be used with NATIVE in memory format backed Map. Supported maximum size policies are: " + MAP_SUPPORTED_NATIVE_MAX_SIZE_POLICIES);
        }
    }

    private static void checkHotRestartSpecificConfig(MapConfig mapConfig, HazelcastProperties properties) {
        HotRestartConfig hotRestartConfig = mapConfig.getHotRestartConfig();
        if (hotRestartConfig == null || !hotRestartConfig.isEnabled()) {
            return;
        }
        int hotRestartMinFreeNativeMemoryPercentage = properties.getInteger(ClusterProperty.HOT_RESTART_FREE_NATIVE_MEMORY_PERCENTAGE);
        EvictionConfig evictionConfig = mapConfig.getEvictionConfig();
        MaxSizePolicy maximumSizePolicy = evictionConfig.getMaxSizePolicy();
        int localSizeConfig = evictionConfig.getSize();
        if (MaxSizePolicy.FREE_NATIVE_MEMORY_PERCENTAGE == maximumSizePolicy && localSizeConfig < hotRestartMinFreeNativeMemoryPercentage) {
            throw new InvalidConfigurationException(String.format("There is a global limit on the minimum free native memory, configurable by the system property %s, whose value is currently %d percent. The map %s has Hot Restart enabled, but is configured with %d percent, which is lower than the allowed minimum.", ClusterProperty.HOT_RESTART_FREE_NATIVE_MEMORY_PERCENTAGE.getName(), hotRestartMinFreeNativeMemoryPercentage, mapConfig.getName(), localSizeConfig));
        }
    }

    public static void checkAdvancedNetworkConfig(Config config) {
        if (!config.getAdvancedNetworkConfig().isEnabled()) {
            return;
        }
        EnumMap<ProtocolType, MutableInteger> serverSocketsPerProtocolType = new EnumMap<ProtocolType, MutableInteger>(ProtocolType.class);
        for (ProtocolType protocolType : ProtocolType.values()) {
            serverSocketsPerProtocolType.put(protocolType, new MutableInteger());
        }
        Map<EndpointQualifier, EndpointConfig> endpointConfigs = config.getAdvancedNetworkConfig().getEndpointConfigs();
        for (EndpointConfig endpointConfig : endpointConfigs.values()) {
            if (!(endpointConfig instanceof ServerSocketEndpointConfig)) continue;
            ((MutableInteger)serverSocketsPerProtocolType.get((Object)endpointConfig.getProtocolType())).getAndInc();
        }
        ProtocolType[] protocolTypeArray = ProtocolType.values();
        int endpointConfig = protocolTypeArray.length;
        for (int i = 0; i < endpointConfig; ++i) {
            ProtocolType protocolType;
            int serverSocketCount = ((MutableInteger)serverSocketsPerProtocolType.get((Object)((Object)protocolType))).value;
            protocolType = protocolTypeArray[i];
            if (serverSocketCount <= protocolType.getServerSocketCardinality()) continue;
            throw new InvalidConfigurationException(String.format("Protocol type %s allows definition of up to %d server sockets but %d were configured", new Object[]{protocolType, protocolType.getServerSocketCardinality(), serverSocketCount}));
        }
        if (((MutableInteger)serverSocketsPerProtocolType.get((Object)((Object)ProtocolType.MEMBER))).value != 1) {
            throw new InvalidConfigurationException("A member-server-socket-endpoint configuration is required for the cluster to form.");
        }
        for (WanReplicationConfig wanReplicationConfig : config.getWanReplicationConfigs().values()) {
            for (WanBatchReplicationPublisherConfig wanPublisherConfig : wanReplicationConfig.getBatchPublisherConfigs()) {
                EndpointQualifier qualifier;
                if (wanPublisherConfig.getEndpoint() == null || endpointConfigs.get(qualifier = EndpointQualifier.resolve(ProtocolType.WAN, wanPublisherConfig.getEndpoint())) != null) continue;
                throw new InvalidConfigurationException(String.format("WAN publisher config for cluster name '%s' requires an wan-endpoint config with identifier '%s' but none was found", wanPublisherConfig.getClusterName(), wanPublisherConfig.getEndpoint()));
            }
        }
    }

    public static void checkNearCacheConfig(String mapName, NearCacheConfig nearCacheConfig, NativeMemoryConfig nativeMemoryConfig, boolean isClient) {
        ConfigValidator.checkNotNativeWhenOpenSource(nearCacheConfig.getInMemoryFormat());
        ConfigValidator.checkLocalUpdatePolicy(mapName, nearCacheConfig.getLocalUpdatePolicy());
        EvictionConfig evictionConfig = nearCacheConfig.getEvictionConfig();
        ConfigValidator.checkNearCacheEvictionConfig(evictionConfig.getEvictionPolicy(), evictionConfig.getComparatorClassName(), evictionConfig.getComparator());
        ConfigValidator.checkOnHeapNearCacheMaxSizePolicy(nearCacheConfig);
        ConfigValidator.checkNearCacheNativeMemoryConfig(nearCacheConfig.getInMemoryFormat(), nativeMemoryConfig, BuildInfoProvider.getBuildInfo().isEnterprise());
        if (isClient && nearCacheConfig.isCacheLocalEntries()) {
            throw new InvalidConfigurationException("The Near Cache option `cache-local-entries` is not supported in client configurations.");
        }
        ConfigValidator.checkPreloaderConfig(nearCacheConfig, isClient);
    }

    private static void checkLocalUpdatePolicy(String mapName, NearCacheConfig.LocalUpdatePolicy localUpdatePolicy) {
        if (localUpdatePolicy != NearCacheConfig.LocalUpdatePolicy.INVALIDATE) {
            throw new InvalidConfigurationException(String.format("Wrong `local-update-policy` option is selected for `%s` map Near Cache. Only `%s` option is supported but found `%s`", new Object[]{mapName, NearCacheConfig.LocalUpdatePolicy.INVALIDATE, localUpdatePolicy}));
        }
    }

    public static void checkCacheEvictionConfig(EvictionConfig evictionConfig) {
        ConfigValidator.checkEvictionConfig(evictionConfig, COMMONLY_SUPPORTED_EVICTION_POLICIES);
    }

    public static void checkEvictionConfig(EvictionConfig evictionConfig, EnumSet<EvictionPolicy> supportedEvictionPolicies) {
        if (evictionConfig == null) {
            throw new InvalidConfigurationException("Eviction config cannot be null!");
        }
        EvictionPolicy evictionPolicy = evictionConfig.getEvictionPolicy();
        String comparatorClassName = evictionConfig.getComparatorClassName();
        EvictionPolicyComparator comparator = evictionConfig.getComparator();
        ConfigValidator.checkEvictionConfig(evictionPolicy, comparatorClassName, comparator, supportedEvictionPolicies);
    }

    private static void checkOnHeapNearCacheMaxSizePolicy(NearCacheConfig nearCacheConfig) {
        InMemoryFormat inMemoryFormat = nearCacheConfig.getInMemoryFormat();
        if (inMemoryFormat == InMemoryFormat.NATIVE) {
            return;
        }
        MaxSizePolicy maxSizePolicy = nearCacheConfig.getEvictionConfig().getMaxSizePolicy();
        if (!NEAR_CACHE_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES.contains((Object)maxSizePolicy)) {
            throw new InvalidConfigurationException(String.format("Near Cache maximum size policy %s cannot be used with %s storage. Supported maximum size policies are: %s", new Object[]{maxSizePolicy, inMemoryFormat, NEAR_CACHE_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES}));
        }
    }

    static void checkNearCacheNativeMemoryConfig(InMemoryFormat inMemoryFormat, NativeMemoryConfig nativeMemoryConfig, boolean isEnterprise) {
        if (!isEnterprise) {
            return;
        }
        if (inMemoryFormat != InMemoryFormat.NATIVE) {
            return;
        }
        if (nativeMemoryConfig != null && nativeMemoryConfig.isEnabled()) {
            return;
        }
        throw new InvalidConfigurationException("Enable native memory config to use NATIVE in-memory-format for Near Cache");
    }

    public static void checkEvictionConfig(EvictionPolicy evictionPolicy, String comparatorClassName, Object comparator, EnumSet<EvictionPolicy> supportedEvictionPolicies) {
        ConfigValidator.checkComparatorDefinedOnlyOnce(comparatorClassName, comparator);
        if (!supportedEvictionPolicies.contains((Object)evictionPolicy)) {
            if (StringUtil.isNullOrEmpty(comparatorClassName) && comparator == null) {
                String msg = String.format("Eviction policy `%s` is not supported. Either you can provide a custom one or you can use a supported one: %s.", new Object[]{evictionPolicy, supportedEvictionPolicies});
                throw new InvalidConfigurationException(msg);
            }
        } else {
            ConfigValidator.checkEvictionPolicyConfiguredOnlyOnce(evictionPolicy, comparatorClassName, comparator, EvictionConfig.DEFAULT_EVICTION_POLICY);
        }
    }

    private static void checkComparatorDefinedOnlyOnce(String comparatorClassName, Object comparator) {
        if (comparatorClassName != null && comparator != null) {
            throw new InvalidConfigurationException("Only one of the `comparator class name` and `comparator` can be configured in the eviction configuration!");
        }
    }

    public static void checkNearCacheEvictionConfig(EvictionPolicy evictionPolicy, String comparatorClassName, Object comparator) {
        ConfigValidator.checkComparatorDefinedOnlyOnce(comparatorClassName, comparator);
        ConfigValidator.checkEvictionPolicyConfiguredOnlyOnce(evictionPolicy, comparatorClassName, comparator, EvictionConfig.DEFAULT_EVICTION_POLICY);
    }

    private static void checkEvictionPolicyConfiguredOnlyOnce(EvictionPolicy evictionPolicy, String comparatorClassName, Object comparator, EvictionPolicy defaultEvictionPolicy) {
        if (evictionPolicy != defaultEvictionPolicy) {
            if (!StringUtil.isNullOrEmpty(comparatorClassName)) {
                throw new InvalidConfigurationException("Only one of the `eviction policy` and `comparator class name` can be configured!");
            }
            if (comparator != null) {
                throw new InvalidConfigurationException("Only one of the `eviction policy` and `comparator` can be configured!");
            }
        }
    }

    public static void checkCacheConfig(CacheSimpleConfig cacheSimpleConfig, SplitBrainMergePolicyProvider mergePolicyProvider) {
        ConfigValidator.checkCacheConfig(cacheSimpleConfig.getInMemoryFormat(), cacheSimpleConfig.getEvictionConfig(), cacheSimpleConfig.getMergePolicyConfig().getPolicy(), cacheSimpleConfig, mergePolicyProvider, COMMONLY_SUPPORTED_EVICTION_POLICIES);
    }

    public static void checkCacheConfig(CacheConfig cacheConfig, SplitBrainMergePolicyProvider mergePolicyProvider) {
        ConfigValidator.checkCacheConfig(cacheConfig.getInMemoryFormat(), cacheConfig.getEvictionConfig(), cacheConfig.getMergePolicyConfig().getPolicy(), cacheConfig, mergePolicyProvider, COMMONLY_SUPPORTED_EVICTION_POLICIES);
    }

    public static void checkCacheConfig(InMemoryFormat inMemoryFormat, EvictionConfig evictionConfig, String mergePolicyClassname, SplitBrainMergeTypeProvider mergeTypeProvider, SplitBrainMergePolicyProvider mergePolicyProvider, EnumSet<EvictionPolicy> supportedEvictionPolicies) {
        try {
            ConfigValidator.checkNotNativeWhenOpenSource(inMemoryFormat);
            ConfigValidator.checkEvictionConfig(evictionConfig, supportedEvictionPolicies);
            ConfigValidator.checkCacheMaxSizePolicy(evictionConfig.getMaxSizePolicy(), inMemoryFormat);
            MergePolicyValidator.checkMergeTypeProviderHasRequiredTypes(mergeTypeProvider, mergePolicyProvider, mergePolicyClassname);
        }
        catch (InvalidConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    static void checkCacheMaxSizePolicy(MaxSizePolicy maxSizePolicy, InMemoryFormat inMemoryFormat) {
        if (inMemoryFormat == InMemoryFormat.NATIVE) {
            if (!CACHE_SUPPORTED_NATIVE_MAX_SIZE_POLICIES.contains((Object)maxSizePolicy)) {
                throw new IllegalArgumentException("Maximum size policy " + (Object)((Object)maxSizePolicy) + " cannot be used with NATIVE in memory format backed Cache. Supported maximum size policies are: " + CACHE_SUPPORTED_NATIVE_MAX_SIZE_POLICIES);
            }
        } else if (!CACHE_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES.contains((Object)maxSizePolicy)) {
            String msg = String.format("Cache eviction config doesn't support max size policy `%s`. Please select a valid one: %s.", new Object[]{maxSizePolicy, CACHE_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES});
            throw new IllegalArgumentException(msg);
        }
    }

    public static void checkReplicatedMapConfig(ReplicatedMapConfig replicatedMapConfig, SplitBrainMergePolicyProvider mergePolicyProvider) {
        MergePolicyValidator.checkMergeTypeProviderHasRequiredTypes(replicatedMapConfig, mergePolicyProvider, replicatedMapConfig.getMergePolicyConfig().getPolicy());
    }

    public static void checkMultiMapConfig(MultiMapConfig multiMapConfig, SplitBrainMergePolicyProvider mergePolicyProvider) {
        MergePolicyValidator.checkMergeTypeProviderHasRequiredTypes(multiMapConfig, mergePolicyProvider, multiMapConfig.getMergePolicyConfig().getPolicy());
    }

    public static void checkQueueConfig(QueueConfig queueConfig, SplitBrainMergePolicyProvider mergePolicyProvider) {
        MergePolicyValidator.checkMergeTypeProviderHasRequiredTypes(queueConfig, mergePolicyProvider, queueConfig.getMergePolicyConfig().getPolicy());
    }

    public static void checkCollectionConfig(CollectionConfig collectionConfig, SplitBrainMergePolicyProvider mergePolicyProvider) {
        MergePolicyValidator.checkMergeTypeProviderHasRequiredTypes(collectionConfig, mergePolicyProvider, collectionConfig.getMergePolicyConfig().getPolicy());
    }

    public static void checkRingbufferConfig(RingbufferConfig ringbufferConfig, SplitBrainMergePolicyProvider mergePolicyProvider) {
        MergePolicyValidator.checkMergeTypeProviderHasRequiredTypes(ringbufferConfig, mergePolicyProvider, ringbufferConfig.getMergePolicyConfig().getPolicy());
    }

    public static void checkScheduledExecutorConfig(ScheduledExecutorConfig scheduledExecutorConfig, SplitBrainMergePolicyProvider mergePolicyProvider) {
        String mergePolicyClassName = scheduledExecutorConfig.getMergePolicyConfig().getPolicy();
        MergePolicyValidator.checkMergeTypeProviderHasRequiredTypes(scheduledExecutorConfig, mergePolicyProvider, mergePolicyClassName);
    }

    public static void checkCPSubsystemConfig(CPSubsystemConfig config) {
        Preconditions.checkTrue(config.getGroupSize() <= config.getCPMemberCount(), "The group size parameter cannot be bigger than the number of the CP member count");
        Preconditions.checkTrue(config.getSessionTimeToLiveSeconds() > config.getSessionHeartbeatIntervalSeconds(), "Session TTL must be greater than session heartbeat interval!");
        Preconditions.checkTrue(config.getMissingCPMemberAutoRemovalSeconds() == 0 || config.getSessionTimeToLiveSeconds() <= config.getMissingCPMemberAutoRemovalSeconds(), "Session TTL must be smaller than or equal to missing CP member auto-removal seconds!");
        Preconditions.checkTrue(!config.isPersistenceEnabled() || config.getCPMemberCount() > 0, "CP member count must be greater than 0 to use CP persistence feature!");
    }

    private static void checkNotNativeWhenOpenSource(InMemoryFormat inMemoryFormat) {
        if (inMemoryFormat == InMemoryFormat.NATIVE && !BuildInfoProvider.getBuildInfo().isEnterprise()) {
            throw new InvalidConfigurationException("NATIVE storage format is supported in Hazelcast Enterprise only. Make sure you have Hazelcast Enterprise JARs on your classpath!");
        }
    }

    private static void checkPreloaderConfig(NearCacheConfig nearCacheConfig, boolean isClient) {
        if (!isClient && nearCacheConfig.getPreloaderConfig().isEnabled()) {
            throw new InvalidConfigurationException("The Near Cache pre-loader is just available on Hazelcast clients!");
        }
    }
}

